/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.MemoizingConnection;
import com.vmware.vise.data.adapters.core.RequestConverter;
import com.vmware.vise.data.adapters.core.ViseQueryExecutor;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.impl.Utils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceRiseModeAdapter
implements DynamicProviderAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceRiseModeAdapter.class);
    private final CoreQueryService _queryService;
    private final ViseQueryExecutor _queryExecutor;

    DataServiceRiseModeAdapter(CoreQueryService coreQueryService, QuerySchema querySchema, ExecutorService executorService) {
        assert (coreQueryService != null);
        assert (querySchema != null);
        assert (executorService != null);
        this._queryService = coreQueryService;
        RequestConverter requestConverter = new RequestConverter(querySchema);
        this._queryExecutor = new ViseQueryExecutor(requestConverter, executorService);
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        assert (requestSpec != null);
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        DynamicProviderResultSet[] dynamicProviderResultSetArray = new DynamicProviderResultSet[querySpecArray.length];
        MemoizingConnection memoizingConnection = new MemoizingConnection(this._queryService);
        long l = System.currentTimeMillis();
        for (int i = 0; i < querySpecArray.length; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            dynamicProviderResultSetArray[i] = this.executeQuery(memoizingConnection, querySpec);
        }
        if (_logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            _logger.debug("Entire request executed in {} ms", (Object)l2);
            _logger.debug("Core Data Service (RISE) returned results: \n{}", (Object)Utils.renderResultSets((com.vmware.vise.data.query.ResultSet[])dynamicProviderResultSetArray));
        }
        Response response = new Response();
        response.resultSet = dynamicProviderResultSetArray;
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicProviderResultSet executeQuery(CoreQueryService coreQueryService, QuerySpec querySpec) {
        try {
            String string = DataServiceRiseModeAdapter.toQueryId(querySpec.name);
            QueryMarker.setQueryId((String)string);
            CoreQueryService coreQueryService2 = this.createQSWrapperForViseQuery(coreQueryService, string);
            DynamicProviderResultSet dynamicProviderResultSet = this.processRiseQuery(coreQueryService2, querySpec);
            return dynamicProviderResultSet;
        }
        finally {
            QueryMarker.clearQueryId();
        }
    }

    private DynamicProviderResultSet processRiseQuery(CoreQueryService coreQueryService, QuerySpec querySpec) {
        assert (querySpec != null);
        long l = System.currentTimeMillis();
        DynamicProviderResultSet dynamicProviderResultSet = this._queryExecutor.execute(coreQueryService, querySpec);
        dynamicProviderResultSet.allowFallbackRequest = false;
        if (_logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            _logger.debug("Single query executed in {} ms", (Object)l2);
        }
        return dynamicProviderResultSet;
    }

    private CoreQueryService createQSWrapperForViseQuery(CoreQueryService coreQueryService, String string) {
        return new NestedQueryCounter(string, coreQueryService);
    }

    private static String toQueryId(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "anonymous-query";
        }
        return string;
    }

    private static final class NestedQueryCounter
    implements CoreQueryService {
        private final CoreQueryService _delegate;
        private final String _queryId;
        private final AtomicInteger _counter = new AtomicInteger(0);

        public NestedQueryCounter(String string, CoreQueryService coreQueryService) {
            this._delegate = coreQueryService;
            this._queryId = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResultSet executeQuery(Query query) {
            QueryMarker.setQueryId((String)(this._queryId + String.format(":%02d", this._counter.incrementAndGet())));
            try {
                ResultSet resultSet = this._delegate.executeQuery(query);
                return resultSet;
            }
            finally {
                QueryMarker.setQueryId((String)this._queryId);
            }
        }

        @Override
        public QuerySchema getSchema() {
            return this._delegate.getSchema();
        }
    }
}

