/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.vapi.std.DynamicID;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingIdConverter;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.search.model.ModelUtils;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class ReferenceConverter {
    public static Object toCoreModelKey(Object object) {
        Validate.notNull((Object)object);
        if (object instanceof ManagedObjectReference) {
            ReferenceConverter.validateMor((ManagedObjectReference)object);
            return object;
        }
        if (!(object instanceof URI) || !VapiUriSchemeUtil.isVapiUri((URI)((URI)object))) {
            throw new UnsupportedOperationException("Not supported VISE reference: " + object.toString());
        }
        String string = VapiUriSchemeUtil.getId((URI)((URI)object));
        return string;
    }

    public static Object toViseResourceReference(Object object, String string) {
        Validate.notNull((Object)object);
        Validate.notEmpty((String)string);
        if (ModelUtils.isVmodl2Name((String)string)) {
            return VapiUriSchemeUtil.createUri((String)string, (String)((String)object));
        }
        return object;
    }

    public static Object toCoreForeignKey(CoreForeignKeyType coreForeignKeyType, Object object, String string) {
        Validate.notNull((Object)((Object)coreForeignKeyType), (String)"keyType is required.");
        Validate.notNull((Object)object, (String)"coreModelKey is required.");
        Validate.notEmpty((String)string, (String)"resourceType is required.");
        switch (coreForeignKeyType) {
            case TYPED_ID: {
                if (object instanceof String) {
                    return new DynamicID(string, (String)object);
                }
                return object;
            }
            case MODEL_KEY: {
                return object;
            }
        }
        throw new IllegalStateException("Bug: unexpected CoreForeignKeyType: " + (Object)((Object)coreForeignKeyType));
    }

    public static CoreForeignKeyType getForeignKeyType(String string) {
        String string2 = "inventoryservice:InventoryServiceTagAssociation/entity";
        if (string.equals(string2)) {
            return CoreForeignKeyType.TYPED_ID;
        }
        return CoreForeignKeyType.MODEL_KEY;
    }

    public static Object coreForeignKeyToModelKey(Object object) {
        Validate.notNull((Object)object);
        if (object instanceof ManagedObjectReference || object instanceof URI) {
            return ReferenceConverter.toCoreModelKey(object);
        }
        if (object instanceof DynamicID) {
            return ((DynamicID)object).getId();
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalStateException(String.format("Unsupported core foreign key type: [%s] %s", object.getClass().getName(), object));
    }

    public static String getResourceObjectType(Object object) {
        Validate.notNull((Object)object);
        if (object instanceof ManagedObjectReference) {
            return ReferenceConverter.getResourceTypeFromMor((ManagedObjectReference)object);
        }
        if (object instanceof URI && VapiUriSchemeUtil.isVapiUri((URI)((URI)object))) {
            return VapiUriSchemeUtil.getType((URI)((URI)object));
        }
        String string = object == null ? "null" : String.format("[%s] %s", object.getClass().getName(), object.toString());
        throw new UnsupportedOperationException("Resource object unsupported by DS Core: " + string);
    }

    private static String getResourceTypeFromMor(ManagedObjectReference managedObjectReference) {
        assert (managedObjectReference != null);
        if (InventoryServiceTaggingIdConverter.isTaggingMor(managedObjectReference)) {
            return InventoryServiceTaggingIdConverter.getTaggingResourceType(managedObjectReference);
        }
        return managedObjectReference.getType();
    }

    private static void validateMor(ManagedObjectReference managedObjectReference) {
        if (StringUtils.isEmpty((String)managedObjectReference.getType())) {
            throw new IllegalArgumentException("MoRef type must be not null or empty");
        }
        if (StringUtils.isEmpty((String)managedObjectReference.getValue())) {
            throw new IllegalArgumentException("MoRef value must be not null or empty");
        }
        if (StringUtils.isEmpty((String)managedObjectReference.getServerGuid())) {
            throw new IllegalArgumentException("MoRef server guid must be not null or empty");
        }
    }

    public static enum CoreForeignKeyType {
        MODEL_KEY,
        TYPED_ID;

    }
}

