/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedInts;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.CoreResponse;
import com.vmware.vise.data.adapters.core.RelatedObjectPropertyValues;
import com.vmware.vise.data.adapters.core.ViseQueryExecutor;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

final class RelatedObjectOrderingValues {
    private final ViseQueryExecutor _queryExecutor;

    RelatedObjectOrderingValues(ViseQueryExecutor viseQueryExecutor) {
        this._queryExecutor = viseQueryExecutor;
    }

    CoreResponse.ResultChunk tryToEnrichWithRelatedOrderingInfos(CoreQueryService coreQueryService, CoreResponse.ResultChunk resultChunk, Multimap<String, CoreRequest.RelatedOrderingInfo> multimap) {
        if (!resultChunk.getChunkOrdering().equals((Object)CoreRequest.ChunkOrdering.CLIENT_SIDE) || multimap.isEmpty()) {
            return resultChunk;
        }
        ResultSet resultSet = resultChunk.getCoreResult();
        ResultChunkEnricher resultChunkEnricher = ResultChunkEnricher.of(resultChunk);
        for (String string : multimap.keySet()) {
            Multimap<Object, Object> multimap2 = RelatedObjectPropertyValues.gatherRelatedObjectIds(resultSet, string);
            Collection collection = multimap.get((Object)string);
            if (multimap2.isEmpty()) {
                this.populateWithEmptyResultValues(resultChunkEnricher, string, collection);
                continue;
            }
            for (CoreRequest.RelatedOrderingInfo relatedOrderingInfo : collection) {
                Table<Object, String, Object> table = this.gatherRelatedPropertyValues(coreQueryService, multimap2, relatedOrderingInfo);
                this.populateWithResultValues(resultChunkEnricher, string, relatedOrderingInfo, table);
            }
        }
        CoreResponse.ResultChunk resultChunk2 = resultChunkEnricher.getEnrichedResultChunk();
        return resultChunk2;
    }

    private void populateWithResultValues(ResultChunkEnricher resultChunkEnricher, String string, CoreRequest.RelatedOrderingInfo relatedOrderingInfo, Table<Object, String, Object> table) {
        for (String string2 : relatedOrderingInfo.viseProperties) {
            String string3 = this.getRelatedCoreProperty(string, relatedOrderingInfo.viseRelation, string2);
            Map map = table.column((Object)string2);
            resultChunkEnricher.withResultValues(string3, map, relatedOrderingInfo.position, relatedOrderingInfo.direction);
        }
    }

    private Table<Object, String, Object> gatherRelatedPropertyValues(CoreQueryService coreQueryService, Multimap<Object, Object> multimap, CoreRequest.RelatedOrderingInfo relatedOrderingInfo) {
        Set set = multimap.keySet();
        QuerySpec querySpec = RelatedObjectPropertyValues.buildQueryFor(set, relatedOrderingInfo.viseRelation, relatedOrderingInfo.viseProperties);
        DynamicProviderResultSet dynamicProviderResultSet = this._queryExecutor.execute(coreQueryService, querySpec);
        return this.gatherRelatedPropertyValues(multimap, dynamicProviderResultSet);
    }

    private Table<Object, String, Object> gatherRelatedPropertyValues(Multimap<Object, Object> multimap, DynamicProviderResultSet dynamicProviderResultSet) {
        HashBasedTable hashBasedTable = HashBasedTable.create();
        if (ArrayUtils.isEmpty((Object[])dynamicProviderResultSet.items)) {
            return ImmutableTable.of();
        }
        for (ResultItem resultItem : dynamicProviderResultSet.items) {
            if (resultItem == null || ArrayUtils.isEmpty((Object[])resultItem.properties) || resultItem.resourceObject == null) continue;
            Collection collection = multimap.get(resultItem.resourceObject);
            for (PropertyValue propertyValue : resultItem.properties) {
                for (Object e : collection) {
                    hashBasedTable.put(e, (Object)propertyValue.propertyName, propertyValue.value);
                }
            }
        }
        return hashBasedTable;
    }

    private String getRelatedCoreProperty(String string, String string2, String string3) {
        int n = new HashCodeBuilder().append((Object)string2).append((Object)string3).hashCode();
        long l = UnsignedInts.toLong((int)n);
        String string4 = string + "/@" + l;
        assert (QualifiedProperty.isSyntacticallyQualified((String)string4));
        return string4;
    }

    private void populateWithEmptyResultValues(ResultChunkEnricher resultChunkEnricher, String string, Collection<CoreRequest.RelatedOrderingInfo> collection) {
        for (CoreRequest.RelatedOrderingInfo relatedOrderingInfo : collection) {
            for (String string2 : relatedOrderingInfo.viseProperties) {
                String string3 = this.getRelatedCoreProperty(string, relatedOrderingInfo.viseRelation, string2);
                resultChunkEnricher.withEmptyResultValues(string3, relatedOrderingInfo.position, relatedOrderingInfo.direction);
            }
        }
    }

    private static final class ResultChunkEnricher {
        private final List<String> _properties;
        private final Map<Object, List<Object>> _propertyValuesByItemKey;
        private final CoreResponse.ResultChunk _originalResultChunk;
        private final Map<Integer, SortCriterion> _relatedSortCriterionsByPosition = new HashMap<Integer, SortCriterion>();

        private ResultChunkEnricher(CoreResponse.ResultChunk resultChunk) {
            this._originalResultChunk = resultChunk;
            ResultSet resultSet = resultChunk.getCoreResult();
            this._properties = new ArrayList<String>(resultSet.getProperties());
            this._propertyValuesByItemKey = this.toPropertyValuesByItemKey(resultSet);
        }

        static ResultChunkEnricher of(CoreResponse.ResultChunk resultChunk) {
            assert (resultChunk != null);
            return new ResultChunkEnricher(resultChunk);
        }

        void withResultValues(String string, Map<Object, Object> map, int n, SortCriterion.SortDirection sortDirection) {
            this._properties.add(string);
            for (Object object : this._propertyValuesByItemKey.keySet()) {
                Object object2 = map.get(object);
                List<Object> list = this._propertyValuesByItemKey.get(object);
                list.add(object2);
            }
            this.withRelatedSortCriteria(string, n, sortDirection);
        }

        void withEmptyResultValues(String string, int n, SortCriterion.SortDirection sortDirection) {
            this._properties.add(string);
            for (Object object : this._propertyValuesByItemKey.keySet()) {
                List<Object> list = this._propertyValuesByItemKey.get(object);
                list.add(null);
            }
            this.withRelatedSortCriteria(string, n, sortDirection);
        }

        private void withRelatedSortCriteria(String string, int n, SortCriterion.SortDirection sortDirection) {
            SortCriterion sortCriterion = new SortCriterion(string, sortDirection, true);
            this._relatedSortCriterionsByPosition.put(n, sortCriterion);
        }

        CoreResponse.ResultChunk getEnrichedResultChunk() {
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
            for (List<Object> resultSet2 : this._propertyValuesByItemKey.values()) {
                arrayList.add(resultSet2);
            }
            ResultSet resultSet3 = this._originalResultChunk.getCoreResult();
            ResultSet resultSet = ResultSet.Builder.properties(this._properties).items(arrayList).totalCount(resultSet3.getTotalCount()).build();
            List<SortCriterion> list = this.mergeSortCriteria(this._originalResultChunk.getSortClauseProjection(), this._relatedSortCriterionsByPosition);
            return new CoreResponse.ResultChunk(resultSet, this._originalResultChunk.getReturnByCoreNameMapping(), this._originalResultChunk.getRelatedValuesByItemKey(), this._originalResultChunk.getChunkOrdering(), list);
        }

        private List<SortCriterion> mergeSortCriteria(List<SortCriterion> list, Map<Integer, SortCriterion> map) {
            LinkedList<SortCriterion> linkedList = new LinkedList<SortCriterion>(list);
            for (Integer n : map.keySet()) {
                SortCriterion sortCriterion = map.get(n);
                linkedList.add(n, sortCriterion);
            }
            return linkedList;
        }

        private Map<Object, List<Object>> toPropertyValuesByItemKey(ResultSet resultSet) {
            int n = resultSet.getProperties().indexOf("@modelKey");
            LinkedHashMap<Object, List<Object>> linkedHashMap = new LinkedHashMap<Object, List<Object>>(resultSet.getItems().size());
            for (ResourceItem resourceItem : resultSet.getItems()) {
                Object e = resourceItem.getPropertyValues().get(n);
                linkedHashMap.put(e, new ArrayList(resourceItem.getPropertyValues()));
            }
            return linkedHashMap;
        }
    }
}

