/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.CoreResponse;
import com.vmware.vise.data.adapters.core.CurrentObjectPropertyFacets;
import com.vmware.vise.data.adapters.core.RelatedObjectOrderingValues;
import com.vmware.vise.data.adapters.core.RelatedObjectPropertyFacets;
import com.vmware.vise.data.adapters.core.RelatedObjectPropertyValues;
import com.vmware.vise.data.adapters.core.RequestConverter;
import com.vmware.vise.data.adapters.core.ResponseConverter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.FacetValue;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViseQueryExecutor {
    private static final Logger _logger = LoggerFactory.getLogger(ViseQueryExecutor.class);
    private final RequestConverter _requestConverter;
    private final ExecutorService _executorService;
    private final ResponseConverter _responseConverter;
    private final RelatedObjectPropertyValues _relatedObjectPropertyValues;
    private final RelatedObjectOrderingValues _relatedObjectOrderingValues;

    public ViseQueryExecutor(RequestConverter requestConverter, ExecutorService executorService) {
        assert (requestConverter != null);
        assert (executorService != null);
        this._requestConverter = requestConverter;
        this._responseConverter = new ResponseConverter();
        this._executorService = executorService;
        this._relatedObjectPropertyValues = new RelatedObjectPropertyValues(this);
        this._relatedObjectOrderingValues = new RelatedObjectOrderingValues(this);
    }

    public DynamicProviderResultSet execute(CoreQueryService coreQueryService, QuerySpec querySpec) {
        String string = querySpec.name;
        try {
            ResultSet resultSet;
            Object object;
            CoreRequest coreRequest = this._requestConverter.toCoreRequest(coreQueryService, querySpec);
            ChunkedResult chunkedResult = this.executeChunkQueries(coreQueryService, coreRequest);
            List<ResultSet> list = chunkedResult.resultSets;
            ArrayList<CoreResponse.ResultChunk> arrayList = new ArrayList<CoreResponse.ResultChunk>(coreRequest.getChunkQueries().size());
            ArrayList<CurrentObjectPropertyFacets.ResutlSetFacetSpec> arrayList2 = new ArrayList<CurrentObjectPropertyFacets.ResutlSetFacetSpec>(coreRequest.getChunkQueries().size());
            for (int i = 0; i < list.size(); ++i) {
                object = coreRequest.getChunkQueries().get(i);
                resultSet = list.get(i);
                Multimap<Object, PropertyValue> multimap = this._relatedObjectPropertyValues.gatherRelatedPropertyValues(coreQueryService, resultSet, ((CoreRequest.ChunkQuery)object).getRelatedPropertyInfosByCoreRelation());
                CoreResponse.ResultChunk resultChunk = new CoreResponse.ResultChunk(resultSet, ((CoreRequest.ChunkQuery)object).getReturnByCoreNameMapping(), multimap, ((CoreRequest.ChunkQuery)object).getChunkOrdering(), ((CoreRequest.ChunkQuery)object).getSortClauseProjection());
                resultChunk = this._relatedObjectOrderingValues.tryToEnrichWithRelatedOrderingInfos(coreQueryService, resultChunk, ((CoreRequest.ChunkQuery)object).getRelatedOrderingInfosByCoreRelation());
                arrayList.add(resultChunk);
                arrayList2.add(new CurrentObjectPropertyFacets.ResutlSetFacetSpec(resultSet, ((CoreRequest.ChunkQuery)object).getFacetByCoreNameMapping()));
            }
            CoreResponse coreResponse = new CoreResponse(arrayList, coreRequest.getOffset(), coreRequest.getLimit());
            object = this.getFacetInfos(coreQueryService, querySpec, list, arrayList2);
            resultSet = this._responseConverter.toViseResponse(string, coreResponse, (List<FacetInfo>)object, chunkedResult.error);
            return resultSet;
        }
        catch (RuntimeException runtimeException) {
            return this._responseConverter.toViseResponse(string, runtimeException);
        }
    }

    private ChunkedResult executeChunkQueries(final CoreQueryService coreQueryService, CoreRequest coreRequest) {
        List list;
        Object object;
        List<ChunkQueryPos> list22;
        if (coreRequest.getChunkQueries().isEmpty()) {
            return ChunkedResult.empty;
        }
        List<CoreRequest.ChunkQuery> list3 = coreRequest.getChunkQueries();
        final ResultSet[] resultSetArray = new ResultSet[list3.size()];
        Collection<List<ChunkQueryPos>> collection = this.splitChunksByTargetService(list3);
        ArrayList<1> arrayList = new ArrayList<1>(collection.size());
        for (final List<ChunkQueryPos> list22 : collection) {
            object = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (ChunkQueryPos chunkQueryPos : list22) {
                        Query query = chunkQueryPos.chunkQuery.getCoreQuery();
                        try {
                            resultSetArray[chunkQueryPos.position] = coreQueryService.executeQuery(query);
                        }
                        catch (Exception exception) {
                            _logger.error("Execution of ChunkQuery has failed: {} {}\n{}", new Object[]{exception.getClass(), exception.getMessage(), query, exception});
                            throw exception;
                        }
                    }
                    return null;
                }
            };
            arrayList.add(object);
        }
        try {
            list = ExecutorUtil.executeTasks(arrayList, (Executor)this._executorService, (long)-1L, (TimeUnit)TimeUnit.MILLISECONDS, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("The query execution was interrupted.", interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException("Internal error/bug: timed out when no time limit was specified.", timeoutException);
        }
        list22 = new ArrayList<ChunkQueryPos>();
        object = list.iterator();
        while (object.hasNext()) {
            ExecutorUtil.TaskResult taskResult = (ExecutorUtil.TaskResult)object.next();
            if (taskResult.getException() == null) continue;
            list22.add((ChunkQueryPos)((Object)taskResult.getException()));
        }
        object = null;
        if (!list22.isEmpty()) {
            object = ViseQueryExecutor.toAggregatedError(list22);
            boolean bl = false;
            for (int i = 0; i < resultSetArray.length; ++i) {
                if (resultSetArray[i] == null) {
                    resultSetArray[i] = ResultSet.EMPTY_RESULT;
                    continue;
                }
                bl = true;
            }
            if (!bl) {
                throw object;
            }
        }
        return new ChunkedResult(Arrays.asList(resultSetArray), (Exception)object);
    }

    private List<FacetInfo> getFacetInfos(CoreQueryService coreQueryService, QuerySpec querySpec, List<ResultSet> list, List<CurrentObjectPropertyFacets.ResutlSetFacetSpec> list2) {
        List<FacetInfo> list3 = new CurrentObjectPropertyFacets().get(list2);
        List<FacetInfo> list4 = new RelatedObjectPropertyFacets(this).get(coreQueryService, list, querySpec.resultSpec);
        List<FacetInfo> list5 = this.reorderFacetInfoPerResultSpec(querySpec.resultSpec, Iterables.concat(list3, list4));
        return list5;
    }

    private List<FacetInfo> reorderFacetInfoPerResultSpec(ResultSpec resultSpec, Iterable<FacetInfo> iterable) {
        if (resultSpec == null || ArrayUtils.isEmpty((Object[])resultSpec.facets)) {
            return Collections.emptyList();
        }
        ArrayList<FacetInfo> arrayList = new ArrayList<FacetInfo>();
        for (FacetSpec facetSpec : resultSpec.facets) {
            arrayList.add(this.findInfoForPropertySpec(iterable, facetSpec.propSpec));
        }
        return arrayList;
    }

    private FacetInfo findInfoForPropertySpec(Iterable<FacetInfo> iterable, PropertySpec propertySpec) {
        for (FacetInfo facetInfo : iterable) {
            if (!facetInfo.propSpec.equals((Object)propertySpec)) continue;
            return facetInfo;
        }
        FacetInfo facetInfo = new FacetInfo();
        facetInfo.propSpec = propertySpec;
        facetInfo.facetValues = new FacetValue[0];
        return facetInfo;
    }

    private Collection<List<ChunkQueryPos>> splitChunksByTargetService(List<CoreRequest.ChunkQuery> list) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (int i = 0; i < list.size(); ++i) {
            CoreRequest.ChunkQuery chunkQuery = list.get(i);
            Collection collection = chunkQuery.getCoreQuery().getResourceModels();
            int n = this.containsTaggingModel(collection) ? 0 : (ModelUtils.hasVmodl2Name((Collection)collection) ? 1 : 2);
            arrayListMultimap.put((Object)n, (Object)new ChunkQueryPos(i, chunkQuery));
        }
        return Multimaps.asMap((ListMultimap)arrayListMultimap).values();
    }

    private boolean containsTaggingModel(Collection<String> collection) {
        for (String string : collection) {
            if (!string.contains("inventoryservice:")) continue;
            return true;
        }
        return false;
    }

    private static RuntimeException toAggregatedError(List<Throwable> list) {
        assert (!list.isEmpty());
        if (list.size() == 1) {
            return ViseQueryExecutor.toRuntimeException(list.iterator().next());
        }
        StringBuilder stringBuilder = new StringBuilder("There were errors during query exectuion");
        for (Throwable object : list) {
            stringBuilder.append("\n\t").append(object.getMessage());
        }
        RuntimeException runtimeException = new RuntimeException(stringBuilder.toString());
        for (Throwable throwable : list) {
            runtimeException.addSuppressed(throwable);
        }
        return runtimeException;
    }

    private static RuntimeException toRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable.getMessage(), throwable);
    }

    private static final class ChunkedResult {
        final List<ResultSet> resultSets;
        final Exception error;
        static final ChunkedResult empty = new ChunkedResult(Collections.emptyList(), null);

        ChunkedResult(List<ResultSet> list, Exception exception) {
            this.resultSets = list;
            this.error = exception;
        }
    }

    private static final class ChunkQueryPos {
        final int position;
        final CoreRequest.ChunkQuery chunkQuery;

        ChunkQueryPos(int n, CoreRequest.ChunkQuery chunkQuery) {
            this.position = n;
            this.chunkQuery = chunkQuery;
        }
    }
}

