/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vise.data.adapters.core.VapiPropertyTypeResolver;
import com.vmware.vise.search.vapi.Vmodl2PropertyUnmarshaller;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

final class ViseVapiPropertyValueConverter
implements VapiPropertyValueConverter {
    private static final ResourceModelTypeProvider _vapiBuiltinTypes = new Vmodl2PropertyUnmarshaller.VapiBuiltinTypesProvider();
    private final ResourceModelTypeProvider _vapiTypeProvider;
    private final TypeConverter _vapiTypeConverter;

    ViseVapiPropertyValueConverter(ResourceModelTypeProvider resourceModelTypeProvider) {
        Validate.notNull((Object)resourceModelTypeProvider);
        this._vapiTypeProvider = resourceModelTypeProvider;
        this._vapiTypeConverter = new TypeConverterImpl((ConverterFactory)new DefaultConverterFactory(new NameToTypeResolver(){

            public Type resolve(String string) {
                StructType structType = ViseVapiPropertyValueConverter.this._vapiTypeProvider.getResourceModelType(string);
                if (structType != null) {
                    return structType;
                }
                return _vapiBuiltinTypes.getResourceModelType(string);
            }
        }));
    }

    public Object fromVapiResultDataValue(String string, DataValue dataValue) {
        assert (string != null);
        if (dataValue == null) {
            return null;
        }
        Type type = this.fixOptionals(this.getVapiTypeOfProperty(string), dataValue);
        if (type != null) {
            return this.toBinding(dataValue, type, string);
        }
        return this.fromUntypedDataValue(dataValue);
    }

    public DataValue toVapiComparableValue(String string, Object object) {
        assert (string != null);
        assert (object != null);
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return new IntegerValue(n.longValue());
        }
        if (object instanceof Long) {
            return new IntegerValue(((Long)object).longValue());
        }
        if (object instanceof Boolean) {
            return BooleanValue.getInstance((boolean)((Boolean)object));
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return new DoubleValue(f.doubleValue());
        }
        if (object instanceof Double) {
            return new DoubleValue(((Double)object).doubleValue());
        }
        if (object instanceof ApiEnumeration) {
            return new StringValue(((ApiEnumeration)object).name());
        }
        throw new IllegalArgumentException("Unsupported comparable value type " + object.getClass());
    }

    public List<DataValue> toVapiComparableList(String string, List<?> list) {
        assert (string != null);
        assert (list != null);
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>(list.size());
        for (Object obj : list) {
            arrayList.add(this.toVapiComparableValue(string, obj));
        }
        return arrayList;
    }

    private Type fixOptionals(Type type, DataValue dataValue) {
        if (type == null) {
            return null;
        }
        if (type instanceof OptionalType && !(dataValue instanceof OptionalValue)) {
            return ((OptionalType)type).getElementType();
        }
        return type;
    }

    private Object toBinding(DataValue dataValue, Type type, String string) {
        try {
            return this._vapiTypeConverter.convertToJava(dataValue, type);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException("Could not convert value of property " + string, runtimeException);
        }
    }

    private Object fromUntypedDataValue(DataValue dataValue) {
        if (dataValue instanceof StringValue) {
            return ((StringValue)dataValue).getValue();
        }
        if (dataValue instanceof IntegerValue) {
            return ((IntegerValue)dataValue).getValue();
        }
        if (dataValue instanceof BooleanValue) {
            return ((BooleanValue)dataValue).getValue();
        }
        if (dataValue instanceof SecretValue) {
            return ((SecretValue)dataValue).getValue();
        }
        if (dataValue instanceof DoubleValue) {
            return ((DoubleValue)dataValue).getValue();
        }
        if (dataValue instanceof BlobValue) {
            return ((BlobValue)dataValue).getValue();
        }
        return dataValue;
    }

    private Type getVapiTypeOfProperty(String string) {
        assert (string != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return null;
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string);
        String string2 = ViseVapiPropertyValueConverter.toCanonicalName(qualifiedProperty.getResourceModel());
        StructType structType = this._vapiTypeProvider.getResourceModelType(string2);
        if (structType == null) {
            return null;
        }
        Type type = VapiPropertyTypeResolver.resolvePropertyType(structType, qualifiedProperty.getSimpleProperty());
        return type;
    }

    private static String toCanonicalName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isUpperCase(c2)) {
                if (Character.isLowerCase(c)) {
                    stringBuilder.append('_');
                }
                stringBuilder.append(Character.toLowerCase(c2));
            } else {
                stringBuilder.append(c2);
            }
            c = c2;
        }
        return stringBuilder.toString();
    }
}

