/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public final class InventoryServiceTaggingIdConverter {
    private static final char ID_PART_SEPARATOR_CHAR = ':';
    private static final String ID_PART_SEPARATOR = Character.toString(':');
    private static final String VMOMI_ID_PART_0 = "urn";
    private static final String VMOMI_ID_PART_1 = "vmomi";
    private static final String VMOMI_ID_PREFIX = "urn" + ID_PART_SEPARATOR + "vmomi" + ID_PART_SEPARATOR;
    private static final String MO_TYPE_TAG = "InventoryServiceTag";
    private static final String MO_TYPE_CATEGORY = "InventoryServiceCategory";
    private static final String RESOURCE_TYPE_TAG = "inventoryservice:InventoryServiceTag";
    private static final String RESOURCE_TYPE_CATEGORY = "inventoryservice:InventoryServiceCategory";

    public static boolean isTaggingMor(ManagedObjectReference managedObjectReference) {
        Validate.notNull((Object)managedObjectReference);
        return MO_TYPE_TAG.equals(managedObjectReference.getType()) || MO_TYPE_CATEGORY.equals(managedObjectReference.getType());
    }

    public static boolean isTaggingResourceType(String string) {
        Validate.notEmpty((String)string);
        return RESOURCE_TYPE_TAG.equals(string) || RESOURCE_TYPE_CATEGORY.equals(string);
    }

    public static String getTaggingResourceType(ManagedObjectReference managedObjectReference) {
        Validate.notNull((Object)managedObjectReference);
        switch (managedObjectReference.getType()) {
            case "InventoryServiceTag": {
                return RESOURCE_TYPE_TAG;
            }
            case "InventoryServiceCategory": {
                return RESOURCE_TYPE_CATEGORY;
            }
        }
        throw new IllegalStateException("Unknown tagging mo type: " + managedObjectReference.getType());
    }

    public static String taggingMorToId(ManagedObjectReference managedObjectReference) {
        Validate.notNull((Object)managedObjectReference);
        return VMOMI_ID_PREFIX + managedObjectReference.getType() + ID_PART_SEPARATOR + managedObjectReference.getValue() + ID_PART_SEPARATOR + managedObjectReference.getServerGuid();
    }

    public static ManagedObjectReference taggingIdToMor(String string) {
        boolean bl;
        Validate.notEmpty((String)string);
        String[] stringArray = string.split(ID_PART_SEPARATOR);
        boolean bl2 = bl = stringArray.length == 5 && VMOMI_ID_PART_0.equals(stringArray[0]) && VMOMI_ID_PART_1.equals(stringArray[1]) && !stringArray[2].isEmpty() && !stringArray[3].isEmpty() && !stringArray[4].isEmpty();
        if (!bl) {
            throw new IllegalArgumentException(String.format("Invalid tagging id: '%s'", string));
        }
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        String string4 = stringArray[4];
        return new ManagedObjectReference(string2, string3, string4);
    }

    public static ManagedObjectReference[] taggingIdsToMorArray(Collection<String> collection) {
        Validate.notNull(collection);
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[collection.size()];
        int n = 0;
        for (String string : collection) {
            managedObjectReferenceArray[n++] = InventoryServiceTaggingIdConverter.taggingIdToMor(string);
        }
        return managedObjectReferenceArray;
    }
}

