/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vim.binding.dataservice.tagging.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.tagging.FixedValueTranslator;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingIdConverter;
import com.vmware.vise.data.adapters.core.tagging.ModelKeyAndTypeModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.ModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.NameAndValuePropertyTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslatingConnection;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyValueTranslator;
import com.vmware.vise.search.model.ModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class InventoryServiceTaggingQueryModel {
    public static final String MODEL_INVSVC_TAG = "inventoryservice:InventoryServiceTag";
    public static final String MODEL_INVSVC_CATEGORY = "inventoryservice:InventoryServiceCategory";
    public static final String MODEL_INVSVC_TAG_ASSOCIATION = "inventoryservice:InventoryServiceTagAssociation";
    public static final String PROPERTY_INVSVC_TAG_NAME = "inventoryservice:InventoryServiceTag/name";
    public static final String PROPERTY_INVSVC_TAG_DESCRIPTION = "inventoryservice:InventoryServiceTag/description";
    public static final String PROPERTY_INVSVC_TAG_CATEGORY = "inventoryservice:InventoryServiceTag/category";
    public static final String PROPERTY_INVSVC_TAG_CATEGORY_NAME = "inventoryservice:InventoryServiceTag/categoryName";
    public static final String PROPERTY_INVSVC_CATEGORY_NAME = "inventoryservice:InventoryServiceCategory/name";
    public static final String PROPERTY_INVSVC_CATEGORY_DESCRIPTION = "inventoryservice:InventoryServiceCategory/description";
    public static final String PROPERTY_INVSVC_CATEGORY_MULTIPLE_CARDINALITY = "inventoryservice:InventoryServiceCategory/multipleCardinality";
    public static final String PROPERTY_INVSVC_CATEGORY_CHILD_TAGS = "inventoryservice:InventoryServiceCategory/childTags";
    public static final String PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE = "inventoryservice:InventoryServiceCategory/associableEntityType";
    public static final String PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE_NAME = "inventoryservice:InventoryServiceCategory/associableEntityTypeName";
    public static final String PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_WITH_ALL = "inventoryservice:InventoryServiceCategory/associableWithAllEntityTypes";
    public static final String SIMPLE_PROPERTY_TAG = "tag";
    public static final String SIMPLE_PROPERTY_ENTITY = "entity";
    public static final String PROPERTY_INVSVC_TAG_ASSOCIATION_TAG = "inventoryservice:InventoryServiceTagAssociation/tag";
    public static final String PROPERTY_INVSVC_TAG_ASSOCIATION_ENTITY = "inventoryservice:InventoryServiceTagAssociation/entity";
    public static final String RELATION_INVSVC_TAG = "inventoryservice:tag";
    public static final String RELATION_ENTITY = "entity";
    private static Map<String, ModelTranslator> TRANSLATOR_BY_MODEL;
    private static Map<String, PropertyTranslator> TRANSLATOR_BY_PROPERTY;

    public static CoreQueryService withInvSvcTagging(CoreQueryService coreQueryService) {
        Validate.notNull((Object)coreQueryService);
        return new PropertyTranslatingConnection(coreQueryService, TRANSLATOR_BY_MODEL, TRANSLATOR_BY_PROPERTY);
    }

    static {
        VmodlTypeMap vmodlTypeMap = new HashMap();
        vmodlTypeMap.put(MODEL_INVSVC_TAG, new ModelKeyAndTypeModelTranslator("com.vmware.cis.tagging.TagModel", new MorToId(), new FixedValueTranslator("com.vmware.cis.tagging.Tag", MODEL_INVSVC_TAG)));
        vmodlTypeMap.put(MODEL_INVSVC_CATEGORY, new ModelKeyAndTypeModelTranslator("com.vmware.cis.tagging.CategoryModel", new MorToId(), new FixedValueTranslator("com.vmware.cis.tagging.Category", MODEL_INVSVC_CATEGORY)));
        vmodlTypeMap.put(MODEL_INVSVC_TAG_ASSOCIATION, new ModelKeyAndTypeModelTranslator("com.vmware.cis.tagging.TagAssociationModel", new MorToId(), new FixedValueTranslator("com.vmware.cis.tagging.TagAssociation", MODEL_INVSVC_TAG_ASSOCIATION)));
        TRANSLATOR_BY_MODEL = Collections.unmodifiableMap(vmodlTypeMap);
        vmodlTypeMap = new HashMap();
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_NAME, NameAndValuePropertyTranslator.aliasOf("com.vmware.cis.tagging.TagModel/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING)));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_DESCRIPTION, NameAndValuePropertyTranslator.aliasOf("com.vmware.cis.tagging.TagModel/description", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING)));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_CATEGORY, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.TagModel/categoryId", new MorToId(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID)));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_CATEGORY_NAME, NameAndValuePropertyTranslator.aliasOf("com.vmware.cis.tagging.TagModel/categoryName", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING)));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_NAME, NameAndValuePropertyTranslator.aliasOf("com.vmware.cis.tagging.CategoryModel/name", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING)));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_DESCRIPTION, NameAndValuePropertyTranslator.aliasOf("com.vmware.cis.tagging.CategoryModel/description", QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.STRING)));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_MULTIPLE_CARDINALITY, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.CategoryModel/cardinality", new CategoryMultipleCardinality(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.BOOLEAN)));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_CHILD_TAGS, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.CategoryModel/tags", new MorArrayToIdCollection(), QuerySchema.PropertyInfo.forNonFilterableProperty()));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.CategoryModel/associableTypes", new CategoryAssociableEntityType(), QuerySchema.PropertyInfo.forNonFilterableProperty()));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE_NAME, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.CategoryModel/associableTypes", new CategoryAssociableEntityType(), QuerySchema.PropertyInfo.forNonFilterableProperty()));
        vmodlTypeMap.put(PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_WITH_ALL, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.CategoryModel/associableTypes", new CategoryAssociableWithAllEntityTypes(), QuerySchema.PropertyInfo.forNonFilterableProperty()));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_ASSOCIATION_TAG, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.TagAssociationModel/tagId", new MorToId(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID)));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_ASSOCIATION_ENTITY, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.TagAssociationModel/objectId", new AssociationEntity(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID)));
        TRANSLATOR_BY_PROPERTY = Collections.unmodifiableMap(vmodlTypeMap);
        vmodlTypeMap = VmodlTypeMap.Factory.getTypeMap();
        String string = Tag.class.getAnnotation(wsdlName.class).value();
        VmodlType vmodlType = vmodlTypeMap.getVmodlType(string);
        if (vmodlType == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(InventoryServiceTaggingQueryModel.class.getClassLoader());
            try {
                VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.dataservice"});
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalStateException("Could not load VMODL1 bindings for Tagging into the global VMODL1 context", runtimeException);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    private static final class CategoryAssociableWithAllEntityTypes
    implements PropertyValueTranslator {
        private CategoryAssociableWithAllEntityTypes() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            throw new UnsupportedOperationException("Property is not filterable: " + string);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            Collection collection = (Collection)object;
            return new Object[]{collection.isEmpty()};
        }
    }

    private static final class CategoryAssociableEntityType
    implements PropertyValueTranslator {
        private CategoryAssociableEntityType() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            throw new UnsupportedOperationException("Property is not filterable: " + string);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            assert (object instanceof Collection);
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return null;
            }
            return collection.toArray();
        }
    }

    private static final class CategoryMultipleCardinality
    implements PropertyValueTranslator {
        private static final String CARDINALITY_MULTIPLE = "MULTIPLE";
        private static final String CARDINALITY_SINGLE = "SINGLE";

        private CategoryMultipleCardinality() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            Boolean bl;
            Validate.notNull((Object)object);
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else if (object instanceof String) {
                bl = Boolean.valueOf((String)object);
            } else {
                throw new IllegalArgumentException(String.format("Unexpected comparable value for property '%s' : %s", InventoryServiceTaggingQueryModel.PROPERTY_INVSVC_CATEGORY_MULTIPLE_CARDINALITY, object.getClass()));
            }
            return bl != false ? CARDINALITY_MULTIPLE : CARDINALITY_SINGLE;
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(String.format("Unexpected value for property '%s' : %s", "com.vmware.cis.tagging.CategoryModel/cardinality", object.getClass()));
            }
            return CARDINALITY_MULTIPLE.equals(object);
        }
    }

    private static final class MorArrayToIdCollection
    implements PropertyValueTranslator {
        private MorArrayToIdCollection() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            throw new IllegalArgumentException("Cannot filter by array property " + string);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof Collection)) {
                throw new IllegalArgumentException(String.format("Expected java.util.Collection value for property '%s' but found: ", string, object.getClass()));
            }
            Collection collection = (Collection)object;
            return InventoryServiceTaggingIdConverter.taggingIdsToMorArray(collection);
        }
    }

    private static final class AssociationEntity
    implements PropertyValueTranslator {
        private AssociationEntity() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            assert (object != null);
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<DynamicID> arrayList = new ArrayList<DynamicID>(collection.size());
                for (Object e : collection) {
                    arrayList.add(AssociationEntity.toDynamicID(string, e));
                }
                return arrayList;
            }
            return AssociationEntity.toDynamicID(string, object);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof DynamicID)) {
                throw new IllegalArgumentException(String.format("Expected DynamicID value for property '%s' but found ", string, object.getClass()));
            }
            DynamicID dynamicID = (DynamicID)object;
            if (ModelUtils.isVmodl2Name((String)dynamicID.getType())) {
                return dynamicID;
            }
            return CisIdConverter.fromGlobalCisId((String)dynamicID.getId(), (String)dynamicID.getType());
        }

        private static DynamicID toDynamicID(String string, Object object) {
            assert (object != null);
            if (object instanceof DynamicID) {
                return (DynamicID)object;
            }
            if (object instanceof ManagedObjectReference) {
                ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
                String string2 = managedObjectReference.getType();
                String string3 = CisIdConverter.toGlobalCisId((ManagedObjectReference)managedObjectReference, (String)managedObjectReference.getServerGuid());
                return new DynamicID(string2, string3);
            }
            throw new IllegalArgumentException(String.format("Unexpected comparable value for property '%s': %s", string, object.getClass()));
        }
    }

    private static final class MorToId
    implements PropertyValueTranslator {
        private MorToId() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<String> arrayList = new ArrayList<String>(collection.size());
                for (Object e : collection) {
                    arrayList.add(MorToId.toId(string, e));
                }
                return arrayList;
            }
            return MorToId.toId(string, object);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            assert (object instanceof String);
            String string2 = (String)object;
            return InventoryServiceTaggingIdConverter.taggingIdToMor(string2);
        }

        private static String toId(String string, Object object) {
            assert (object != null);
            if (!(object instanceof ManagedObjectReference)) {
                throw new IllegalArgumentException(String.format("Expected ManagedObjectReference comparable value for property '%s' but found ", string, object.getClass()));
            }
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return InventoryServiceTaggingIdConverter.taggingMorToId(managedObjectReference);
        }
    }
}

