/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyValueTranslator;

final class NameAndValuePropertyTranslator
implements PropertyTranslator {
    private static final PropertyValueTranslator NO_CONVERT = new PropertyValueTranslator(){

        @Override
        public Object onPropertyValue(String string, Object object) {
            return object;
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            return object;
        }
    };
    private final String _property;
    private final PropertyValueTranslator _valueTranslator;
    private final QuerySchema.PropertyInfo _propertyInfo;

    static PropertyTranslator aliasOf(String string, QuerySchema.PropertyInfo propertyInfo) {
        return new NameAndValuePropertyTranslator(string, NO_CONVERT, propertyInfo);
    }

    static PropertyTranslator derivedFrom(String string, PropertyValueTranslator propertyValueTranslator, QuerySchema.PropertyInfo propertyInfo) {
        return new NameAndValuePropertyTranslator(string, propertyValueTranslator, propertyInfo);
    }

    NameAndValuePropertyTranslator(String string, PropertyValueTranslator propertyValueTranslator, QuerySchema.PropertyInfo propertyInfo) {
        assert (string != null);
        assert (propertyValueTranslator != null);
        assert (propertyInfo != null);
        this._property = string;
        this._valueTranslator = propertyValueTranslator;
        this._propertyInfo = propertyInfo;
    }

    @Override
    public QuerySchema.PropertyInfo getPropertyInfo() {
        return this._propertyInfo;
    }

    @Override
    public String onSelectedProperty(String string) {
        assert (string != null);
        return this._property;
    }

    @Override
    public SortCriterion onSortCriterion(SortCriterion sortCriterion) {
        assert (sortCriterion != null);
        if (!this._propertyInfo.getFilterable()) {
            throw new IllegalArgumentException("Cannot sort by property " + sortCriterion.getProperty());
        }
        return new SortCriterion(this._property, sortCriterion.getSortDirection(), sortCriterion.isIgnoreCase());
    }

    @Override
    public PropertyPredicate onPropertyPredicate(PropertyPredicate propertyPredicate) {
        assert (propertyPredicate != null);
        if (!this._propertyInfo.getFilterable()) {
            throw new IllegalArgumentException("Cannot filter by property " + propertyPredicate.getProperty());
        }
        Object object = this._valueTranslator.onComparableValue(propertyPredicate.getProperty(), propertyPredicate.getComparableValue());
        return new PropertyPredicate(this._property, propertyPredicate.getOperator(), object, propertyPredicate.isIgnoreCase());
    }

    @Override
    public Object onPropertyValue(String string, PropertyByName propertyByName) {
        assert (string != null);
        assert (propertyByName != null);
        return this._valueTranslator.onPropertyValue(string, propertyByName.getValue(this._property));
    }
}

