/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.HomogeneousResultBuilder;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import java.util.ArrayList;
import java.util.List;

public final class AggregateModelResultTransformer {
    private final RequestPropertyValidator _propertyValidator;

    public AggregateModelResultTransformer(RequestPropertyValidator requestPropertyValidator) {
        this._propertyValidator = requestPropertyValidator;
    }

    public TranslationResult toChildModelResult(TranslationResult translationResult, String string, String string2) {
        if (string.equals(string2)) {
            return translationResult;
        }
        if (translationResult.getFilter() == null) {
            return translationResult;
        }
        Filter filter = this.toChildModel(translationResult.getFilter(), string, string2);
        return filter == null ? TranslationResult.empty() : TranslationResult.filter(filter);
    }

    public HomogeneousResultBuilder.CompositeTranslationResult toChildModelResult(HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult, String string, String string2) {
        if (string.equals(string2)) {
            return compositeTranslationResult;
        }
        if (compositeTranslationResult.getExpression() == null) {
            return compositeTranslationResult;
        }
        HomogeneousResultBuilder.PredicateTree predicateTree = compositeTranslationResult.getExpression();
        HomogeneousResultBuilder.PredicateTree predicateTree2 = this.toChildModel(predicateTree, string, string2);
        return predicateTree2 == null ? HomogeneousResultBuilder.CompositeTranslationResult.empty() : HomogeneousResultBuilder.CompositeTranslationResult.expression(predicateTree2);
    }

    private HomogeneousResultBuilder.PredicateTree toChildModel(HomogeneousResultBuilder.PredicateTree predicateTree, String string, String string2) {
        List<PropertyPredicate> list = this.toChildModel(predicateTree.getLeaves(), predicateTree.getOperator(), string, string2);
        ArrayList<HomogeneousResultBuilder.PredicateTree> arrayList = new ArrayList<HomogeneousResultBuilder.PredicateTree>(predicateTree.getSubTrees().size());
        for (HomogeneousResultBuilder.PredicateTree predicateTree2 : predicateTree.getSubTrees()) {
            HomogeneousResultBuilder.PredicateTree predicateTree3 = this.toChildModel(predicateTree2, string, string2);
            if (predicateTree3 != null) {
                arrayList.add(predicateTree3);
                continue;
            }
            if (predicateTree.getOperator() != LogicalOperator.AND) continue;
            return null;
        }
        boolean bl = list == null && arrayList.isEmpty();
        return bl ? null : new HomogeneousResultBuilder.PredicateTree(predicateTree.getOperator(), arrayList, list);
    }

    private List<PropertyPredicate> toChildModel(List<PropertyPredicate> list, LogicalOperator logicalOperator, String string, String string2) {
        if (string.equals(string2)) {
            return list;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(list.size());
        for (PropertyPredicate propertyPredicate : list) {
            PropertyPredicate propertyPredicate2 = this.toChildModel(propertyPredicate, string, string2);
            if (propertyPredicate2 != null) {
                arrayList.add(propertyPredicate2);
                continue;
            }
            if (logicalOperator != LogicalOperator.AND) continue;
            return null;
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    private Filter toChildModel(Filter filter, String string, String string2) {
        if (string.equals(string2)) {
            return filter;
        }
        List<PropertyPredicate> list = this.toChildModel(filter.getCriteria(), filter.getOperator(), string, string2);
        return list == null ? null : new Filter(list, filter.getOperator());
    }

    private PropertyPredicate toChildModel(PropertyPredicate propertyPredicate, String string, String string2) {
        String string3 = propertyPredicate.getProperty();
        if (PropertyUtil.isSpecialProperty((String)string3)) {
            return propertyPredicate;
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string3);
        if (qualifiedProperty.getResourceModel().equals(string)) {
            String string4 = QualifiedProperty.forModelAndSimpleProperty((String)string2, (String)qualifiedProperty.getSimpleProperty()).toString();
            return this.replaceProperty(propertyPredicate, string4);
        }
        return propertyPredicate;
    }

    private PropertyPredicate replaceProperty(PropertyPredicate propertyPredicate, String string) {
        if (this._propertyValidator.canFilterByProperty(string)) {
            return new PropertyPredicate(string, propertyPredicate.getOperator(), propertyPredicate.getComparableValue(), propertyPredicate.isIgnoreCase());
        }
        return null;
    }
}

