/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.AggregateModelResultTransformer;
import com.vmware.vise.data.adapters.core.translator.AggregatedModelOps;
import com.vmware.vise.data.adapters.core.translator.HomogeneousResultBuilder;
import com.vmware.vise.data.adapters.core.translator.ResultNegationTransformer;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.query.Conjoiner;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

abstract class HeterogeneousResultBuilder {
    private final RequestPropertyValidator _propertyValidator;
    protected final AggregatedModelOps _aggregatedModelOps;

    public static HeterogeneousResultBuilder forConjoiner(Conjoiner conjoiner, RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
        if (conjoiner == null) {
            return new IntersectionBuilder(requestPropertyValidator, aggregatedModelLookup);
        }
        switch (conjoiner) {
            case OR: {
                return new UnionBuilder(requestPropertyValidator, aggregatedModelLookup);
            }
            case AND: {
                return new IntersectionBuilder(requestPropertyValidator, aggregatedModelLookup);
            }
            case EXCEPT: {
                return new DifferenceBuilder(requestPropertyValidator, aggregatedModelLookup);
            }
        }
        throw new UnsupportedOperationException("Unsupported conjoiner: " + conjoiner);
    }

    public final HeterogeneousResultBuilder addCompositeResults(Map<String, HomogeneousResultBuilder.CompositeTranslationResult> map) {
        this.add(map);
        return this;
    }

    public final HeterogeneousResultBuilder addResults(Map<String, TranslationResult> map) {
        this.add(map);
        return this;
    }

    public abstract Map<String, HomogeneousResultBuilder> build();

    protected abstract <T> void add(Map<String, T> var1);

    protected HeterogeneousResultBuilder(RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
        this._propertyValidator = requestPropertyValidator;
        this._aggregatedModelOps = new AggregatedModelOps(aggregatedModelLookup);
    }

    protected final boolean typesAreRelated(String string, String string2) {
        return !Sets.intersection(this._aggregatedModelOps.decomposition(string), this._aggregatedModelOps.decomposition(string2)).isEmpty();
    }

    protected final <T> T toChildModelResult(T t, String string, String string2) {
        if (t instanceof TranslationResult) {
            return (T)new AggregateModelResultTransformer(this._propertyValidator).toChildModelResult((TranslationResult)t, string, string2);
        }
        if (t instanceof HomogeneousResultBuilder.CompositeTranslationResult) {
            return (T)new AggregateModelResultTransformer(this._propertyValidator).toChildModelResult((HomogeneousResultBuilder.CompositeTranslationResult)t, string, string2);
        }
        throw new IllegalStateException(String.format("BUG: toChildModelResult: unsupported type %s.", t == null ? null : t.getClass().getName()));
    }

    protected static <T> HomogeneousResultBuilder.CompositeTranslationResult negateResult(T t) {
        HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult;
        if (t instanceof TranslationResult) {
            compositeTranslationResult = ResultNegationTransformer.negateResult((TranslationResult)t);
        } else if (t instanceof HomogeneousResultBuilder.CompositeTranslationResult) {
            compositeTranslationResult = ResultNegationTransformer.negateResult((HomogeneousResultBuilder.CompositeTranslationResult)t);
        } else {
            throw new IllegalStateException(String.format("BUG: cannot negate result of type %s.", t == null ? null : t.getClass().getName()));
        }
        return compositeTranslationResult;
    }

    protected static <T> void addToBuilder(HomogeneousResultBuilder homogeneousResultBuilder, T t) {
        if (t instanceof TranslationResult) {
            homogeneousResultBuilder.add((TranslationResult)t);
        } else if (t instanceof HomogeneousResultBuilder.CompositeTranslationResult) {
            homogeneousResultBuilder.add((HomogeneousResultBuilder.CompositeTranslationResult)t);
        } else {
            throw new IllegalStateException(String.format("BUG: cannot add %s to CompositeResultBuilder.", t == null ? null : t.getClass().getName()));
        }
    }

    private static final class DifferenceBuilder
    extends Merger {
        public DifferenceBuilder(RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
            super(requestPropertyValidator, aggregatedModelLookup);
        }

        @Override
        protected <T> void mergeWith(Map<String, T> map) {
            if (map.isEmpty()) {
                return;
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : this._resultBuildersByType.entrySet()) {
                String string = (String)entry.getKey();
                if (!this.typesIsRelatedToAnyOf(string, map.keySet())) {
                    hashMap.put(string, this._resultBuildersByType.get(string));
                }
                for (Map.Entry<String, T> entry2 : map.entrySet()) {
                    HomogeneousResultBuilder homogeneousResultBuilder;
                    Object object;
                    String string2 = entry2.getKey();
                    if (!this.typesAreRelated(string, string2)) continue;
                    Set<String> set = this._aggregatedModelOps.difference(string, string2);
                    for (String string3 : set) {
                        object = this.toChildModelResult(((HomogeneousResultBuilder)entry.getValue()).build(), string, string3);
                        homogeneousResultBuilder = new HomogeneousResultBuilder(LogicalOperator.AND).add((HomogeneousResultBuilder.CompositeTranslationResult)object);
                        hashMap.put(string3, homogeneousResultBuilder);
                    }
                    Set<String> set2 = this._aggregatedModelOps.intersection(string, string2);
                    Iterator object22 = set2.iterator();
                    while (object22.hasNext()) {
                        object = (String)object22.next();
                        homogeneousResultBuilder = new HomogeneousResultBuilder(LogicalOperator.AND);
                        HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult = this.toChildModelResult(((HomogeneousResultBuilder)entry.getValue()).build(), string, (String)object);
                        T t = this.toChildModelResult(entry2.getValue(), string2, (String)object);
                        homogeneousResultBuilder.add(compositeTranslationResult);
                        homogeneousResultBuilder.add(DifferenceBuilder.negateResult(t));
                        hashMap.put(object, homogeneousResultBuilder);
                    }
                }
            }
            this._resultBuildersByType = hashMap;
        }

        private boolean typesIsRelatedToAnyOf(String string, Set<String> set) {
            for (String string2 : set) {
                if (!this.typesAreRelated(string, string2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class IntersectionBuilder
    extends Merger {
        public IntersectionBuilder(RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
            super(requestPropertyValidator, aggregatedModelLookup);
        }

        @Override
        protected <T> void mergeWith(Map<String, T> map) {
            HashMap<String, HomogeneousResultBuilder> hashMap = new HashMap<String, HomogeneousResultBuilder>();
            for (Map.Entry entry : this._resultBuildersByType.entrySet()) {
                String string = (String)entry.getKey();
                HomogeneousResultBuilder homogeneousResultBuilder = (HomogeneousResultBuilder)entry.getValue();
                for (Map.Entry<String, T> entry2 : map.entrySet()) {
                    String string2 = entry2.getKey();
                    Validate.notNull((Object)string2, (String)"Internal error: null key in the <Type -> TranslationResult> map.");
                    if (string2.equals(string)) {
                        IntersectionBuilder.addToBuilder(homogeneousResultBuilder, entry2.getValue());
                        hashMap.put(string2, homogeneousResultBuilder);
                        continue;
                    }
                    Set<String> set = this._aggregatedModelOps.intersection(string, string2);
                    for (String string3 : set) {
                        HomogeneousResultBuilder homogeneousResultBuilder2 = new HomogeneousResultBuilder(LogicalOperator.AND);
                        HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult = this.toChildModelResult(homogeneousResultBuilder.build(), string, string3);
                        T t = this.toChildModelResult(entry2.getValue(), string2, string3);
                        IntersectionBuilder.addToBuilder(homogeneousResultBuilder2, compositeTranslationResult);
                        IntersectionBuilder.addToBuilder(homogeneousResultBuilder2, t);
                        hashMap.put(string3, homogeneousResultBuilder2);
                    }
                }
            }
            this._resultBuildersByType = hashMap;
        }
    }

    private static abstract class Merger
    extends HeterogeneousResultBuilder {
        protected Map<String, HomogeneousResultBuilder> _resultBuildersByType = null;

        public Merger(RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
            super(requestPropertyValidator, aggregatedModelLookup);
        }

        @Override
        public final Map<String, HomogeneousResultBuilder> build() {
            return this._resultBuildersByType == null ? Collections.emptyMap() : Collections.unmodifiableMap(this._resultBuildersByType);
        }

        @Override
        protected final <T> void add(Map<String, T> map) {
            if (this._resultBuildersByType == null) {
                this.bootstrapFrom(map);
            } else {
                this.mergeWith(map);
            }
        }

        private <T> void bootstrapFrom(Map<String, T> map) {
            this._resultBuildersByType = new HashMap<String, HomogeneousResultBuilder>();
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String string = entry.getKey();
                T t = entry.getValue();
                HomogeneousResultBuilder homogeneousResultBuilder = new HomogeneousResultBuilder(LogicalOperator.AND);
                Merger.addToBuilder(homogeneousResultBuilder, t);
                this._resultBuildersByType.put(string, homogeneousResultBuilder);
            }
        }

        protected abstract <T> void mergeWith(Map<String, T> var1);
    }

    private static final class UnionBuilder
    extends HeterogeneousResultBuilder {
        private final Map<String, HomogeneousResultBuilder> _resultBuildersByType = new HashMap<String, HomogeneousResultBuilder>();

        public UnionBuilder(RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup) {
            super(requestPropertyValidator, aggregatedModelLookup);
        }

        private boolean hasRelatedTypeInResult(String string) {
            for (String string2 : this._resultBuildersByType.keySet()) {
                if (string.equals(string2) || !this.typesAreRelated(string, string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected final <T> void add(Map<String, T> map) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String string = entry.getKey();
                T t = entry.getValue();
                HomogeneousResultBuilder homogeneousResultBuilder = this._resultBuildersByType.get(string);
                if (homogeneousResultBuilder == null) {
                    homogeneousResultBuilder = new HomogeneousResultBuilder(LogicalOperator.OR);
                    this._resultBuildersByType.put(string, homogeneousResultBuilder);
                }
                UnionBuilder.addToBuilder(homogeneousResultBuilder, t);
            }
        }

        @Override
        public final Map<String, HomogeneousResultBuilder> build() {
            Object object;
            String string;
            LinkedHashMap<String, HomogeneousResultBuilder> linkedHashMap = new LinkedHashMap<String, HomogeneousResultBuilder>();
            HashMultimap hashMultimap = HashMultimap.create();
            for (Map.Entry<String, HomogeneousResultBuilder> entry : this._resultBuildersByType.entrySet()) {
                string = entry.getKey();
                if (this.hasRelatedTypeInResult(string)) {
                    object = this._aggregatedModelOps.decomposition(string);
                    Iterator<String> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object object2 = iterator.next();
                        hashMultimap.put(object2, entry);
                    }
                    continue;
                }
                linkedHashMap.put(string, entry.getValue());
            }
            for (Map.Entry<String, HomogeneousResultBuilder> entry : hashMultimap.asMap().entrySet()) {
                string = entry.getKey();
                object = new HomogeneousResultBuilder(LogicalOperator.OR);
                for (Object object2 : (Collection)((Object)entry.getValue())) {
                    String string2 = (String)object2.getKey();
                    HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult = ((HomogeneousResultBuilder)object2.getValue()).build();
                    HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult2 = this.toChildModelResult(compositeTranslationResult, string2, string);
                    ((HomogeneousResultBuilder)object).add(compositeTranslationResult2);
                }
                linkedHashMap.put(string, (HomogeneousResultBuilder)object);
            }
            return linkedHashMap;
        }
    }
}

