/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.vise.data.adapters.core.translator.RelationshipInfo;
import java.util.HashMap;
import java.util.Map;

public final class RelationshipRegistry {
    private final Map<String, RelationshipInfo> _knownRelationships = new HashMap<String, RelationshipInfo>();

    public RelationshipRegistry(Iterable<RelationshipInfo> iterable) {
        for (RelationshipInfo relationshipInfo : iterable) {
            this.add(relationshipInfo);
        }
        this.checkCompleteness();
    }

    public RelationshipInfo getRelationship(String string) {
        if (string == null) {
            return null;
        }
        return this._knownRelationships.get(string);
    }

    private void add(RelationshipInfo relationshipInfo) {
        RelationshipInfo relationshipInfo2 = this._knownRelationships.put(relationshipInfo.getName(), relationshipInfo);
        if (relationshipInfo2 != null) {
            throw new IllegalArgumentException("Registry already contains information about the relation: " + relationshipInfo.getName());
        }
    }

    private void checkCompleteness() {
        for (RelationshipInfo relationshipInfo : this._knownRelationships.values()) {
            if (this._knownRelationships.keySet().containsAll(relationshipInfo.getInverseRelationships())) continue;
            throw new IllegalStateException(String.format("%s completeness check failed: not all %s-s are present for the inverse relationships of %s.", RelationshipRegistry.class.getSimpleName(), RelationshipInfo.class.getSimpleName(), relationshipInfo.getName()));
        }
    }
}

