/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

final class UnsetPropertyHandler
implements PropertyConstraintTranslator.PropertyConstraintTranslationHandler {
    private final CorePropertyConverter _propertyConverter;
    private final RequestPropertyValidator _propertyValidator;

    UnsetPropertyHandler(CorePropertyConverter corePropertyConverter, RequestPropertyValidator requestPropertyValidator) {
        assert (corePropertyConverter != null);
        assert (requestPropertyValidator != null);
        this._propertyConverter = corePropertyConverter;
        this._propertyValidator = requestPropertyValidator;
    }

    @Override
    public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, Map<String, Object> map) {
        if (!Comparator.EQUALS.equals((Object)propertyConstraint.comparator)) {
            return null;
        }
        if (!(propertyConstraint.comparableValue instanceof String)) {
            return null;
        }
        String string = (String)propertyConstraint.comparableValue;
        if (!"null".equalsIgnoreCase(string)) {
            return null;
        }
        String string2 = this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
        if (!this._propertyValidator.canUseUnsetOnProperty(string2)) {
            return null;
        }
        PropertyPredicate propertyPredicate = new PropertyPredicate(string2, PropertyPredicate.ComparisonOperator.UNSET, (Object)Boolean.TRUE);
        return Collections.singletonMap(propertyConstraint.targetType, TranslationResult.filter(new Filter(Arrays.asList(propertyPredicate))));
    }
}

