/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

final class RiseToViseResult {
    private final ObjectReferenceService _referenceService;
    private final RiseToViseProperty _propertyConverter;

    public RiseToViseResult(ObjectReferenceService objectReferenceService, RiseToViseProperty riseToViseProperty) {
        assert (objectReferenceService != null);
        assert (riseToViseProperty != null);
        this._referenceService = objectReferenceService;
        this._propertyConverter = riseToViseProperty;
    }

    public ResultSet fromViseResult(com.vmware.vise.data.query.ResultSet resultSet, Query query) {
        Integer n;
        assert (query != null);
        if (resultSet == null) {
            return ResultSet.Builder.properties((List)query.getProperties()).totalCount(query.getWithTotalCount() ? Integer.valueOf(0) : null).build();
        }
        if (resultSet.error != null) {
            throw RiseToViseResult.toRuntimeException(resultSet.error);
        }
        Integer n2 = n = query.getWithTotalCount() ? resultSet.totalMatchedObjectCount : null;
        if (ArrayUtils.isEmpty((Object[])resultSet.items)) {
            return ResultSet.Builder.properties((String[])new String[0]).totalCount(n).build();
        }
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>(resultSet.items.length);
        String[] stringArray = this.toViseProperties(query.getProperties());
        for (ResultItem resultItem : resultSet.items) {
            List<Object> list = this.fromResultItem(resultItem, stringArray);
            arrayList.add(list);
        }
        return ResultSet.Builder.properties((List)query.getProperties()).items(arrayList).totalCount(n).build();
    }

    private List<Object> fromResultItem(ResultItem resultItem, String[] stringArray) {
        assert (resultItem != null);
        assert (stringArray != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            Object object = this.getPropertyValue(resultItem, string);
            arrayList.add(object);
        }
        return arrayList;
    }

    private Object getPropertyValue(ResultItem resultItem, String string) {
        assert (resultItem != null);
        assert (string != null);
        if (resultItem.properties == null) {
            return null;
        }
        if ("@modelKey".equals(string)) {
            return resultItem.resourceObject;
        }
        if ("@type".equals(string)) {
            return this._referenceService.getResourceObjectType(resultItem.resourceObject);
        }
        for (PropertyValue propertyValue : resultItem.properties) {
            if (!string.equals(propertyValue.propertyName)) continue;
            return propertyValue.value;
        }
        return null;
    }

    private String[] toViseProperties(Collection<String> collection) {
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (String string : collection) {
            stringArray[n++] = this.toViseProperty(string);
        }
        return stringArray;
    }

    private String toViseProperty(String string) {
        return this._propertyConverter.toViseProperty(string);
    }

    private static RuntimeException toRuntimeException(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }
}

