/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.property.PropertyProviders;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.registry.PropertyProviderLookup;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.adapters.risetovise.PropertyQualifyingDataProvider;
import com.vmware.vise.data.adapters.risetovise.ViseDsBasedDataProvider;
import com.vmware.vise.data.adapters.risetovise.ViseDsPropertyFormatToleratingDataProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.data.adapters.common.DataAdapterConfiguration;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionUtilAwareQueryServiceFactory
implements QueryServiceFactory,
UserSessionListener {
    private static final Logger _logger = LoggerFactory.getLogger(SessionUtilAwareQueryServiceFactory.class);
    private static final String SESSION_KEY_DS2 = "SESSION_KEY_DS2";
    private final DataService _viseDataService;
    private final ObjectReferenceService _referenceService;
    private final ExecutorService _executor;
    private final DataAdapterConfiguration _dataAdapterConfiguration;
    private final PropertyProviderLookup _propertyProviderLookup;

    public SessionUtilAwareQueryServiceFactory(DataService dataService, ObjectReferenceService objectReferenceService, ExecutorService executorService, DataAdapterConfiguration dataAdapterConfiguration, PropertyProviderLookup propertyProviderLookup) {
        Validate.notNull((Object)dataService);
        Validate.notNull((Object)objectReferenceService);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)dataAdapterConfiguration);
        Validate.notNull((Object)propertyProviderLookup);
        this._viseDataService = dataService;
        this._referenceService = objectReferenceService;
        this._executor = executorService;
        this._dataAdapterConfiguration = dataAdapterConfiguration;
        this._propertyProviderLookup = propertyProviderLookup;
    }

    public QueryService getQueryService() {
        QueryService queryService = QueryService.Builder.forProvider((DataProvider)new SessionAwareDataProvider()).build();
        return queryService;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) {
        if (httpSessionEvent == null) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        if (httpSession == null) {
            return;
        }
        Object object = SessionUtil.removeData((String)SESSION_KEY_DS2, (HttpSession)httpSession);
        if (object != null) {
            _logger.info("Clean up DS 2.0 for ended session: 0x{} clientId: {}", (Object)Integer.toHexString(System.identityHashCode(httpSession)), (Object)SessionUtil.getHashedClientId((HttpSession)httpSession));
        } else {
            _logger.info("No DS 2.0 found for ended session: 0x{} clientId: {}", (Object)Integer.toHexString(System.identityHashCode(httpSession)), (Object)SessionUtil.getHashedClientId((HttpSession)httpSession));
        }
    }

    private DataProvider getDataProviderForCurrentSession() {
        String string;
        final HttpSession httpSession = SessionUtil.getHttpSession();
        Supplier supplier = Suppliers.memoize((Supplier)new Supplier<DataProvider>(string = SessionUtil.getClientId((HttpSession)httpSession)){
            final /* synthetic */ String val$clientId;
            {
                this.val$clientId = string;
            }

            public DataProvider get() {
                return SessionUtilAwareQueryServiceFactory.this.createDataProvider(httpSession, this.val$clientId);
            }
        });
        Supplier supplier2 = (Supplier)SessionUtil.setDataIfAbsent((String)SESSION_KEY_DS2, (Object)supplier, (String)string);
        if (supplier2 != null) {
            supplier = supplier2;
        }
        DataProvider dataProvider = (DataProvider)supplier.get();
        return dataProvider;
    }

    private DataProvider createDataProvider(HttpSession httpSession, String string) {
        assert (httpSession != null);
        assert (string != null);
        _logger.info("Wire DS 2.0 for session: 0x{} clientId: {}", (Object)Integer.toHexString(System.identityHashCode(httpSession)), (Object)SessionUtil.getHashedClientId((String)string));
        ViseDsPropertyFormatToleratingDataProvider viseDsPropertyFormatToleratingDataProvider = new ViseDsPropertyFormatToleratingDataProvider(new PropertyQualifyingDataProvider(PropertyProviders.forBeans((Collection)this._propertyProviderLookup.get(), (DataProvider)new ViseDsBasedDataProvider(this._viseDataService, this._referenceService), (ExecutorService)this._executor, (long)this._dataAdapterConfiguration.getRiseAdapterOperationThreshold())));
        return viseDsPropertyFormatToleratingDataProvider;
    }

    private final class SessionAwareDataProvider
    implements DataProvider {
        private SessionAwareDataProvider() {
        }

        public ResultSet executeQuery(Query query) {
            assert (query != null);
            DataProvider dataProvider = SessionUtilAwareQueryServiceFactory.this.getDataProviderForCurrentSession();
            return dataProvider.executeQuery(query);
        }

        public QuerySchema getSchema() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

