/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ViseDsPropertyFormatToleratingDataProvider
implements DataProvider {
    private static final Logger _logger = LoggerFactory.getLogger(ViseDsPropertyFormatToleratingDataProvider.class);
    private static final String VISE_INSTANCE_UUID = "serverGuid";
    private static final String RISE_INSTANCE_UUID = "@instanceUuid";
    private static final String VISE_LEN_SUFFIX = "/_length";
    private static final String RISE_LEN_SUFFIX = "/length";
    private static final char VISE_PROP_PATH_DELIM = '.';
    private static final char RISE_PROP_PATH_DELIM = '/';
    private static final char MODEL_DELIM = '/';
    private final DataProvider _dataProvider;

    public ViseDsPropertyFormatToleratingDataProvider(DataProvider dataProvider) {
        assert (dataProvider != null);
        this._dataProvider = dataProvider;
    }

    public ResultSet executeQuery(Query query) {
        assert (query != null);
        List<String> list = ViseDsPropertyFormatToleratingDataProvider.fixSelect(query.getProperties());
        Filter filter = ViseDsPropertyFormatToleratingDataProvider.fix(query.getFilter());
        List<SortCriterion> list2 = ViseDsPropertyFormatToleratingDataProvider.fix(query.getSortCriteria());
        if (list == query.getProperties() && filter == query.getFilter() && list2 == query.getSortCriteria()) {
            return this._dataProvider.executeQuery(query);
        }
        Query query2 = QueryCopy.copyAndSelect((Query)query, list).where(filter).orderBy(list2).build();
        ResultSet resultSet = this._dataProvider.executeQuery(query2);
        if (list == query.getProperties()) {
            return resultSet;
        }
        return ViseDsPropertyFormatToleratingDataProvider.restorePropertyNames(resultSet, query.getProperties(), list);
    }

    public QuerySchema getSchema() {
        return this._dataProvider.getSchema();
    }

    private static List<String> fixSelect(List<String> list) {
        assert (list != null);
        if (!ViseDsPropertyFormatToleratingDataProvider.shouldFixSelect(list)) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(ViseDsPropertyFormatToleratingDataProvider.fix(string));
        }
        return arrayList;
    }

    private static boolean shouldFixSelect(List<String> list) {
        assert (list != null);
        for (String string : list) {
            if (!ViseDsPropertyFormatToleratingDataProvider.shouldFix(string)) continue;
            return true;
        }
        return false;
    }

    private static Filter fix(Filter filter) {
        if (!ViseDsPropertyFormatToleratingDataProvider.shouldFix(filter)) {
            return filter;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            PropertyPredicate propertyPredicate2 = ViseDsPropertyFormatToleratingDataProvider.fix(propertyPredicate);
            arrayList.add(propertyPredicate2);
        }
        return new Filter(arrayList, filter.getOperator());
    }

    private static PropertyPredicate fix(PropertyPredicate propertyPredicate) {
        assert (propertyPredicate != null);
        return new PropertyPredicate(ViseDsPropertyFormatToleratingDataProvider.fix(propertyPredicate.getProperty()), propertyPredicate.getOperator(), propertyPredicate.getComparableValue(), propertyPredicate.isIgnoreCase());
    }

    private static boolean shouldFix(Filter filter) {
        if (filter == null) {
            return false;
        }
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            if (!ViseDsPropertyFormatToleratingDataProvider.shouldFix(propertyPredicate.getProperty())) continue;
            return true;
        }
        return false;
    }

    private static List<SortCriterion> fix(List<SortCriterion> list) {
        assert (list != null);
        if (!ViseDsPropertyFormatToleratingDataProvider.shouldFix(list)) {
            return list;
        }
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>(list.size());
        for (SortCriterion sortCriterion : list) {
            SortCriterion sortCriterion2 = ViseDsPropertyFormatToleratingDataProvider.fix(sortCriterion);
            arrayList.add(sortCriterion2);
        }
        return arrayList;
    }

    private static SortCriterion fix(SortCriterion sortCriterion) {
        assert (sortCriterion != null);
        return new SortCriterion(ViseDsPropertyFormatToleratingDataProvider.fix(sortCriterion.getProperty()), sortCriterion.getSortDirection(), sortCriterion.isIgnoreCase());
    }

    private static boolean shouldFix(List<SortCriterion> list) {
        assert (list != null);
        for (SortCriterion sortCriterion : list) {
            if (!ViseDsPropertyFormatToleratingDataProvider.shouldFix(sortCriterion.getProperty())) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldFix(String string) {
        return string != ViseDsPropertyFormatToleratingDataProvider.fixSilently(string);
    }

    private static String fix(String string) {
        assert (string != null);
        String string2 = ViseDsPropertyFormatToleratingDataProvider.fixSilently(string);
        if (string2 != string) {
            _logger.warn(String.format("Detected invalid property '%s'. Please use '%s' instead.", string, string2));
        }
        return string2;
    }

    private static String fixSilently(String string) {
        assert (string != null);
        if (VISE_INSTANCE_UUID.equals(string)) {
            return RISE_INSTANCE_UUID;
        }
        String string2 = ViseDsPropertyFormatToleratingDataProvider.fixDots(string);
        if (string2.endsWith(VISE_LEN_SUFFIX)) {
            string2 = StringUtils.removeEnd((String)string2, (String)VISE_LEN_SUFFIX) + RISE_LEN_SUFFIX;
        }
        return string2;
    }

    private static String fixDots(String string) {
        assert (string != null);
        int n = string.indexOf(47);
        if (n < 0) {
            return string.replace('.', '/');
        }
        int n2 = string.indexOf(46, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string.indexOf(46);
        if (n3 > n) {
            return string.replace('.', '/');
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return string2 + '/' + string3.replace('.', '/');
    }

    private static ResultSet restorePropertyNames(ResultSet resultSet, List<String> list, List<String> list2) {
        assert (resultSet != null);
        assert (list != null);
        assert (list2 != null);
        assert (list.size() == list2.size());
        assert (resultSet.getProperties().size() <= list.size());
        if (resultSet.getProperties().isEmpty()) {
            return resultSet;
        }
        ArrayList<String> arrayList = new ArrayList<String>(resultSet.getProperties().size());
        for (String string : resultSet.getProperties()) {
            int n = list2.indexOf(string);
            if (n < 0) {
                throw new IllegalArgumentException("ResultSet contains property that was not requested: " + string);
            }
            String string2 = list.get(n);
            arrayList.add(string2);
        }
        return ResultSet.Builder.properties(arrayList).items(ResourceItemUtil.getValues((Collection)resultSet.getItems())).totalCount(resultSet.getTotalCount()).build();
    }
}

