/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.cdc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.predicate.PredicatePropertyRepository;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.model.QueryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceChangeCustomPropertySupport {
    private static final Logger _logger = LoggerFactory.getLogger(ResourceChangeCustomPropertySupport.class);
    private static final char VMODL2_PACKAGE_PATH_SEPARATOR = '.';
    private static final char VISE_PROPERTY_PATH_SEPARATOR = '.';
    private static final Map<String, Collection<String>> NATIVE_BY_VIRTUAL_PROPERTIES = ImmutableMap.builder().put((Object)"DistributedVirtualPortgroup/isUplinkPortgroup", (Object)ImmutableList.builder().add((Object)"DistributedVirtualPortgroup/tag").build()).put((Object)"VirtualMachine/isNormalVMOrPrimaryFTVM", (Object)ImmutableList.builder().add((Object)"VirtualMachine/config").add((Object)"VirtualMachine/config/ftInfo/role").add((Object)"VirtualMachine/config/template").build()).put((Object)"Datastore/unmountedFromAllHosts", (Object)ImmutableList.builder().add((Object)"Datastore/host").build()).build();
    private final Map<String, Collection<String>> _customPropertiesByNative;

    private ResourceChangeCustomPropertySupport(Map<String, Collection<String>> map) {
        Validate.notNull(map);
        this._customPropertiesByNative = map;
    }

    public static ResourceChangeCustomPropertySupport forQueryModels(Collection<Class<?>> collection) {
        Validate.notNull(collection);
        return new ResourceChangeCustomPropertySupport(ResourceChangeCustomPropertySupport.mapNativeToCustomProperties(collection));
    }

    public ResourceChange withCustomProperties(ResourceChange resourceChange) {
        assert (resourceChange != null);
        List list = resourceChange.getProperties();
        if (this._customPropertiesByNative.isEmpty() || CollectionUtils.isEmpty((Collection)list)) {
            return resourceChange;
        }
        String string = resourceChange.getResourceType();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list);
        for (String string2 : list) {
            Collection<String> collection;
            String string3;
            boolean bl = false;
            int n = string2.indexOf(47);
            if (n < 0) {
                bl = true;
            } else {
                string3 = string2.substring(0, n);
                assert (string3.indexOf(46) > 0);
            }
            string3 = string2;
            if (bl) {
                assert (string2.indexOf(47) < 0);
                string3 = string + '/' + string2;
            }
            if ((collection = this._customPropertiesByNative.get(string3)) == null) continue;
            linkedHashSet.addAll(collection);
        }
        return new ResourceChange(resourceChange.getKind(), resourceChange.getResource(), string, new ArrayList(linkedHashSet));
    }

    private static Map<String, Collection<String>> mapNativeToCustomProperties(Collection<Class<?>> collection) {
        assert (collection != null);
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (Class<?> clazz : collection) {
            ResourceChangeCustomPropertySupport.mapNativeToCustomProperties(clazz, map);
        }
        map = ResourceChangeCustomPropertySupport.fixMapping(map);
        return Collections.unmodifiableMap(map);
    }

    private static void mapNativeToCustomProperties(Class<?> clazz, Map<String, Collection<String>> map) {
        Object object;
        Object object222;
        assert (clazz != null);
        assert (map != null);
        QueryModel queryModel = clazz.getAnnotation(QueryModel.class);
        if (queryModel == null) {
            _logger.warn("The given class is not annotated with @QueryModel annotation, skipping it: {}", (Object)clazz.getName());
            return;
        }
        String string = queryModel.value();
        Collection collection = AliasPropertyRepository.collectAliasPropertyDescriptorByField((String)string, clazz).values();
        for (Object object222 : collection) {
            ResourceChangeCustomPropertySupport.mapNativeToCustomProperty(map, object222.getTargetName(), object222.getName());
        }
        List list = PredicatePropertyRepository.collectPredicatePropertyDescriptors((String)string, clazz);
        object222 = list.iterator();
        while (object222.hasNext()) {
            PredicatePropertyDescriptor object3 = (PredicatePropertyDescriptor)object222.next();
            object = object3.getFilter().getCriteria();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2 = (PropertyPredicate)iterator.next();
                ResourceChangeCustomPropertySupport.mapNativeToCustomProperty(map, object2.getProperty(), object3.getName());
            }
        }
        for (Map.Entry entry : NATIVE_BY_VIRTUAL_PROPERTIES.entrySet()) {
            object = (String)entry.getKey();
            for (Object object2 : (Collection)entry.getValue()) {
                ResourceChangeCustomPropertySupport.mapNativeToCustomProperty(map, (String)object2, (String)object);
            }
        }
    }

    private static void mapNativeToCustomProperty(Map<String, Collection<String>> map, String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (PropertyUtil.isSpecialProperty((String)string) || PropertyUtil.isModelKey((String)string)) {
            return;
        }
        Collection<String> collection = map.get(string);
        if (collection == null) {
            collection = new HashSet<String>();
            map.put(string, collection);
        }
        collection.add(string2);
    }

    private static Map<String, Collection<String>> fixMapping(Map<String, Collection<String>> map) {
        assert (map != null);
        if (map.isEmpty()) {
            return map;
        }
        char c = '/';
        char c2 = '.';
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            Object object;
            int n;
            String string = entry.getKey();
            String string2 = string.substring(0, n = string.indexOf(47));
            if (string2.indexOf(46) < 0) {
                object = string.substring(n + 1);
                string = string2 + '/' + ((String)object).replace(c, c2);
            }
            object = entry.getValue();
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string2 = string3.substring(0, n = string3.indexOf(47));
                if (string2.indexOf(46) < 0) {
                    String string4 = string3.substring(n + 1);
                    string3 = string4.replace(c, c2);
                }
                hashSet.add(string3);
            }
            hashMap.put(string, Collections.unmodifiableCollection(hashSet));
        }
        return hashMap;
    }
}

