/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.ConstraintFactory;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.RelationSpec;
import com.vmware.vise.search.SimplePropertyConstraint;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.vim.data.adapters.search.impl.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ConstraintTransformer {
    private final ConstraintFactory _constraintFactory;
    private final ObjectReferenceService _objRefSvc;
    private static final String AT_TYPE_PROP = "@type";
    private static final String DEFAULT_IS_NAMESPACE = "urn:" + NamespaceUtils.DEFAULT_NAMESPACE;

    public ConstraintTransformer(ConstraintFactory constraintFactory, ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)constraintFactory, (String)"constraintFactory");
        Validate.notNull((Object)objectReferenceService, (String)"objRefSvc");
        this._constraintFactory = constraintFactory;
        this._objRefSvc = objectReferenceService;
    }

    public List<Constraint> getSearchConstraints(List<com.vmware.vise.data.Constraint> list) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>(list.size());
        for (com.vmware.vise.data.Constraint constraint : list) {
            arrayList.add(this.getSearchConstraint(constraint));
        }
        return arrayList;
    }

    public Constraint getSearchConstraint(com.vmware.vise.data.Constraint constraint) {
        if (!QueryUtil.validateQueryConstraint((com.vmware.vise.data.Constraint)constraint)) {
            throw new IllegalArgumentException(com.vmware.vise.data.query.impl.Utils.getLocalizedString((String)"error.invalidConstraint"));
        }
        return this.getSpecificConstraint(constraint);
    }

    private Constraint getSpecificConstraint(com.vmware.vise.data.Constraint constraint) {
        if (com.vmware.vise.data.query.ObjectIdentityConstraint.class.isInstance(constraint)) {
            com.vmware.vise.data.query.ObjectIdentityConstraint objectIdentityConstraint = (com.vmware.vise.data.query.ObjectIdentityConstraint)constraint;
            return this.getObjectIdentityConstraint(objectIdentityConstraint);
        }
        if (RelationalConstraint.class.isInstance(constraint)) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            return this.getRelationalConstraint(relationalConstraint);
        }
        if (PropertyConstraint.class.isInstance(constraint)) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            return this.getPropertyConstraint(propertyConstraint);
        }
        if (CompositeConstraint.class.isInstance(constraint)) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            return this.getCompositeConstraint(compositeConstraint);
        }
        Constraint constraint2 = this._constraintFactory.newConstraint(constraint.targetType);
        return constraint2;
    }

    private Constraint getObjectIdentityConstraint(com.vmware.vise.data.query.ObjectIdentityConstraint objectIdentityConstraint) {
        assert (objectIdentityConstraint != null);
        ObjectIdentityConstraint objectIdentityConstraint2 = this._constraintFactory.newObjectIdentityConstraint();
        String string = this.getEffectiveTargetType((com.vmware.vise.data.Constraint)objectIdentityConstraint);
        objectIdentityConstraint2.setSearchTarget(string);
        objectIdentityConstraint2.setTarget(objectIdentityConstraint.target);
        return objectIdentityConstraint2;
    }

    private Constraint getRelationalConstraint(RelationalConstraint relationalConstraint) {
        com.vmware.vise.data.Constraint constraint;
        assert (relationalConstraint != null);
        com.vmware.vise.search.RelationalConstraint relationalConstraint2 = this._constraintFactory.newRelationalConstraint();
        String string = relationalConstraint.targetType;
        if (relationalConstraint.hasInverseRelation) {
            constraint = relationalConstraint.constraintOnRelatedObject;
            if (constraint == null) {
                throw new IllegalArgumentException(String.format("Invalid RelationalConstraint: invalid constraintOnRelatedObject (null) for relation = %s", relationalConstraint.relation));
            }
            string = this.getEffectiveTargetType(constraint);
        }
        relationalConstraint2.setRelationSpec(new RelationSpec(string, relationalConstraint.relation, relationalConstraint.hasInverseRelation));
        constraint = this.getSpecificConstraint(relationalConstraint.constraintOnRelatedObject);
        relationalConstraint2.setNestedConstraint((Constraint)constraint);
        relationalConstraint2.setSearchTarget(relationalConstraint.targetType);
        return relationalConstraint2;
    }

    private Constraint getPropertyConstraint(PropertyConstraint propertyConstraint) {
        assert (propertyConstraint != null);
        SimplePropertyConstraint simplePropertyConstraint = this._constraintFactory.newSimplePropertyConstraint();
        simplePropertyConstraint.setSearchTarget(propertyConstraint.targetType);
        simplePropertyConstraint.setProperty(propertyConstraint.propertyName);
        simplePropertyConstraint.setComparisonOperator(Utils.toComparisonOperator(propertyConstraint.comparator));
        if (AT_TYPE_PROP.equals(propertyConstraint.propertyName)) {
            simplePropertyConstraint.setComparativeValues(new Object[]{this.transformComparableValue(propertyConstraint.comparableValue)});
        } else {
            simplePropertyConstraint.setComparativeValues(new Object[]{propertyConstraint.comparableValue});
        }
        return simplePropertyConstraint;
    }

    private Object transformComparableValue(Object object) {
        assert (object instanceof String);
        String string = (String)object;
        if (!string.contains(String.valueOf(':'))) {
            return DEFAULT_IS_NAMESPACE + ':' + string;
        }
        return string;
    }

    private Constraint getCompositeConstraint(CompositeConstraint compositeConstraint) {
        assert (compositeConstraint != null);
        com.vmware.vise.search.CompositeConstraint compositeConstraint2 = this._constraintFactory.newCompositeConstraint();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        for (com.vmware.vise.data.Constraint constraint : compositeConstraint.nestedConstraints) {
            arrayList.add(this.getSpecificConstraint(constraint));
        }
        compositeConstraint2.setNestedConstraints(arrayList.toArray(new Constraint[0]));
        compositeConstraint2.setSearchTarget(compositeConstraint.targetType);
        compositeConstraint2.setConjoiner(ConstraintConjoiner.valueOf((String)compositeConstraint.conjoiner.toString()));
        return compositeConstraint2;
    }

    private String getEffectiveTargetType(com.vmware.vise.data.Constraint constraint) {
        String string = constraint.targetType;
        if (StringUtils.isEmpty((String)string)) {
            if (constraint instanceof com.vmware.vise.data.query.ObjectIdentityConstraint) {
                string = this._objRefSvc.getResourceObjectType(((com.vmware.vise.data.query.ObjectIdentityConstraint)constraint).target);
            } else if (constraint instanceof CompositeConstraint) {
                com.vmware.vise.data.Constraint[] constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
                constraintArray = constraintArray == null ? new com.vmware.vise.data.Constraint[]{} : constraintArray;
                HashSet<String> hashSet = new HashSet<String>();
                for (com.vmware.vise.data.Constraint constraint2 : constraintArray) {
                    hashSet.add(this.getEffectiveTargetType(constraint2));
                }
                if (hashSet.size() == 1) {
                    string = (String)hashSet.iterator().next();
                }
            }
        }
        return string;
    }
}

