/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.Restriction;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.List;

public final class DescriptorTransformer {
    private static final String ANY_TYPE = "anyType";
    private static final String UNSUPPORTED = "unsupported";

    public static com.vmware.vise.metadata.TypeDescriptor getTypeDescriptor(TypeDescriptor typeDescriptor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeDescriptor});
        com.vmware.vise.metadata.TypeDescriptor typeDescriptor2 = new com.vmware.vise.metadata.TypeDescriptor();
        typeDescriptor2.title = ResourceUtil.wrapIntoLocalizableTags((String)typeDescriptor.getTitle());
        typeDescriptor2.name = TypeRefUtils.ROOT_TYPEREF.getName().equals(typeDescriptor.getType()) ? ANY_TYPE : typeDescriptor.getType();
        typeDescriptor2.tags = typeDescriptor.getTags();
        typeDescriptor2.supertype = typeDescriptor.getSupertype();
        return typeDescriptor2;
    }

    public static RelationshipDescriptor getRelationshipDescriptor(RelationDescriptor relationDescriptor, MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{relationDescriptor, metadataDirectory});
        RelationshipDescriptor relationshipDescriptor = new RelationshipDescriptor();
        relationshipDescriptor.name = relationDescriptor.getId();
        com.vmware.vise.search.metadata.PropertyDescriptor propertyDescriptor = MetadataUtil.getProperty((RelationDescriptor)relationDescriptor, (PropertyDescriptorDirectory)metadataDirectory);
        relationshipDescriptor.relationship = DescriptorTransformer.getPropertyDescriptor(propertyDescriptor);
        relationshipDescriptor.sourceType = MetadataUtil.getSourceType((RelationDescriptor)relationDescriptor, (PropertyDescriptorDirectory)metadataDirectory);
        relationshipDescriptor.targetType = MetadataUtil.getTargetType((RelationDescriptor)relationDescriptor, (MetadataDirectory)metadataDirectory);
        relationshipDescriptor.tags = relationDescriptor.getTags();
        return relationshipDescriptor;
    }

    public static PropertyDescriptor getPropertyDescriptor(com.vmware.vise.search.metadata.PropertyDescriptor propertyDescriptor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyDescriptor});
        PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor();
        propertyDescriptor2.name = propertyDescriptor.getName();
        propertyDescriptor2.aliases = propertyDescriptor.getAliases();
        propertyDescriptor2.title = ResourceUtil.wrapIntoLocalizableTags((String)propertyDescriptor.getTitle());
        propertyDescriptor2.unit = propertyDescriptor.getUnit();
        propertyDescriptor2.displayForm = propertyDescriptor.getDisplayForm();
        propertyDescriptor2.description = DescriptorTransformer.getFullTitle(propertyDescriptor);
        if (propertyDescriptor.getProvider() != null) {
            propertyDescriptor2.providerName = propertyDescriptor.getProvider();
        }
        if (propertyDescriptor.getType() != null) {
            propertyDescriptor2.valueTypeName = propertyDescriptor.getType();
        }
        propertyDescriptor2.staticValueSpace = DescriptorTransformer.toStaticValueSpace(propertyDescriptor.getValueSpace());
        propertyDescriptor2.tags = propertyDescriptor.getTags();
        propertyDescriptor2.inapplicableOperators = propertyDescriptor.getInapplicableOperators();
        String string = propertyDescriptor.getStatus();
        propertyDescriptor2.sortable = UNSUPPORTED.equalsIgnoreCase(string) ? (propertyDescriptor.isUnsupportedPropertySortable() ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(true);
        return propertyDescriptor2;
    }

    private static XSFacet[] toStaticValueSpace(List<Restriction> list) {
        assert (list != null);
        XSFacet[] xSFacetArray = new XSFacet[list.size()];
        int n = 0;
        for (Restriction restriction : list) {
            xSFacetArray[n++] = DescriptorTransformer.createXSFacet(restriction);
        }
        return xSFacetArray;
    }

    private static XSFacet createXSFacet(Restriction restriction) {
        assert (restriction != null);
        XSFacet xSFacet = new XSFacet();
        xSFacet.type = XSFacetType.valueOf((String)restriction.getRestrictionType().toString());
        String string = restriction.getLabel();
        if (!StringUtil.isNullOrEmpty((String)string)) {
            String string2 = ResourceUtil.wrapIntoLocalizableTags((String)restriction.getLabel());
            xSFacet.value = new NameValuePair(string2, (Object)restriction.getValue());
        } else {
            xSFacet.value = restriction.getValue();
        }
        return xSFacet;
    }

    private static String getFullTitle(com.vmware.vise.search.metadata.PropertyDescriptor propertyDescriptor) {
        String string = ResourceUtil.wrapIntoLocalizableTags((String)propertyDescriptor.getTitle());
        String string2 = propertyDescriptor.getProvider();
        String string3 = String.format("%1$s %2$s", string2, string);
        return string3;
    }
}

