/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.Match;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.ResultSet;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.transport.AuthenticationException;
import com.vmware.vise.search.transport.HostConnectException;
import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceException;
import com.vmware.vise.search.transport.QueryServiceIndex;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.concurrent.ThreadPoolProfiler;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.data.adapters.search.QueryRequest;
import com.vmware.vise.vim.data.adapters.search.QueryResult;
import com.vmware.vise.vim.data.adapters.search.QueryServiceAuthenticationError;
import com.vmware.vise.vim.data.adapters.search.QueryServiceConnectionError;
import com.vmware.vise.vim.data.adapters.search.impl.MergedResultSet;
import com.vmware.vise.vim.data.adapters.search.impl.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutor {
    private static final String CONNECTION_ERROR_KEY = "error.queryService.connectionError";
    private static final String AUTHENTICATION_ERROR_KEY = "error.queryService.authenticationError";
    private static final Logger _logger = LoggerFactory.getLogger(QueryExecutor.class);
    private final SearchService _searchService;
    private final QueryServiceIndex _queryServiceIndex;
    private volatile boolean _validateLogin = true;
    private final ExecutorService _serenityThreadPool;
    private final ThreadPoolProfiler _threadPoolProfiler;

    private static QueryResult createErrorResult(QueryRequest queryRequest, final Exception exception) {
        ResultSet resultSet = new ResultSet(){

            public List<Match> getMatches() {
                return new ArrayList<Match>(0);
            }

            public List<FacetInfo> getFacetInfos() {
                return new ArrayList<FacetInfo>(0);
            }

            public int getMatchCount() {
                return 0;
            }

            public Exception getError() {
                return exception;
            }

            public Set<String> getQueriedServices() {
                return Collections.emptySet();
            }

            public Set<String> getIncludedServices() {
                return Collections.emptySet();
            }

            public boolean getSorted() {
                return true;
            }

            public boolean getPaged() {
                return true;
            }
        };
        QueryResult queryResult = new QueryResult(resultSet, queryRequest);
        return queryResult;
    }

    public QueryExecutor(SearchService searchService, ExecutorService executorService, QueryServiceIndex queryServiceIndex) {
        this._searchService = searchService;
        this._serenityThreadPool = executorService;
        this._queryServiceIndex = queryServiceIndex;
        this._threadPoolProfiler = this._serenityThreadPool instanceof ThreadPoolExecutor ? new ThreadPoolProfiler((ThreadPoolExecutor)this._serenityThreadPool) : null;
    }

    public void setValidateLogin(boolean bl) {
        this._validateLogin = bl;
    }

    public QueryResult[] execute(QueryRequest[] queryRequestArray) {
        if (this._validateLogin) {
            MixedUtil.throwIfSessionNotAuthenticated();
        }
        if (queryRequestArray.length == 0) {
            return new QueryResult[0];
        }
        Map<QueryRequest, Set<QueryService>> map = this.getQueryServicesByRequest(queryRequestArray);
        List<QueryResult> list = this.processEmptyRequests(map);
        List<QueryRequest> list2 = this.getRequestsToExecute(map);
        HashMap<QueryRequest, QueryRequest> hashMap = new HashMap<QueryRequest, QueryRequest>();
        List<QueryRequest> list3 = this.getSingleItemRequests(map, hashMap);
        QueryRequestExecutor queryRequestExecutor = new QueryRequestExecutor();
        ArrayList<QueryRequest> arrayList = new ArrayList<QueryRequest>();
        arrayList.addAll(list2);
        arrayList.addAll(list3);
        List<QueryResult> list4 = queryRequestExecutor.execute(arrayList);
        Map<QueryRequest, List<QueryResult>> map2 = QueryExecutor.getResultsByRequests(list4, new HashSet<QueryRequest>(list2));
        Map<QueryRequest, List<QueryResult>> map3 = QueryExecutor.getResultsByRequests(list4, new HashSet<QueryRequest>(list3));
        List<QueryRequest> list5 = this.extractMultiAdapterRequests(map2, map3, hashMap);
        List<QueryResult> list6 = queryRequestExecutor.execute(list5);
        List<QueryResult> list7 = new ArrayList<QueryResult>();
        list7.addAll(list);
        for (List<QueryResult> list8 : map2.values()) {
            list7.addAll(list8);
        }
        list7.addAll(list6);
        list7 = QueryExecutor.mergeResultsByQueryRequest(list7);
        QueryResult[] queryResultArray = QueryExecutor.orderResult(list7, queryRequestArray);
        return queryResultArray;
    }

    private List<QueryRequest> getRequestsToExecute(Map<QueryRequest, Set<QueryService>> map) {
        assert (map != null);
        ArrayList<QueryRequest> arrayList = new ArrayList<QueryRequest>();
        for (QueryRequest queryRequest : map.keySet()) {
            Set<QueryService> set = map.get(queryRequest);
            for (QueryService queryService : set) {
                QueryRequest queryRequest2 = QueryRequest.buildQueryRequest(queryRequest, queryService);
                arrayList.add(queryRequest2);
            }
        }
        return arrayList;
    }

    private List<QueryRequest> getSingleItemRequests(Map<QueryRequest, Set<QueryService>> map, Map<QueryRequest, QueryRequest> map2) {
        assert (map != null);
        ArrayList<QueryRequest> arrayList = new ArrayList<QueryRequest>();
        for (QueryRequest queryRequest : map.keySet()) {
            Set<QueryService> set = map.get(queryRequest);
            if (!QueryExecutor.isMultiVc(set) || !QueryExecutor.hasOffset(queryRequest)) continue;
            QueryRequest queryRequest2 = QueryExecutor.getSingleItemRequest(queryRequest);
            map2.put(queryRequest2, queryRequest);
            for (QueryService queryService : set) {
                QueryRequest queryRequest3 = QueryRequest.buildQueryRequest(queryRequest2, queryService);
                arrayList.add(queryRequest3);
            }
        }
        return arrayList;
    }

    private List<QueryRequest> extractMultiAdapterRequests(Map<QueryRequest, List<QueryResult>> map, Map<QueryRequest, List<QueryResult>> map2, Map<QueryRequest, QueryRequest> map3) {
        assert (map != null);
        assert (map2 != null);
        assert (map3 != null);
        ArrayList<QueryRequest> arrayList = new ArrayList<QueryRequest>();
        for (QueryRequest queryRequest : map2.keySet()) {
            Object object;
            List<QueryResult> list = map2.get(queryRequest);
            ArrayList<QueryResult> arrayList2 = new ArrayList<QueryResult>();
            for (QueryResult queryResult : list) {
                if (queryResult.resultSet == null || queryResult.resultSet.getMatches() == null || queryResult.resultSet.getMatches().size() <= 0) continue;
                arrayList2.add(queryResult);
            }
            if (arrayList2.isEmpty()) continue;
            if (arrayList2.size() == 1) {
                object = (QueryResult)arrayList2.get(0);
                if (((QueryResult)object).resultSet.getMatches().size() <= 1) continue;
            }
            object = map3.get(queryRequest);
            QueryExecutor.adjustMultiServiceResponseSpec((QueryRequest)object);
            map.remove(object);
            for (QueryResult queryResult : arrayList2) {
                QueryRequest queryRequest2 = QueryRequest.buildQueryRequest((QueryRequest)object, queryResult.request.getQueryService());
                arrayList.add(queryRequest2);
            }
        }
        return arrayList;
    }

    private List<QueryResult> processEmptyRequests(Map<QueryRequest, Set<QueryService>> map) {
        assert (map != null);
        ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>();
        for (QueryRequest object : map.keySet()) {
            Set<QueryService> set = map.get(object);
            if (!set.isEmpty()) continue;
            arrayList.add(QueryExecutor.createErrorResult(object, null));
        }
        for (QueryResult queryResult : arrayList) {
            map.remove(queryResult.request);
        }
        return arrayList;
    }

    private Map<QueryRequest, Set<QueryService>> getQueryServicesByRequest(QueryRequest[] queryRequestArray) {
        assert (queryRequestArray != null);
        HashMap<QueryRequest, Set<QueryService>> hashMap = new HashMap<QueryRequest, Set<QueryService>>();
        for (QueryRequest queryRequest : queryRequestArray) {
            Set<QueryService> set = this.getQueryServicesForQuery(queryRequest);
            hashMap.put(queryRequest, set);
        }
        return hashMap;
    }

    private static boolean isMultiVc(Set<QueryService> set) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        if (set.size() > 1) {
            return true;
        }
        QueryService queryService = set.iterator().next();
        boolean bl = queryService.isMultiVc();
        return bl;
    }

    private static Map<QueryRequest, List<QueryResult>> getResultsByRequests(List<QueryResult> list, Set<QueryRequest> set) {
        HashMap<QueryRequest, List<QueryResult>> hashMap = new HashMap<QueryRequest, List<QueryResult>>();
        HashMap hashMap2 = new HashMap();
        for (QueryResult queryResult : list) {
            HashSet<Set> hashSet;
            if (!set.contains(queryResult.request)) continue;
            ArrayList<QueryResult> arrayList = (ArrayList<QueryResult>)hashMap.get(queryResult.request);
            if (arrayList == null) {
                arrayList = new ArrayList<QueryResult>();
                hashMap.put(queryResult.request, arrayList);
                hashSet = new HashSet<Set>();
                hashMap2.put(queryResult.request, hashSet);
            } else {
                hashSet = (HashSet<Set>)hashMap2.get(queryResult.request);
            }
            Set set2 = queryResult.resultSet.getIncludedServices();
            if (hashSet.contains(set2)) {
                _logger.warn("Getting duplicated results back. _queryServiceIndex failed to recognize that VCs are in linked-mode: " + set2);
                continue;
            }
            arrayList.add(queryResult);
            hashSet.add(set2);
        }
        return hashMap;
    }

    private static QueryRequest getSingleItemRequest(QueryRequest queryRequest) {
        assert (queryRequest != null);
        assert (queryRequest.getResponseSpec() != null);
        ResponseSpec responseSpec = (ResponseSpec)ObjectUtil.shallowCopy((Object)queryRequest.getResponseSpec(), ResponseSpec.class);
        responseSpec.maxResultsCount = 1;
        responseSpec.offset = 1;
        QueryRequest queryRequest2 = new QueryRequest(queryRequest.getQueryName(), queryRequest.getQuerySpec(), responseSpec, queryRequest.getDsQuerySpec());
        return queryRequest2;
    }

    private static QueryResult[] orderResult(List<QueryResult> list, QueryRequest[] queryRequestArray) {
        QueryResult[] queryResultArray = new QueryResult[list.size()];
        Map<QueryRequest, QueryResult> map = QueryExecutor.toRequestResultMap(list);
        int n = 0;
        for (QueryRequest queryRequest : queryRequestArray) {
            queryResultArray[n++] = map.get(queryRequest);
        }
        return queryResultArray;
    }

    private static Map<QueryRequest, QueryResult> toRequestResultMap(List<QueryResult> list) {
        HashMap<QueryRequest, QueryResult> hashMap = new HashMap<QueryRequest, QueryResult>(list.size());
        for (QueryResult queryResult : list) {
            hashMap.put(queryResult.request, queryResult);
        }
        return hashMap;
    }

    private QueryResult executeSingleQuery(QueryRequest queryRequest) throws QueryServiceException, InterruptedException {
        ResultSet resultSet = this._searchService.search(queryRequest.getQueryService(), queryRequest.getQuerySpec(), queryRequest.getResponseSpec());
        return new QueryResult(resultSet, queryRequest);
    }

    private Set<QueryService> getQueryServicesForQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new IllegalArgumentException("Query requests cannot be null or empty.");
        }
        if (this._queryServiceIndex == null) {
            throw new IllegalArgumentException(" _queryServiceIndex needs to be set.");
        }
        Object[] objectArray = Utils.getEnumeratedObjects(queryRequest.getQuerySpec());
        Set<String> set = QueryExecutor.getUniqueServerGuids(objectArray);
        Set<QueryService> set2 = this.getQueryServicesForServerIds(set);
        if (!set2.isEmpty()) {
            return set2;
        }
        set2 = new HashSet<QueryService>();
        set2.addAll(this._queryServiceIndex.getDefaultQueryServices());
        return set2;
    }

    private static Set<String> getUniqueServerGuids(Object[] objectArray) {
        assert (objectArray != null);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : objectArray) {
            if (object == null) {
                _logger.warn("null object ref should not happen here.");
                continue;
            }
            String string = QueryUtil.getReferenceServerGuid((Object)object);
            if (string == null) {
                String string2 = QueryUtil.getReferenceType((Object)object);
                if (ModelUtils.isVmodl2Name((String)string2)) continue;
                _logger.warn("object with no server guid: " + object);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set<QueryService> getQueryServicesForServerIds(Collection<String> collection) {
        assert (collection != null);
        HashSet<QueryService> hashSet = new HashSet<QueryService>();
        for (String string : collection) {
            List list = this._queryServiceIndex.getQueryServices(string);
            if (list.isEmpty()) {
                return Collections.emptySet();
            }
            hashSet.addAll(list);
        }
        return hashSet;
    }

    private static List<QueryResult> mergeResultsByQueryRequest(List<QueryResult> list) {
        if (list == null) {
            throw new IllegalArgumentException("queryResults");
        }
        Map<QueryRequest, List<QueryResult>> map = QueryExecutor.getResultsByRequest(list);
        ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>();
        for (QueryRequest queryRequest : map.keySet()) {
            List<QueryResult> list2 = map.get(queryRequest);
            if (list2.size() == 1) {
                arrayList.add(list2.get(0));
                continue;
            }
            MergedResultSet mergedResultSet = new MergedResultSet(list2);
            arrayList.add(new QueryResult(mergedResultSet, queryRequest));
        }
        return arrayList;
    }

    private static Map<QueryRequest, List<QueryResult>> getResultsByRequest(List<QueryResult> list) {
        assert (list != null);
        HashMap<QueryRequest, List<QueryResult>> hashMap = new HashMap<QueryRequest, List<QueryResult>>();
        for (QueryResult queryResult : list) {
            ArrayList<QueryResult> arrayList = (ArrayList<QueryResult>)hashMap.get(queryResult.request);
            if (arrayList == null) {
                arrayList = new ArrayList<QueryResult>();
                hashMap.put(queryResult.request, arrayList);
            }
            arrayList.add(queryResult);
        }
        return hashMap;
    }

    private static boolean hasOffset(QueryRequest queryRequest) {
        assert (queryRequest != null);
        ResponseSpec responseSpec = queryRequest.getResponseSpec();
        if (responseSpec == null) {
            return false;
        }
        boolean bl = responseSpec.offset > 1;
        return bl;
    }

    private static void adjustMultiServiceResponseSpec(QueryRequest queryRequest) {
        assert (queryRequest != null);
        ResponseSpec responseSpec = queryRequest.getResponseSpec();
        if (responseSpec == null) {
            return;
        }
        if (responseSpec.offset == 1) {
            return;
        }
        if (responseSpec.maxResultsCount > 0) {
            responseSpec.maxResultsCount = responseSpec.maxResultsCount + responseSpec.offset - 1;
        }
        responseSpec.offset = 1;
    }

    private class QueryRequestExecutor {
        private QueryRequestExecutor() {
        }

        public List<QueryResult> execute(List<QueryRequest> list) {
            int n;
            if (list == null) {
                throw new IllegalArgumentException("requests");
            }
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            Future[] futureArray = new Future[list.size()];
            ArrayList<QueryResult> arrayList = new ArrayList<QueryResult>(list.size());
            futureArray[0] = this.getFuture(list.get(0));
            if (list.size() > 1) {
                for (n = 1; n < list.size(); ++n) {
                    try {
                        futureArray[n] = QueryExecutor.this._serenityThreadPool.submit(this.getTask(list.get(n), SessionUtil.getHttpRequest()));
                        continue;
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        _logger.warn("Query execution on thread pool rejected. Executing on the current thread. ", (Throwable)rejectedExecutionException);
                        Future<QueryResult> future = this.getFuture(list.get(n));
                        this.waitForQueryResult(future, list.get(n), arrayList);
                    }
                }
            }
            if (QueryExecutor.this._threadPoolProfiler != null) {
                QueryExecutor.this._threadPoolProfiler.profileThreadPoolIfBusy();
            }
            for (n = 0; n < list.size(); ++n) {
                if (futureArray[n] == null) continue;
                this.waitForQueryResult(futureArray[n], list.get(n), arrayList);
            }
            return arrayList;
        }

        private void waitForQueryResult(Future<QueryResult> future, QueryRequest queryRequest, List<QueryResult> list) {
            try {
                list.add(future.get());
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof HostConnectException || throwable instanceof AuthenticationException) {
                    boolean bl = throwable instanceof AuthenticationException;
                    QueryServiceException queryServiceException = (QueryServiceException)throwable;
                    String string = this.getQsErrorMessage(bl ? QueryExecutor.AUTHENTICATION_ERROR_KEY : QueryExecutor.CONNECTION_ERROR_KEY, queryServiceException.getServiceUrl());
                    QueryServiceConnectionError queryServiceConnectionError = bl ? new QueryServiceAuthenticationError(string, throwable) : new QueryServiceConnectionError(string, queryServiceException);
                    this.handleError(queryRequest, (Exception)((Object)queryServiceConnectionError), list);
                } else {
                    this.handleError(queryRequest, executionException, list);
                }
            }
            catch (Exception exception) {
                this.handleError(queryRequest, exception, list);
            }
        }

        private void handleError(QueryRequest queryRequest, Exception exception, List<QueryResult> list) {
            _logger.error("Error executing query {}: {}: {}", new Object[]{queryRequest.getQueryName(), exception.getClass().getName(), exception.getMessage()});
            _logger.debug("", (Throwable)exception);
            list.add(QueryExecutor.createErrorResult(queryRequest, exception));
        }

        private String getQsErrorMessage(String string, String string2) {
            return String.format(Utils.getLocalizedString(string), string2);
        }

        private Future<QueryResult> getFuture(final QueryRequest queryRequest) {
            return new Future<QueryResult>(){

                @Override
                public boolean isDone() {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public QueryResult get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                    return null;
                }

                @Override
                public QueryResult get() throws InterruptedException, ExecutionException {
                    QueryRequest queryRequest2 = queryRequest.getDeepCopy();
                    try {
                        QueryResult queryResult = QueryExecutor.this.executeSingleQuery(queryRequest2);
                        QueryResult queryResult2 = new QueryResult(queryResult.resultSet, queryRequest);
                        return queryResult2;
                    }
                    catch (QueryServiceException queryServiceException) {
                        throw new ExecutionException(queryServiceException);
                    }
                }

                @Override
                public boolean cancel(boolean bl) {
                    return false;
                }
            };
        }

        private Callable<QueryResult> getTask(final QueryRequest queryRequest, HttpServletRequest httpServletRequest) {
            final QueryRequest queryRequest2 = queryRequest.getDeepCopy();
            final SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext();
            return new Callable<QueryResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public QueryResult call() throws Exception {
                    try {
                        QueryResult queryResult;
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                        QueryResult queryResult2 = QueryExecutor.this.executeSingleQuery(queryRequest2);
                        QueryResult queryResult3 = queryResult = new QueryResult(queryResult2.resultSet, queryRequest);
                        return queryResult3;
                    }
                    finally {
                        SessionUtil.setThreadContext(null);
                    }
                }
            };
        }
    }
}

