/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.transport.QueryOptions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.data.adapters.common.ResourceAndModelNameResolver;
import com.vmware.vise.vim.data.adapters.search.QueryRequest;
import com.vmware.vise.vim.data.adapters.search.impl.ConstraintTransformer;
import com.vmware.vise.vim.data.adapters.search.impl.ResultSpecTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public class QueryRequestTransformer {
    private final ConstraintTransformer _constraintTransformer;
    private final ResultSpecTransformer _resultSpecTransformer;
    private final ObjectReferenceService _objectRefSvc;
    private final ResourceAndModelNameResolver _resourceAndModelNameResolver;
    private String _defaultProviderId = "vpx";

    public QueryRequestTransformer(SearchService searchService, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{searchService});
        this._constraintTransformer = new ConstraintTransformer(searchService.getConstraintFactory(), objectReferenceService);
        this._resultSpecTransformer = new ResultSpecTransformer();
        this._objectRefSvc = objectReferenceService;
        this._resourceAndModelNameResolver = new ResourceAndModelNameResolver(objectReferenceService);
    }

    public String getDefaultProviderId() {
        return this._defaultProviderId;
    }

    public void setDefaultProviderId(String string) {
        this._defaultProviderId = string;
    }

    public QueryRequest toQueryRequest(com.vmware.vise.data.query.QuerySpec querySpec) {
        com.vmware.vise.data.Constraint constraint = null;
        if (querySpec.resourceSpec != null) {
            constraint = querySpec.resourceSpec.constraint;
        }
        Constraint constraint2 = this._constraintTransformer.getSearchConstraint(constraint);
        QueryOptions queryOptions = this.calcQueryOptions(querySpec);
        QuerySpec querySpec2 = new QuerySpec();
        querySpec2.constraint = constraint2;
        querySpec2.options = queryOptions;
        querySpec2.name = querySpec.name;
        ResponseSpec responseSpec = this._resultSpecTransformer.toResponseSpec(constraint2.getSearchTarget(), querySpec.resourceSpec.propertySpecs, querySpec.resultSpec);
        QueryRequest queryRequest = new QueryRequest(querySpec.name, querySpec2, responseSpec, querySpec);
        return queryRequest;
    }

    private QueryOptions calcQueryOptions(com.vmware.vise.data.query.QuerySpec querySpec) {
        String[] stringArray;
        assert (querySpec != null);
        Object var2_2 = null;
        if (querySpec.options != null) {
            var2_2 = querySpec.options.get(QueryOption.FORCE_SOURCE_SYNC.name());
        }
        QueryOptions queryOptions = new QueryOptions();
        boolean bl = false;
        if (var2_2 != null) {
            stringArray = QueryRequestTransformer.getExplicitSyncProviders(var2_2);
            boolean bl2 = bl = stringArray != null;
            if (!bl && var2_2 instanceof Boolean) {
                bl = var2_2;
            }
            if (bl) {
                this.applyForceSyncOptions(querySpec, queryOptions, stringArray);
            }
        }
        if (!bl && (stringArray = MapUtils.getObject((Map)querySpec.options, (Object)QueryOption.PROVIDER_SCOPE.name())) instanceof String) {
            queryOptions.targetSpecificProviderName = (String)stringArray;
        }
        queryOptions.federated = this.requestIsForFederatedQuery(querySpec.options);
        return queryOptions;
    }

    private static String[] getExplicitSyncProviders(Object object) {
        if (object instanceof String) {
            return new String[]{(String)object};
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The provided query option " + QueryOption.FORCE_SOURCE_SYNC.name() + " contains a value, which is not of type String.", classCastException);
            }
            return stringArray;
        }
        return null;
    }

    private void applyForceSyncOptions(com.vmware.vise.data.query.QuerySpec querySpec, QueryOptions queryOptions, String[] stringArray) {
        Set<String> set;
        assert (querySpec != null);
        assert (queryOptions != null);
        Set<String> set2 = this.getSyncProviders(querySpec, stringArray);
        if (set2.isEmpty()) {
            return;
        }
        String[] stringArray2 = set2.toArray(new String[set2.size()]);
        queryOptions.providersToSync = stringArray2;
        Object object = this.getConstrainedServerRef(querySpec.resourceSpec.constraint);
        if (object == null) {
            return;
        }
        String string = this._objectRefSvc.getServerGuid(object);
        if (VimSessionUtil.getService((String)string) != null && !ModelUtils.hasVmodl2Name(set = this._resourceAndModelNameResolver.resolve(querySpec.resourceSpec.constraint))) {
            this.setLegacyForceSyncOptions(queryOptions, object);
        }
    }

    private Set<String> getSyncProviders(com.vmware.vise.data.query.QuerySpec querySpec, String[] stringArray) {
        assert (querySpec != null);
        if (querySpec.resourceSpec == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        Set<String> set = this.harvestConstrainedServerGuids(querySpec.resourceSpec.constraint);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private void setLegacyForceSyncOptions(QueryOptions queryOptions, Object object) {
        String string;
        String string2;
        assert (queryOptions != null);
        assert (object != null);
        String string3 = this._objectRefSvc.getResourceObjectType(object);
        if (!QueryRequestTransformer.isInDefaultNamespace(string3)) {
            return;
        }
        queryOptions.targetSpecificProviderUuid = string2 = (string = this._objectRefSvc.getServerGuid(object));
        queryOptions.forceProviderSync = Boolean.TRUE;
        queryOptions.targetSpecificProviderName = this._defaultProviderId;
    }

    private boolean requestIsForFederatedQuery(Map<String, Object> map) {
        Object object;
        boolean bl = map == null ? true : (object = map.get(QueryOption.LOCAL_SCOPE.name())) == null || object.equals(false);
        return bl;
    }

    private Set<String> harvestConstrainedServerGuids(com.vmware.vise.data.Constraint constraint) {
        if (constraint instanceof PropertyConstraint) {
            return Collections.emptySet();
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            String string = this._objectRefSvc.getServerGuid(objectIdentityConstraint.target);
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(string);
            return hashSet;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Set<String> set = this.harvestConstrainedServerGuids(relationalConstraint.constraintOnRelatedObject);
            return set;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            Set<String> set = this.harvestCompositeConstraint(compositeConstraint);
            return set;
        }
        return Collections.emptySet();
    }

    private Set<String> harvestCompositeConstraint(CompositeConstraint compositeConstraint) {
        assert (compositeConstraint != null);
        if (compositeConstraint.nestedConstraints == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (com.vmware.vise.data.Constraint constraint : compositeConstraint.nestedConstraints) {
            Set<String> set = this.harvestConstrainedServerGuids(constraint);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Object getConstrainedServerRef(com.vmware.vise.data.Constraint constraint) {
        if (constraint instanceof PropertyConstraint) {
            return null;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            Object object = objectIdentityConstraint.target;
            return object;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Object object = this.getConstrainedServerRef(relationalConstraint.constraintOnRelatedObject);
            return object;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            Object object = this.handleCompositeConstraint(compositeConstraint);
            return object;
        }
        return null;
    }

    private Object handleCompositeConstraint(CompositeConstraint compositeConstraint) {
        assert (compositeConstraint != null);
        if (compositeConstraint.nestedConstraints == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(compositeConstraint.nestedConstraints.length);
        for (com.vmware.vise.data.Constraint constraint : compositeConstraint.nestedConstraints) {
            Object object = this.getConstrainedServerRef(constraint);
            arrayList.add(object);
        }
        Object object = this.getServerRefFromCompositeConstraint(compositeConstraint.conjoiner, arrayList);
        return object;
    }

    private Object getServerRefFromCompositeConstraint(Conjoiner conjoiner, List<Object> list) {
        assert (conjoiner != null);
        assert (list != null);
        Object object = null;
        for (Object object2 : list) {
            String string = this.getServerGuidSafely(object2);
            if (StringUtil.isNullOrEmpty((String)string)) {
                if (!conjoiner.equals((Object)Conjoiner.OR)) continue;
                return null;
            }
            String string2 = this.getServerGuidSafely(object);
            if (object != null && !string.equals(string2)) {
                return null;
            }
            object = object2;
        }
        return object;
    }

    private String getServerGuidSafely(Object object) {
        if (object == null) {
            return null;
        }
        String string = this._objectRefSvc.getServerGuid(object);
        return string;
    }

    private static boolean isInDefaultNamespace(String string) {
        String string2 = NamespaceUtils.getNamespace((String)string);
        return NamespaceUtils.DEFAULT_NAMESPACE.equals(string2);
    }
}

