/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.ManagedProperty;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.search.ComparisonOperator;
import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.RelationalConstraint;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final String RESOURCE_BUNDLE_NAME = "DataServiceAdapters";
    private static final Logger _logger = LoggerFactory.getLogger(Utils.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)Utils.class.getClassLoader());
    }

    public static String getLocalizedString(String string, String[] stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)Utils.class.getClassLoader());
    }

    public static ComparisonOperator toComparisonOperator(Comparator comparator) {
        if (comparator.equals((Object)Comparator.CONTAINS)) {
            return ComparisonOperator.CONTAINS;
        }
        if (comparator.equals((Object)Comparator.CONTAINS_ANY_OF)) {
            return ComparisonOperator.CONTAINS_ANY_OF;
        }
        if (comparator.equals((Object)Comparator.ENDS_WITH)) {
            return ComparisonOperator.ENDS_WITH;
        }
        if (comparator.equals((Object)Comparator.EQUALS)) {
            return ComparisonOperator.EQUALS;
        }
        if (comparator.equals((Object)Comparator.EQUALS_ANY_OF)) {
            return ComparisonOperator.EQUALS_ANY_OF;
        }
        if (comparator.equals((Object)Comparator.GREATER)) {
            return ComparisonOperator.GREATER;
        }
        if (comparator.equals((Object)Comparator.GREATER_OR_EQUALS)) {
            return ComparisonOperator.GREATER_OR_EQUALS;
        }
        if (comparator.equals((Object)Comparator.MATCHES)) {
            return ComparisonOperator.MATCHES;
        }
        if (comparator.equals((Object)Comparator.NOT_EQUALS)) {
            return ComparisonOperator.NOT_EQUALS;
        }
        if (comparator.equals((Object)Comparator.RANGES_BETWEEN)) {
            return ComparisonOperator.RANGES_BETWEEN;
        }
        if (comparator.equals((Object)Comparator.SMALLER)) {
            return ComparisonOperator.SMALLER;
        }
        if (comparator.equals((Object)Comparator.SMALLER_OR_EQUALS)) {
            return ComparisonOperator.SMALLER_OR_EQUALS;
        }
        if (comparator.equals((Object)Comparator.STARTS_WITH)) {
            return ComparisonOperator.STARTS_WITH;
        }
        if (comparator.equals((Object)Comparator.TEXTUALLY_MATCHES)) {
            return ComparisonOperator.TEXTUALLY_MATCHES;
        }
        return null;
    }

    public static String serializeMO(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return null;
        }
        return managedObjectReference.getServerGuid() + ":" + managedObjectReference.getType() + ":" + managedObjectReference.getValue();
    }

    public static ServiceEndpointEx getInventoryServiceEndpoint(VcService vcService) {
        String string = vcService.getServiceGuid();
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            String string2;
            if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.IS || !string.equals(string2 = serviceEndpointEx.getVcGuid())) continue;
            return serviceEndpointEx;
        }
        String string3 = Utils.getLocalizedString("error.EndpointNotFound");
        throw MixedUtil.getRuntimeFault((String)string3);
    }

    public static Set<ServiceEndpointEx> getInventoryServiceEndpoints(Collection<String> collection, boolean bl) {
        if (collection == null) {
            return Collections.emptySet();
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            _logger.info("VimSessionUtil.getLinkedVcGroupRegistry() returned null.");
            return Collections.emptySet();
        }
        HashSet<ServiceEndpointEx> hashSet = new HashSet<ServiceEndpointEx>();
        for (String string : collection) {
            ServiceEndpointEx[] serviceEndpointExArray;
            LinkedVcGroup linkedVcGroup = linkedVcGroupRegistry.getLinkedGroupByServiceUuid(string);
            if (linkedVcGroup == null) continue;
            for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = linkedVcGroup.getServiceEndPoints()) {
                if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.IS || !bl && !collection.contains(serviceEndpointEx.getInstanceUuid()) && !collection.contains(serviceEndpointEx.getVcGuid())) continue;
                hashSet.add(serviceEndpointEx);
            }
        }
        return hashSet;
    }

    public static Object[] getEnumeratedObjects(QuerySpec querySpec) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Utils.fillObjectsFromConstraints(querySpec.constraint, arrayList, true);
        return arrayList.toArray();
    }

    static List<TypeInfo> getProviderTypes(List<PropertyDescriptor> list) {
        List list2;
        if (list == null) {
            return Collections.emptyList();
        }
        HashMap hashMap = new HashMap();
        for (PropertyDescriptor object : list) {
            String string = object.getProvider();
            list2 = (ArrayList<String>)hashMap.get(string);
            if (list2 == null) {
                list2 = new ArrayList<String>();
                hashMap.put(string, list2);
            }
            list2.add(object.getName());
        }
        ArrayList arrayList = new ArrayList();
        for (String string : hashMap.keySet()) {
            list2 = (List)hashMap.get(string);
            String[] stringArray = list2.toArray(EMPTY_STRING_ARRAY);
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = string;
            typeInfo.properties = stringArray;
            arrayList.add(typeInfo);
        }
        return arrayList;
    }

    static List<TypeInfo> getAdapterTypes(List<TypeDescriptor> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        for (TypeDescriptor typeDescriptor : list) {
            String string = typeDescriptor.getType();
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = string;
            typeInfo.properties = Utils.getProperties(string);
            arrayList.add(typeInfo);
        }
        return arrayList;
    }

    private static void fillObjectsFromConstraints(Constraint constraint, ArrayList<Object> arrayList, boolean bl) {
        if (constraint == null) {
            return;
        }
        if (ObjectIdentityConstraint.class.isInstance(constraint)) {
            ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)constraint;
            arrayList.add(objectIdentityConstraint.getTarget());
        } else if (CompositeConstraint.class.isInstance(constraint)) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            for (Constraint constraint2 : compositeConstraint.getNestedConstraints()) {
                Utils.fillObjectsFromConstraints(constraint2, arrayList, bl);
            }
        } else if (RelationalConstraint.class.isInstance(constraint) && bl) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            Utils.fillObjectsFromConstraints(relationalConstraint.getNestedConstraint(), arrayList, bl);
        }
    }

    private static String[] getProperties(String string) {
        String[] stringArray;
        assert (string != null);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ManagedProperty[] managedPropertyArray;
            stringArray = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string);
            if (!(stringArray instanceof ManagedObjectType)) {
                return EMPTY_STRING_ARRAY;
            }
            ManagedObjectType managedObjectType = (ManagedObjectType)stringArray;
            for (ManagedProperty managedProperty : managedPropertyArray = managedObjectType.getManagedProperties()) {
                arrayList.add(managedProperty.getName());
            }
            arrayList.add("*");
        }
        catch (Exception exception) {
            _logger.error("Error happened when processing all properties for " + string, (Throwable)exception);
        }
        stringArray = arrayList.toArray(EMPTY_STRING_ARRAY);
        return stringArray;
    }

    public static DynamicProviderResultSet newDynamicProviderResultSet(String string, Exception exception) {
        DynamicProviderResultSet dynamicProviderResultSet = new DynamicProviderResultSet();
        dynamicProviderResultSet.queryName = string == null ? "" : string;
        dynamicProviderResultSet.items = new ResultItem[0];
        dynamicProviderResultSet.error = MixedUtil.getMethodFault((Throwable)exception);
        dynamicProviderResultSet.sorted = true;
        dynamicProviderResultSet.paged = true;
        return dynamicProviderResultSet;
    }
}

