/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.vapi.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProviderRegistry;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProviderService;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceModelTypeProviderRegistryImpl
implements ResourceModelTypeProviderRegistry,
ResourceModelTypeProvider {
    private static final Log _logger = LogFactory.getLog(ResourceModelTypeProviderRegistryImpl.class);
    private static final int DEFAULT_CACHE_SIZE = 200;
    private static final char PACKAGE_DELIMITER = '.';
    private final ReadWriteLock _providerMapLock = new ReentrantReadWriteLock();
    @GuardedBy(value="_providerMapLock")
    private final Map<String, Set<ResourceModelTypeProvider>> _providerByPackage = new HashMap<String, Set<ResourceModelTypeProvider>>();
    private final LoadingCache<String, StructType> _structTypeByModelCanonicalNameCache;
    private static final StructType UNDEFINED_STRUCT_TYPE = new StructType("N/A", Collections.emptyMap(), Object.class, null, false, null, null);

    public ResourceModelTypeProviderRegistryImpl(ServiceRegistry serviceRegistry) {
        this(serviceRegistry, 200);
    }

    public ResourceModelTypeProviderRegistryImpl(ServiceRegistry serviceRegistry, int n) {
        this._structTypeByModelCanonicalNameCache = n > 0 ? CacheBuilder.newBuilder().maximumSize((long)n).build((CacheLoader)new CacheLoader<String, StructType>(){

            public StructType load(String string) {
                StructType structType = ResourceModelTypeProviderRegistryImpl.this.doGetResourceModelType(string);
                if (structType == null) {
                    structType = UNDEFINED_STRUCT_TYPE;
                }
                return structType;
            }
        }) : null;
        if (serviceRegistry != null) {
            serviceRegistry.registerServiceListener(ResourceModelTypeProviderService.class.getName(), (ServiceListener)new ResourceModelTypeProviderServiceListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerResourceModelTypeProvider(String string, ResourceModelTypeProvider resourceModelTypeProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resourceModelTypeProvider});
        if (StringUtil.isNullOrWhitespace((String)string)) {
            string = null;
        }
        this._providerMapLock.writeLock().lock();
        try {
            boolean bl;
            Set<ResourceModelTypeProvider> set = this._providerByPackage.get(string);
            if (set == null) {
                set = new HashSet<ResourceModelTypeProvider>(1);
                this._providerByPackage.put(string, set);
            }
            boolean bl2 = bl = set.add(resourceModelTypeProvider);
            return bl2;
        }
        finally {
            this._providerMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterResourceModelTypeProvider(String string, ResourceModelTypeProvider resourceModelTypeProvider) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{resourceModelTypeProvider});
        if (StringUtil.isNullOrWhitespace((String)string)) {
            string = null;
        }
        this._providerMapLock.writeLock().lock();
        try {
            Set<ResourceModelTypeProvider> set = this._providerByPackage.get(string);
            if (set == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = set.remove(resourceModelTypeProvider);
            if (bl) {
                if (set.size() == 0) {
                    this._providerByPackage.remove(string);
                }
                if (this._structTypeByModelCanonicalNameCache != null) {
                    this._structTypeByModelCanonicalNameCache.invalidateAll();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this._providerMapLock.writeLock().unlock();
        }
    }

    public StructType getResourceModelType(String string) {
        StructType structType;
        if (this._structTypeByModelCanonicalNameCache != null) {
            try {
                structType = (StructType)this._structTypeByModelCanonicalNameCache.get((Object)string);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                _logger.error((Object)("Failed to retrieve the resource model type for " + string), throwable);
                return null;
            }
        } else {
            structType = this.doGetResourceModelType(string);
        }
        if (structType == UNDEFINED_STRUCT_TYPE) {
            structType = null;
        }
        return structType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructType doGetResourceModelType(String string) {
        this._providerMapLock.readLock().lock();
        try {
            Set<ResourceModelTypeProvider> set;
            String string2 = string;
            do {
                StructType structType;
                if ((set = this._providerByPackage.get(string2 = this.getParentPackage(string2))) == null || (structType = this.queryResourceModelTypeProviders(set, string)) == null) continue;
                StructType structType2 = structType;
                return structType2;
            } while (string2 != null);
            set = null;
            return set;
        }
        finally {
            this._providerMapLock.readLock().unlock();
        }
    }

    private String getParentPackage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        return string2;
    }

    private StructType queryResourceModelTypeProviders(Set<ResourceModelTypeProvider> set, String string) {
        if (set != null) {
            for (ResourceModelTypeProvider resourceModelTypeProvider : set) {
                try {
                    StructType structType = resourceModelTypeProvider.getResourceModelType(string);
                    if (structType == null) continue;
                    return structType;
                }
                catch (Exception exception) {
                    _logger.error((Object)(ResourceModelTypeProvider.class.getSimpleName() + " " + resourceModelTypeProvider + " threw an exception. Continuing with the " + "next provider, if any."), (Throwable)exception);
                }
            }
        }
        return null;
    }

    private class ResourceModelTypeProviderServiceListener
    implements ServiceListener {
        private ResourceModelTypeProviderServiceListener() {
        }

        public void serviceAdded(Object object) {
            ResourceModelTypeProviderService resourceModelTypeProviderService = (ResourceModelTypeProviderService)object;
            if (!this.serviceIsValid(resourceModelTypeProviderService)) {
                return;
            }
            ResourceModelTypeProvider resourceModelTypeProvider = resourceModelTypeProviderService.getResourceModelTypeProvider();
            Set set = resourceModelTypeProviderService.getPackageNames();
            if (set == null) {
                ResourceModelTypeProviderRegistryImpl.this.registerResourceModelTypeProvider(null, resourceModelTypeProvider);
            } else {
                for (String string : set) {
                    ResourceModelTypeProviderRegistryImpl.this.registerResourceModelTypeProvider(string, resourceModelTypeProvider);
                }
            }
        }

        public void serviceRemoved(Object object) {
            ResourceModelTypeProviderService resourceModelTypeProviderService = (ResourceModelTypeProviderService)object;
            if (!this.serviceIsValid(resourceModelTypeProviderService)) {
                return;
            }
            ResourceModelTypeProvider resourceModelTypeProvider = resourceModelTypeProviderService.getResourceModelTypeProvider();
            Set set = resourceModelTypeProviderService.getPackageNames();
            if (set == null) {
                ResourceModelTypeProviderRegistryImpl.this.unregisterResourceModelTypeProvider(null, resourceModelTypeProvider);
            } else {
                for (String string : set) {
                    ResourceModelTypeProviderRegistryImpl.this.unregisterResourceModelTypeProvider(string, resourceModelTypeProvider);
                }
            }
        }

        private boolean serviceIsValid(ResourceModelTypeProviderService resourceModelTypeProviderService) {
            Set set = resourceModelTypeProviderService.getPackageNames();
            if (set == null || set.size() == 0) {
                _logger.error((Object)("Invalid " + ResourceModelTypeProviderService.class.getSimpleName() + ": packageNames is null or empty (" + resourceModelTypeProviderService + ")\n" + ExceptionUtil.getCurrentStackTrace()));
                return false;
            }
            return true;
        }
    }
}

