/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.messaging.amf;

import com.vmware.vise.extensionfw.BundlePackageInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.serialization.ClassDeserializationValidatorHelper;
import flex.messaging.MessageBroker;
import flex.messaging.validators.ClassDeserializationValidator;
import flex.messaging.validators.DeserializationValidator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.context.BundleContextAware;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class ClassDeserializationExtensionListener
implements ExtensionListener,
BundleContextAware {
    private static final String PLUGINS_URI = "plugins";
    private static final String MANIFEST_URI = "META-INF/MANIFEST.MF";
    private static final String FRAMEWORK_APP_CONTEXT = "org.springframework.web.servlet.FrameworkServlet.CONTEXT.springServlet";
    private static final Log _logger = LogFactory.getLog(ClassDeserializationExtensionListener.class);
    private Map<String, String> _webBundlesToMessageBrokerIdMap = new HashMap<String, String>();
    private BundleContext _bundleContext;
    private ClassDeserializationValidatorHelper _classDeserializationValidatorHelper;
    private Set<String> _excludedPluginPackageIds;

    public void setBundleContext(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void setClassDeserializationValidatorHelper(ClassDeserializationValidatorHelper classDeserializationValidatorHelper) {
        this._classDeserializationValidatorHelper = classDeserializationValidatorHelper;
    }

    public void setExcludedPluginPackages(Set<String> set) {
        this._excludedPluginPackageIds = set;
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if ("pluginPackageUndeployed".equals(pluginPackageEvent.getType())) {
            return;
        }
        this.processWebBundles();
        PluginPackageInfo[] pluginPackageInfoArray = pluginPackageEvent.getPluginPackageInfos();
        if (pluginPackageInfoArray == null || pluginPackageInfoArray.length == 0) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageInfoArray) {
            BundlePackageInfo bundlePackageInfo;
            String string;
            Map<String, BundlePackageInfo> map;
            if (this._excludedPluginPackageIds.contains(pluginPackageInfo.getId()) || (map = this.getBundleExportedPackages(pluginPackageInfo.getDirectory())).isEmpty()) continue;
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, BundlePackageInfo> entry : map.entrySet()) {
                string = entry.getKey();
                if (this._webBundlesToMessageBrokerIdMap.containsKey(string)) {
                    arrayList.add(string);
                }
                bundlePackageInfo = entry.getValue();
                hashSet.addAll(bundlePackageInfo.getExportPackages());
            }
            hashSet.add("com.vmware");
            if (this._classDeserializationValidatorHelper != null) {
                this._classDeserializationValidatorHelper.addAllowClassPatterns(hashSet);
            }
            for (String string2 : arrayList) {
                string = this._webBundlesToMessageBrokerIdMap.get(string2);
                bundlePackageInfo = MessageBroker.getMessageBroker((String)string);
                if (bundlePackageInfo == null) {
                    _logger.error((Object)("Failed to find message broker for id " + string));
                    continue;
                }
                ClassDeserializationValidator classDeserializationValidator = null;
                DeserializationValidator deserializationValidator = bundlePackageInfo.getDeserializationValidator();
                if (deserializationValidator == null) {
                    classDeserializationValidator = new ClassDeserializationValidator();
                    classDeserializationValidator.initialize(string, null);
                    bundlePackageInfo.setDeserializationValidator((DeserializationValidator)classDeserializationValidator);
                } else if (deserializationValidator instanceof ClassDeserializationValidator) {
                    classDeserializationValidator = (ClassDeserializationValidator)deserializationValidator;
                } else {
                    _logger.warn((Object)("Unrecognized DeserializationValidator defined for bundle " + string2));
                    continue;
                }
                for (String string3 : hashSet) {
                    String string4 = string3 + ".*";
                    _logger.debug((Object)String.format("Adding pattern %s to allow deserialization for message broker %s.", string4, string));
                    classDeserializationValidator.addAllowClassPattern(string4);
                }
            }
        }
    }

    private Map<String, BundlePackageInfo> getBundleExportedPackages(File file) {
        File file2 = new File(file, PLUGINS_URI);
        if (!file2.exists()) {
            return Collections.emptyMap();
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return Collections.emptyMap();
        }
        HashMap<String, BundlePackageInfo> hashMap = new HashMap<String, BundlePackageInfo>(fileArray.length);
        for (File file3 : fileArray) {
            Manifest manifest = this.getManifest(file3);
            if (manifest == null) continue;
            BundlePackageInfo bundlePackageInfo = new BundlePackageInfo(manifest);
            hashMap.put(bundlePackageInfo.getBundleSymbolicName(), bundlePackageInfo);
        }
        return hashMap;
    }

    private void processWebBundles() {
        if (this._bundleContext == null) {
            _logger.error((Object)"BundleContext is null in ClassDeserializationExtensionListener!");
            return;
        }
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = this._bundleContext.getAllServiceReferences(ServletContext.class.getName(), null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to get web application bundles.", (Throwable)exception);
            return;
        }
        if (serviceReferenceArray == null) {
            _logger.error((Object)"Failed to find any web application bundles.");
            return;
        }
        for (ServiceReference serviceReference : serviceReferenceArray) {
            String string;
            String[] stringArray;
            block9: {
                stringArray = null;
                String string2 = null;
                string = null;
                try {
                    string = serviceReference.getBundle().getSymbolicName();
                    if (string == null || string.startsWith("com.vmware.vsphere.client.") || this._webBundlesToMessageBrokerIdMap.containsKey(string)) continue;
                    ServletContext servletContext = (ServletContext)this._bundleContext.getService(serviceReference);
                    string2 = servletContext.getContextPath();
                    ConfigurableWebApplicationContext configurableWebApplicationContext = (ConfigurableWebApplicationContext)servletContext.getAttribute(FRAMEWORK_APP_CONTEXT);
                    if (configurableWebApplicationContext == null || string == null) {
                        _logger.debug((Object)String.format("Spring BlazeDS integration not supported for bundle '%s' with web context '%s'.", string, string2));
                        continue;
                    }
                    stringArray = configurableWebApplicationContext.getBeanNamesForType(MessageBroker.class);
                    if (stringArray == null) continue;
                    if (stringArray.length == 0) {
                    }
                    break block9;
                }
                catch (Exception exception) {
                    _logger.error((Object)String.format("Failed to process bundle %s for '%s' web application.", string, string2), (Throwable)exception);
                }
                continue;
            }
            this._webBundlesToMessageBrokerIdMap.put(string, stringArray[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(File file) {
        Manifest manifest;
        block9: {
            manifest = null;
            try {
                if (file.isDirectory()) {
                    File file2 = new File(file, MANIFEST_URI);
                    if (!file2.exists()) break block9;
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    try {
                        manifest = new Manifest();
                        manifest.read(fileInputStream);
                        break block9;
                    }
                    finally {
                        StreamUtil.close((Closeable)fileInputStream);
                    }
                }
                String string = file.getName();
                if (!string.endsWith(".jar") && !string.endsWith(".war")) break block9;
                JarFile jarFile = new JarFile(file);
                try {
                    manifest = jarFile.getManifest();
                }
                finally {
                    StreamUtil.close((ZipFile)jarFile);
                }
            }
            catch (IOException iOException) {
                _logger.error((Object)("Error loading bundle manifest for " + file.getName()), (Throwable)iOException);
                manifest = null;
            }
        }
        return manifest;
    }
}

