/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr;

import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRAccessDeniedException;
import com.vmware.vim.zeppelin.cr.exception.CRException;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystem;
import com.vmware.vim.zeppelin.cr.node.CRFileNode;
import com.vmware.vim.zeppelin.cr.node.CRFolderNode;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import com.vmware.vim.zeppelin.cr.node.CRRootNode;
import com.vmware.vim.zeppelin.cr.search.CRSearchQuery;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangeset;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.util.List;

public class CRSession {
    private String _id;
    private CRUser _user;
    private CRFileSystem _fs;
    private CRChangeset _cs;

    public CRSession(String id, CRFileSystem fsImpl, CRUser user) {
        this._id = id;
        this._fs = fsImpl;
        this._user = user;
        this._fs.setUser(user);
    }

    public CRUser getSessionUser() {
        return this._user;
    }

    public void logout() {
        try {
            this._fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CRRootNode getRootNode() throws CRAccessDeniedException {
        return (CRRootNode)this._fs.getFolderNode(CRNode.NODE_ROOT);
    }

    public CRNode getFolderNode(String path) throws CRAccessDeniedException {
        return this._fs.getFolderNode(path);
    }

    public boolean exists(String nodePath) {
        return this._fs.exists(nodePath);
    }

    public boolean hasChildren(String nodePath) {
        return this._fs.hasChildren(nodePath);
    }

    public boolean isFolder(String nodePath) {
        return this._fs.isFolder(nodePath);
    }

    public boolean isFile(String nodePath) {
        return this._fs.isFile(nodePath);
    }

    public List<CRFolderNode> listFolders(String folderPath, boolean includeSubtree) {
        return this._fs.listFolders(folderPath, includeSubtree);
    }

    public List<CRFileNode> listFiles(String filePath, boolean includeSubtree) {
        return this._fs.listFiles(filePath, includeSubtree);
    }

    public List<CRFileNode> listFiles(String filePath, boolean includeSubtree, CRSearchQuery query) {
        return this._fs.listFiles(filePath, includeSubtree, query);
    }

    public CRFileRevision getLatestRevision(String filePath) throws CRAccessDeniedException {
        return this._fs.getLatestFileRevision(filePath);
    }

    public CRFileRevision getRevision(String filePath, int revisionNum) throws CRAccessDeniedException {
        return this._fs.getFileRevision(filePath, revisionNum);
    }

    public CRFileNode getFileNode(String filePath) throws CRAccessDeniedException {
        return this._fs.getFileNode(filePath);
    }

    public synchronized CRChangeset beginTransaction(String desc) {
        if (this._cs != null) {
            this.discardTransaction();
        }
        this._cs = new CRChangeset(desc);
        return this._cs;
    }

    public synchronized void endTransaction() throws CRException {
        if (this._cs != null) {
            this._fs.commitChangeset(this._cs);
        }
        this._cs = null;
    }

    public synchronized void discardTransaction() {
        if (this._cs != null) {
            this._cs.clearActions();
        }
        this._cs = null;
    }
}

