/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import java.util.Set;

public abstract class DefaultCRAuthManagerImpl
implements CRAuthManager {
    @Override
    public abstract CRUser getCurrentUser();

    public abstract boolean isAdmin(CRUser var1);

    public abstract boolean belongsToGroup(CRUser var1, String var2);

    @Override
    public boolean isAllowed(CRUser user, Set<CRAccessControl> acls, int permissionSeeked) {
        boolean allowed = false;
        if (this.isAdmin(user)) {
            allowed = true;
        } else if (acls != null) {
            for (CRAccessControl acl : acls) {
                String aclusername = acl.getUser().getName();
                int aclperm = acl.getPermission();
                if (aclusername != null) {
                    if (acl.getUser().isGroup()) {
                        if ((aclusername.equalsIgnoreCase("ALL") || this.belongsToGroup(user, aclusername)) && aclperm >= permissionSeeked) {
                            allowed = true;
                        }
                    } else if (aclusername.equalsIgnoreCase(user.getName()) && aclperm >= permissionSeeked) {
                        allowed = true;
                    }
                }
                if (!allowed) continue;
                break;
            }
        }
        return allowed;
    }
}

