/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.impl;

import com.vmware.vim.zeppelin.cr.CRSession;
import com.vmware.vim.zeppelin.cr.ContentRepoService;
import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystem;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystemFactory;
import java.util.Map;
import java.util.UUID;

public class DefaultCRServiceImpl
implements ContentRepoService {
    private CRFileSystemFactory _fsFactory;
    private CRAuthManager _authManager;
    Map<String, Object> _config;
    private static final String SESSION_ID_PREFIX = "CRSession_";

    @Override
    public void setConfiguration(Map<String, Object> configParams) {
        this._config = configParams;
    }

    @Override
    public CRAuthManager getAuthManager() {
        return this._authManager;
    }

    @Override
    public CRSession newSession() {
        CRUser user = this._authManager.getCurrentUser();
        return this.newSession(user);
    }

    @Override
    public CRSession newSession(CRUser user) {
        String uniqueSessionId = SESSION_ID_PREFIX + UUID.randomUUID().toString();
        CRFileSystem fs = this._fsFactory.newFileSystemHandle();
        CRSession session = new CRSession(uniqueSessionId, fs, user);
        return session;
    }

    @Override
    public void setAuthManager(CRAuthManager authManager) {
        this._authManager = authManager;
    }

    @Override
    public void setFileSystemFactory(CRFileSystemFactory fs) {
        this._fsFactory = fs;
    }

    @Override
    public void init() {
        this._fsFactory.init(this._config, this._authManager);
    }

    @Override
    public void close() {
        this._fsFactory.close();
    }
}

