/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.versionctrl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.command.CRAddACLsCommand;
import com.vmware.vim.zeppelin.cr.command.CRAddFileCommand;
import com.vmware.vim.zeppelin.cr.command.CRAddNodeCommand;
import com.vmware.vim.zeppelin.cr.command.CRDeleteFileCommand;
import com.vmware.vim.zeppelin.cr.command.CRDeleteNodeCommand;
import com.vmware.vim.zeppelin.cr.command.CRRemoveACLsCommand;
import com.vmware.vim.zeppelin.cr.command.CRRollbackToRevision;
import com.vmware.vim.zeppelin.cr.command.CRUpdateFileCommand;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangesetCommand;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CRChangeset {
    private Long _id;
    private String _description;
    private List<CRFileRevision> _revisions = new ArrayList<CRFileRevision>();
    private List<CRChangesetCommand> _actionList = new ArrayList<CRChangesetCommand>();

    public CRChangeset(String desc) {
        this._description = desc;
    }

    private Long getId() {
        return this._id;
    }

    private void setId(Long id) {
        this._id = id;
    }

    public List<CRFileRevision> getRevisions() {
        return this._revisions;
    }

    public void addActionCommand(CRChangesetCommand action) {
        this._actionList.add(action);
    }

    public void addFolder(String folderPath, List<CRAccessControl> acls) {
        CRAddNodeCommand action = new CRAddNodeCommand(folderPath, acls);
        this.addActionCommand(action);
    }

    public void addFile(String filePath, List<CRAccessControl> acls, CRFileData data) {
        CRAddFileCommand action = new CRAddFileCommand(filePath, acls, data, null);
        this.addActionCommand(action);
    }

    public void addFile(String filePath, List<CRAccessControl> acls, CRFileData data, Map<String, String> metaData) {
        CRAddFileCommand action = new CRAddFileCommand(filePath, acls, data, metaData);
        this.addActionCommand(action);
    }

    public void updateFile(String filePath, CRFileData data, boolean revisionTracking) {
        CRUpdateFileCommand action = new CRUpdateFileCommand(filePath, data, null, revisionTracking);
        this.addActionCommand(action);
    }

    public void updateFile(String filePath, CRFileData data, Map<String, String> metaData, boolean revisionTracking) {
        CRUpdateFileCommand action = new CRUpdateFileCommand(filePath, data, metaData, revisionTracking);
        this.addActionCommand(action);
    }

    public void deleteFolder(String folderPath) {
        CRDeleteNodeCommand action = new CRDeleteNodeCommand(folderPath);
        this.addActionCommand(action);
    }

    public void deleteFile(String filePath) {
        CRDeleteFileCommand action = new CRDeleteFileCommand(filePath);
        this.addActionCommand(action);
    }

    public void rollbackToRevision(String filePath, int revisionNum) {
        CRRollbackToRevision action = new CRRollbackToRevision(filePath, revisionNum);
        this.addActionCommand(action);
    }

    public void addACLs(String nodePath, List<CRAccessControl> acls) {
        CRAddACLsCommand action = new CRAddACLsCommand(nodePath, acls);
        this.addActionCommand(action);
    }

    public void removeACL(String nodePath, CRAccessControl acl) {
        CRRemoveACLsCommand action = new CRRemoveACLsCommand(nodePath, acl);
        this.addActionCommand(action);
    }

    public List<CRChangesetCommand> listActions() {
        return Collections.unmodifiableList(this._actionList);
    }

    public void clearActions() {
        this._actionList.clear();
    }
}

