/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.client.impl;

import com.google.common.base.Preconditions;
import com.vmware.cis.authorization.client.AuthorizationServiceClient;
import com.vmware.cis.authorization.client.ClientCacheListener;
import com.vmware.cis.authorization.client.DocHierarchyPlugin;
import com.vmware.cis.authorization.client.exception.AuthorizationClientException;
import com.vmware.cis.authorization.impl.AclPrivilegeValidator;
import com.vmware.vim.binding.dataservice.accesscontrol.AccessControl;
import com.vmware.vim.binding.dataservice.accesscontrol.AclMapping;
import com.vmware.vim.binding.dataservice.accesscontrol.AuthorizationService;
import com.vmware.vim.binding.dataservice.accesscontrol.Principal;
import com.vmware.vim.binding.dataservice.accesscontrol.Privilege;
import com.vmware.vim.binding.dataservice.accesscontrol.Role;
import com.vmware.vim.binding.dataservice.accesscontrol.internal.AuthorizationServiceInternal;
import com.vmware.vim.binding.dataservice.fault.NotFoundFault;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.AclMappingImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.AuthorizationService_Impl;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.core.util.AclConstants;
import com.vmware.vim.query.core.util.CollectionsUtil;
import com.vmware.vim.query.core.util.Helper;
import com.vmware.vim.query.core.util.ImmutableUtils;
import com.vmware.vim.query.core.util.SetOnceBoolean;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationServiceClientimpl
implements AuthorizationServiceClient {
    private static final Log _log = LogFactory.getLog(AuthorizationServiceClientimpl.class);
    private final AuthorizationService _authz;
    private final AuthorizationServiceInternal _authzInternal;
    private final SetOnceBoolean _initialized = new SetOnceBoolean();
    private final SetOnceBoolean _shutdown = new SetOnceBoolean();
    private final boolean _enableCaching;
    private final Client _client;
    private volatile AclPrivilegeValidator _aclPrivilegeValidator;
    private final Lock _permissionsCacheLock = new ReentrantLock();
    private final Lock _rolesCacheLock = new ReentrantLock();
    private final Lock _privilegesCacheLock = new ReentrantLock();
    private final Set<String> _products;
    private final Set<String> _providers;
    private String _localOSDomainName = "LOCALOS\\";
    private ClientCacheListener _clientCacheListener = null;

    public AuthorizationServiceClientimpl(Client client, boolean enableCaching) {
        this(client, enableCaching, Collections.emptySet(), Collections.emptySet());
    }

    public AuthorizationServiceClientimpl(Client client, boolean enableCaching, Set<String> products, Set<String> providers) {
        Preconditions.checkNotNull(products);
        Preconditions.checkNotNull(providers);
        CollectionsUtil.checkForContentsNotNull(products);
        CollectionsUtil.checkForContentsNotNull(providers);
        this._authz = client.getAuthorizationService();
        this._authzInternal = client.getAuthorizationServiceInternal();
        if (enableCaching) {
            _log.warn((Object)"EnableCaching flag was set to true. Resetting it to false. Client cache disabled.");
        }
        this._enableCaching = false;
        this._client = client;
        this._products = products.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(products));
        this._providers = providers.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(providers));
    }

    @Override
    public void addAccessControlList(final URI docUri, final Collection<AccessControl> permissions) throws NotFoundFault, AuthorizationClientException {
        this.updateOperation(new UpdateOperation<Boolean>("addAccessControlList"){

            @Override
            public void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri and permissions should not be null.", docUri, permissions);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
                AuthorizationServiceClientimpl.preConditionNullCheck("Permissions collection should not contain null values. It could be empty.", permissions);
            }

            @Override
            public Boolean callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.addAccessControlList(docUri, permissions.toArray(new AccessControl[0]), (Future)future);
                future.get();
                return true;
            }

            @Override
            public void updateCache(Boolean update) {
            }
        }, this._permissionsCacheLock);
    }

    @Override
    public void addGlobalAccessControlList(final Collection<AccessControl> permissions) throws AuthorizationClientException {
        try {
            this.updateOperation(new UpdateOperation<Boolean>("addGlobalAccessControlList"){

                @Override
                public void preConditionChecks() {
                    AuthorizationServiceClientimpl.preConditionNullCheck("Permissions collection cannot be null and can not contain null values. It could be empty.", permissions);
                }

                @Override
                public Boolean callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.addGlobalAccessControlList(permissions.toArray(new AccessControl[0]), (Future)future);
                    future.get();
                    return true;
                }

                @Override
                public void updateCache(Boolean update) {
                }
            }, this._permissionsCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Privilege addOrUpdatePrivilege(final String privilegeId, final String description, final String group, final boolean isOnParent) throws AuthorizationClientException {
        try {
            return this.updateOperation(new UpdateOperation<Privilege>("addOrUpdatePrivilege"){

                @Override
                public void preConditionChecks() {
                    AuthorizationServiceClientimpl.preConditionNullCheck("Null description is not allowed", description);
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("PrivilegeId and group can not be null/empty.", privilegeId, group);
                }

                @Override
                public Privilege callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.addOrUpdatePrivilege(privilegeId, description, group, isOnParent, (Future)future);
                    return (Privilege)future.get();
                }

                @Override
                public void updateCache(Privilege update) {
                }
            }, this._privilegesCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Role updateRole(final Role role) throws NotFoundFault, AuthorizationClientException {
        return this.updateOperation(new UpdateOperation<Role>("updateRole"){

            @Override
            public void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("Role cannot be null", role);
            }

            @Override
            public Role callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.updateRole(role, (Future)future);
                return (Role)future.get();
            }

            @Override
            public void updateCache(Role update) {
            }
        }, this._rolesCacheLock);
    }

    @Override
    public Role addRole(final String name, final String description, final Collection<String> privilegeIds) throws AuthorizationClientException {
        try {
            return this.updateOperation(new UpdateOperation<Role>("addRole"){

                @Override
                public void preConditionChecks() {
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Role name cannot be null or empty", name);
                    AuthorizationServiceClientimpl.preConditionNullCheck("Null description not allowed", description);
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("PrivilegeIds collection cannot be null or contain null values. It can be empty.", privilegeIds);
                }

                @Override
                public Role callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.addRole(name, description, privilegeIds.toArray(new String[0]), (Future)future);
                    return (Role)future.get();
                }

                @Override
                public void updateCache(Role update) {
                }
            }, this._rolesCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Role mergeRoles(final long to, final long from) throws AuthorizationClientException, NotFoundFault {
        return this.updateOperation(new UpdateOperation<Role>("mergeRoles"){

            @Override
            public void preConditionChecks() throws NotFoundFault {
            }

            @Override
            public Role callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.mergeRoles(to, from, (Future)future);
                return (Role)future.get();
            }

            @Override
            public void updateCache(Role update) {
            }
        }, this._rolesCacheLock);
    }

    @Override
    public boolean deletePrivilege(final String privilegeId) throws AuthorizationClientException {
        try {
            return this.updateOperation(new UpdateOperation<Boolean>("deletePrivilege"){

                @Override
                public void preConditionChecks() {
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("PrivilegeId cannot be null", privilegeId);
                }

                @Override
                public Boolean callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.deletePrivilege(privilegeId, (Future)future);
                    return (Boolean)future.get();
                }

                @Override
                public void updateCache(Boolean update) {
                }
            }, this._privilegesCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean deleteRole(final long roleId, final boolean forceDelete) throws AuthorizationClientException {
        try {
            return this.updateOperation(new UpdateOperation<Boolean>("deleteRole"){

                @Override
                public void preConditionChecks() {
                }

                @Override
                public Boolean callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.deleteRoleWithForceOption(roleId, forceDelete, (Future)future);
                    return (Boolean)future.get();
                }

                @Override
                public void updateCache(Boolean update) {
                }
            }, this._rolesCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean deleteRoleWithForceOption(final long roleId, final boolean forceDelete) throws AuthorizationClientException {
        try {
            return this.updateOperation(new UpdateOperation<Boolean>("deleteRole"){

                @Override
                public void preConditionChecks() {
                }

                @Override
                public Boolean callApi() throws InterruptedException, ExecutionException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.deleteRoleWithForceOption(roleId, forceDelete, (Future)future);
                    return (Boolean)future.get();
                }

                @Override
                public void updateCache(Boolean update) {
                }
            }, this._rolesCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Collection<AclMapping> getAllPermissions() throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Collection<AclMapping>>("getAllPermissions"){

            @Override
            public Collection<AclMapping> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getAllPermissions((Future)future);
                AclMapping[] a = (AclMapping[])future.get();
                if (a == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(a);
            }

            @Override
            Collection<AclMapping> getResultFromCache() {
                Set<Map.Entry<URI, Collection<AccessControl>>> entrySet = AuthorizationServiceClientimpl.this._aclPrivilegeValidator.getAllPermissions().entrySet();
                return ImmutableUtils.tranformCollection(entrySet, (ImmutableUtils.TransformFunc)new ImmutableUtils.TransformFunc<Map.Entry<URI, Collection<AccessControl>>, AclMapping>(){

                    public AclMapping apply(Map.Entry<URI, Collection<AccessControl>> from) {
                        AclMappingImpl result = new AclMappingImpl();
                        result.setDocument(from.getKey());
                        result.setAccessControlList(from.getValue().toArray(new AccessControl[0]));
                        return result;
                    }
                });
            }
        });
    }

    @Override
    public Collection<AccessControl> getGlobalAccessControlList() throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Collection<AccessControl>>("getGlobalAccessControlList"){

            @Override
            public Collection<AccessControl> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getGlobalAccessControlList((Future)future);
                AccessControl[] a = (AccessControl[])future.get();
                if (a == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(a);
            }

            @Override
            Collection<AccessControl> getResultFromCache() {
                throw new RuntimeException("Not implemented.");
            }
        });
    }

    @Override
    public Collection<AclMapping> getPermissions(final URI docUri) throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Collection<AclMapping>>("getPermissions"){

            @Override
            public Collection<AclMapping> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getPermissions(docUri, (Future)future);
                AclMapping[] a = (AclMapping[])future.get();
                if (a == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(a);
            }

            @Override
            Collection<AclMapping> getResultFromCache() throws AuthorizationClientException {
                LinkedHashMap<URI, Collection<AccessControl>> permission = AuthorizationServiceClientimpl.this._aclPrivilegeValidator.getPermissions(docUri.toString());
                ArrayList<AclMapping> result = new ArrayList<AclMapping>();
                for (Map.Entry<URI, Collection<AccessControl>> entry : permission.entrySet()) {
                    AclMappingImpl aclMapping = new AclMappingImpl();
                    aclMapping.setDocument(entry.getKey());
                    aclMapping.setAccessControlList(entry.getValue().toArray(new AccessControl[0]));
                    result.add((AclMapping)aclMapping);
                }
                return result;
            }

            @Override
            void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", docUri);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
            }
        });
    }

    @Override
    public Collection<Privilege> getPrivileges() throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Collection<Privilege>>("getPrivileges"){

            @Override
            public Collection<Privilege> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getPrivileges((Future)future);
                Privilege[] a = (Privilege[])future.get();
                if (a == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(a);
            }

            @Override
            Collection<Privilege> getResultFromCache() {
                return AuthorizationServiceClientimpl.this._aclPrivilegeValidator.getPrivileges();
            }
        });
    }

    @Override
    public Collection<Role> getRoles() throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Collection<Role>>("getRoles"){

            @Override
            public Collection<Role> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getRoles((Future)future);
                Role[] a = (Role[])future.get();
                if (a == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(a);
            }

            @Override
            Collection<Role> getResultFromCache() {
                return AuthorizationServiceClientimpl.this._aclPrivilegeValidator.getRoles();
            }
        });
    }

    @Override
    public Boolean hasPrivileges(final URI docUri, final String userName, final Set<String> groups, final Set<String> privileges) throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Boolean>("hasPrivileges"){

            @Override
            public Boolean callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.hasPrivileges(docUri, userName, groups.toArray(new String[0]), privileges.toArray(new String[0]), (Future)future);
                return (Boolean)future.get();
            }

            @Override
            Boolean getResultFromCache() {
                block6: {
                    if (AuthorizationServiceClientimpl.this._aclPrivilegeValidator.isAllowed(docUri.toString(), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(userName), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(groups), privileges)) {
                        return true;
                    }
                    HashSet privilegesCopy = new HashSet(privileges);
                    privilegesCopy.remove("System.Anonymous");
                    if (privilegesCopy.size() == 1 && privilegesCopy.contains("System.View")) {
                        BlockingFuture future = new BlockingFuture();
                        try {
                            AuthorizationServiceClientimpl.this._authz.hasSysViewPrivileges(docUri, userName, groups.toArray(new String[0]), (Future)future);
                            return (Boolean)future.get();
                        }
                        catch (InterruptedException ie) {
                            if (_log.isWarnEnabled()) {
                                _log.warn((Object)"Checking SystemViewPrivilege cache failed.", (Throwable)ie);
                            }
                        }
                        catch (ExecutionException ee) {
                            if (!_log.isWarnEnabled()) break block6;
                            _log.warn((Object)"Checking SystemViewPrivilege cache failed.", (Throwable)ee);
                        }
                    }
                }
                return false;
            }

            @Override
            void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", docUri);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Username cannot be null.", userName);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Groups cannot be null or contain null values. Group can be empty", groups);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Privileges cannot be null or contain null values.", privileges);
                Preconditions.checkArgument((!privileges.isEmpty() ? 1 : 0) != 0, (Object)"Privileges cannot be empty");
            }
        });
    }

    @Override
    public AuthorizationService.PrivilegeCheckResult[] hasPrivilegesBatch(final AuthorizationService.PrivilegeCheckRequest[] requests, final String userName, final Set<String> groups) throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<AuthorizationService.PrivilegeCheckResult[]>("hasPrivilegesBatch"){

            @Override
            public AuthorizationService.PrivilegeCheckResult[] callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.hasPrivilegesBatch(requests, userName, groups.toArray(new String[groups.size()]), (Future)future);
                return (AuthorizationService.PrivilegeCheckResult[])future.get();
            }

            @Override
            AuthorizationService.PrivilegeCheckResult[] getResultFromCache() {
                ArrayList<AuthorizationService_Impl.PrivilegeCheckResultImpl> results = new ArrayList<AuthorizationService_Impl.PrivilegeCheckResultImpl>();
                for (int i = 0; i < requests.length; ++i) {
                    URI docUri = requests[i].getDocUri();
                    boolean allowed = AuthorizationServiceClientimpl.this._aclPrivilegeValidator.isAllowed(docUri.toString(), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(userName), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(groups), Arrays.asList(requests[i].getPrivileges()));
                    AuthorizationService_Impl.PrivilegeCheckResultImpl r = new AuthorizationService_Impl.PrivilegeCheckResultImpl();
                    r.setDocResult(allowed);
                    r.setDocUri(requests[i].getDocUri());
                    results.add(r);
                }
                return results.toArray(new AuthorizationService.PrivilegeCheckResult[results.size()]);
            }

            @Override
            void preConditionChecks() {
                HashSet<String> docUris = new HashSet<String>();
                for (int i = 0; i < requests.length; ++i) {
                    AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", requests[i].getDocUri());
                    String docUri = requests[i].getDocUri().toString();
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty", docUri);
                    if (!docUris.add(docUri)) {
                        throw new IllegalArgumentException("Duplicated  DocUris " + docUri + " exist.");
                    }
                    AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Privileges cannot be null or contain null values.", requests[i].getPrivileges());
                    Preconditions.checkArgument((requests[i].getPrivileges().length != 0 ? 1 : 0) != 0, (Object)"Privileges cannot be empty");
                }
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Username cannot be null.", userName);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Groups cannot be null or contain null values. Group can be empty", groups.toArray(new String[groups.size()]));
            }
        });
    }

    @Override
    public Boolean hasGlobalPrivileges(String userName, Set<String> groups, Set<String> privileges) throws AuthorizationClientException {
        return this.hasPrivileges(AclConstants.GLOBAL_PERMISSIONS, userName, groups, privileges);
    }

    @Override
    public Set<String> getUserPrivileges(final URI docUri, final String userName, final Set<String> groups) throws AuthorizationClientException {
        return this.readOperation(new ReadOperation<Set<String>>("getUserPrivileges"){

            @Override
            public Set<String> callApi() throws InterruptedException, ExecutionException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.getUserPrivileges(docUri, userName, groups.toArray(new String[0]), (Future)future);
                Object[] result = (String[])future.get();
                return result == null ? Collections.emptySet() : Helper.getSet((Object[])result);
            }

            @Override
            Set<String> getResultFromCache() {
                return AuthorizationServiceClientimpl.this._aclPrivilegeValidator.getUserPrivileges(docUri.toString(), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(userName), AuthorizationServiceClientimpl.this.trimLocalOSDomainName(groups));
            }

            @Override
            void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", docUri);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Username cannot be null.", userName);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("Groups cannot be null or contain null values. Group can be empty", groups);
            }
        });
    }

    @Override
    public Set<String> getUserGlobalPrivileges(String userName, Set<String> groups) throws AuthorizationClientException {
        return this.getUserPrivileges(AclConstants.GLOBAL_PERMISSIONS, userName, groups);
    }

    @Override
    public void removeAccess(final URI docUri, final Collection<Principal> principals) throws NotFoundFault, AuthorizationClientException {
        this.updateOperation(new UpdateOperation<Boolean>("removeAccess"){

            @Override
            Boolean callApi() throws ExecutionException, InterruptedException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.removeAccess(docUri, principals.toArray(new Principal[0]), (Future)future);
                future.get();
                return true;
            }

            @Override
            void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", docUri);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
                AuthorizationServiceClientimpl.preConditionNullCheck("Principals cannot be null or contain null values", principals);
                Preconditions.checkArgument((!principals.isEmpty() ? 1 : 0) != 0, (Object)"Empty principals not allowed.");
            }

            @Override
            void updateCache(Boolean update) {
            }
        }, this._permissionsCacheLock);
    }

    @Override
    public void removeGlobalAccess(final Collection<Principal> principals) throws AuthorizationClientException {
        try {
            this.updateOperation(new UpdateOperation<Boolean>("removeGlobalAccess"){

                @Override
                Boolean callApi() throws ExecutionException, InterruptedException {
                    BlockingFuture future = new BlockingFuture();
                    AuthorizationServiceClientimpl.this._authz.removeGlobalAccess(principals.toArray(new Principal[0]), (Future)future);
                    future.get();
                    return true;
                }

                @Override
                void preConditionChecks() {
                    AuthorizationServiceClientimpl.preConditionNullCheck("Principals cannot be null or contain null values", principals);
                    Preconditions.checkArgument((!principals.isEmpty() ? 1 : 0) != 0, (Object)"Empty principals not allowed.");
                }

                @Override
                void updateCache(Boolean update) {
                }
            }, this._permissionsCacheLock);
        }
        catch (NotFoundFault e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void resetAccess(final URI docUri, final Collection<AccessControl> permissions) throws NotFoundFault, AuthorizationClientException {
        this.updateOperation(new UpdateOperation<Boolean>("resetAccess"){

            @Override
            Boolean callApi() throws ExecutionException, InterruptedException {
                BlockingFuture future = new BlockingFuture();
                AuthorizationServiceClientimpl.this._authz.resetAccess(docUri, permissions.toArray(new AccessControl[0]), (Future)future);
                future.get();
                return true;
            }

            @Override
            void preConditionChecks() {
                AuthorizationServiceClientimpl.preConditionNullCheck("DocUri cannot be null.", docUri);
                AuthorizationServiceClientimpl.preConditionNullOrEmptyString("DocUri should not be empty.", docUri.toString());
                AuthorizationServiceClientimpl.preConditionNullCheck("Permissions cannot be null or contain null values. Permssions can be empty.", permissions);
            }

            @Override
            void updateCache(Boolean update) {
            }
        }, this._permissionsCacheLock);
    }

    @Override
    public void init() throws AuthorizationClientException {
        this._initialized.flip();
    }

    static void preConditionNullOrEmptyString(String message, String ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        AuthorizationServiceClientimpl.preConditionNullOrEmptyString(message, Arrays.asList(objects));
    }

    static void preConditionNullOrEmptyString(String message, Collection<String> col) {
        if (col == null) {
            throw new IllegalArgumentException("Null string value not allowed. " + message);
        }
        for (String str : col) {
            if (str == null) {
                throw new IllegalArgumentException("Null string  value not allowed. " + message);
            }
            if (!(str = str.trim()).isEmpty()) continue;
            throw new IllegalArgumentException("Empty string value not allowed. " + message);
        }
    }

    static void preConditionNullCheck(String message, Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        AuthorizationServiceClientimpl.preConditionNullCheck(message, Arrays.asList(objects));
    }

    static void preConditionNullCheck(String message, Collection<?> col) {
        if (col == null) {
            throw new IllegalArgumentException("Null value not allowed. " + message);
        }
        for (Object o : col) {
            if (o != null) continue;
            throw new IllegalArgumentException("Null value not allowed. " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T updateOperation(UpdateOperation<T> func, Lock lock) throws AuthorizationClientException, NotFoundFault {
        this.isInValidState();
        func.preConditionChecks();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Operation: " + ((UpdateOperation)func)._operationName + ". Invoking server API. "));
        }
        lock.lock();
        try {
            T result;
            try {
                result = func.callApi();
            }
            catch (InterruptedException e) {
                String msg = "Operation: " + ((UpdateOperation)func)._operationName + ". Update API call interrupted.";
                _log.warn((Object)msg, (Throwable)e);
                throw new AuthorizationClientException(msg, e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    throw new AuthorizationClientException("Unable to invole API. Not able to determine cause.. ", e);
                }
                if (cause instanceof ManagedObjectNotFound) {
                    throw (ManagedObjectNotFound)cause;
                }
                if (cause instanceof NotFoundFault) {
                    throw (NotFoundFault)cause;
                }
                if (cause instanceof SecurityError) {
                    throw (SecurityError)cause;
                }
                String msg = "Operation: " + ((UpdateOperation)func)._operationName + ". Update API execution failed.";
                _log.warn((Object)msg, (Throwable)e);
                throw new AuthorizationClientException(msg, cause);
            }
            if (this._enableCaching) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Operation: " + ((UpdateOperation)func)._operationName + ". Updating local cache with the result " + result));
                }
                func.updateCache(result);
            }
            T t = result;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private String trimLocalOSDomainName(String username) {
        if (username.regionMatches(true, 0, this._localOSDomainName, 0, this._localOSDomainName.length())) {
            return username.substring(this._localOSDomainName.length());
        }
        return username;
    }

    private Set<String> trimLocalOSDomainName(Set<String> groups) {
        HashSet<String> result = new HashSet<String>();
        for (String name : groups) {
            result.add(this.trimLocalOSDomainName(name));
        }
        return result;
    }

    private void isInValidState() throws AuthorizationClientException {
        if (!this._enableCaching) {
            return;
        }
        if (!this._initialized.get()) {
            throw new IllegalStateException("Caching is enabled must be initialized.");
        }
        if (this._shutdown.get()) {
            throw new IllegalStateException("Shutdown");
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private <T> T readOperation(ReadOperation<T> func) throws AuthorizationClientException {
        this.isInValidState();
        func.preConditionChecks();
        if (this._enableCaching) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Operation: " + ((ReadOperation)func)._operationName + ". Reading result from cache. "));
            }
            return func.getResultFromCache();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Operation: " + ((ReadOperation)func)._operationName + ". Invoking server API. "));
        }
        try {
            return func.callApi();
        }
        catch (InterruptedException e) {
            String msg = "Operation: " + ((ReadOperation)func)._operationName + ". Read API call interrupted.";
            _log.warn((Object)msg, (Throwable)e);
            throw new AuthorizationClientException(msg, e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new AuthorizationClientException("Unable to invole API. Not able to determine cause.. ", e);
            }
            if (cause instanceof ManagedObjectNotFound) {
                throw (ManagedObjectNotFound)cause;
            }
            if (cause instanceof SecurityError) {
                throw (SecurityError)cause;
            }
            String msg = "Operation: " + ((ReadOperation)func)._operationName + ". Read API execution failed.";
            _log.warn((Object)msg, (Throwable)e);
            throw new AuthorizationClientException(msg, cause);
        }
    }

    @Override
    public synchronized void shutDown() {
        this._shutdown.flip();
    }

    @Override
    public void setLocalOSDomainName(String localOSDomainName) {
        AuthorizationServiceClientimpl.preConditionNullOrEmptyString("localOSDomainName cannot be null.", localOSDomainName);
        this._localOSDomainName = localOSDomainName + "\\";
    }

    @Override
    public void sync(long timeout) throws AuthorizationClientException, TimeoutException, InterruptedException {
    }

    @Override
    public void setDocHierarchyPlugin(DocHierarchyPlugin docHierarchyPlugin) {
        this._aclPrivilegeValidator.setHierarchyPlugin(docHierarchyPlugin);
    }

    @Override
    public void registerClientCacheNotification(ClientCacheListener listener) {
        this._clientCacheListener = listener;
    }

    private abstract class ReadOperation<T> {
        private final String _operationName;

        ReadOperation(String operationName) {
            this._operationName = operationName;
        }

        void preConditionChecks() {
        }

        abstract T callApi() throws ExecutionException, InterruptedException;

        abstract T getResultFromCache() throws AuthorizationClientException;
    }

    private abstract class UpdateOperation<T> {
        private final String _operationName;

        UpdateOperation(String operationName) {
            this._operationName = operationName;
        }

        void preConditionChecks() throws NotFoundFault {
        }

        abstract T callApi() throws ExecutionException, InterruptedException;

        abstract void updateCache(T var1);
    }
}

