/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.authorization.impl;

import com.vmware.cis.core.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class UserPrivilegeData {
    Map<Principal, Integer> _map = new HashMap<Principal, Integer>();

    public synchronized void incUserCount(Principal user) {
        int count = !this._map.containsKey(user) ? 1 : this._map.get(user) + 1;
        this._map.put(user, count);
    }

    public synchronized void incUserCount(Set<Principal> users) {
        if (users == null || users.size() == 0) {
            return;
        }
        for (Principal user : users) {
            this.incUserCount(user);
        }
    }

    public boolean containsUser(Principal user) {
        return this._map.containsKey(user);
    }

    public synchronized void decUserCount(Principal user) {
        if (!this._map.containsKey(user)) {
            return;
        }
        int count = this._map.get(user);
        if (--count <= 0) {
            this._map.remove(user);
        } else {
            this._map.put(user, count);
        }
    }

    public synchronized void decUserCount(Set<Principal> users) {
        if (users == null || users.size() == 0) {
            return;
        }
        CopyOnWriteArrayList<Principal> userList = new CopyOnWriteArrayList<Principal>();
        userList.addAll(users);
        for (Principal user : userList) {
            this.decUserCount(user);
        }
    }

    public Set<Principal> getUsers() {
        return this._map.keySet();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public String toString() {
        String ret = new String();
        for (Map.Entry<Principal, Integer> entry : this._map.entrySet()) {
            ret = ret + "Principal: " + entry.getKey().getName() + ", Count: " + entry.getValue() + "\n";
        }
        return ret;
    }
}

