/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.notif.client.impl;

import com.vmware.cis.notif.client.ChangeListener;
import com.vmware.cis.notif.client.Deserializer;
import com.vmware.cis.notif.client.NotificationException;
import com.vmware.cis.notif.client.NotificationRuntimeException;
import com.vmware.cis.notif.client.Notifications;
import com.vmware.cis.notif.client.Subscription;
import com.vmware.cis.notif.client.SubscriptionSpec;
import com.vmware.cis.notif.client.impl.SubscriptionImpl;
import com.vmware.cis.notif.provider.NotificationProvider;
import com.vmware.cis.notif.provider.NotificationProviderFactory;
import com.vmware.cis.notif.provider.is.IsNotificationProviderFactoryImpl;
import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NotificationsImpl
implements Notifications {
    private ConcurrentMap<String, SubscriptionImpl> subscriptions = new ConcurrentHashMap<String, SubscriptionImpl>();
    private NotificationProviderFactory isNotificationProviderFactory = new IsNotificationProviderFactoryImpl();

    @Override
    public Subscription subscribe(SubscriptionSpec spec, ChangeListener listener, Deserializer deserializer, AuthenticationStrategy authStrategy) throws NotificationException {
        this.validateSubscriptionSpec(spec);
        SubscriptionImpl si = this.createSubscription(spec, listener, deserializer, authStrategy);
        this.subscriptions.put(si.getId(), si);
        si.getNotificationProvider().start();
        return si;
    }

    @Override
    @Deprecated
    public Subscription subscribe(SubscriptionSpec spec, ChangeListener listener, Deserializer deserializer) throws NotificationException {
        DefaultAuthenticationStrategy authStrategy = null;
        if (spec.getSAMLToken() != null) {
            authStrategy = new DefaultAuthenticationStrategy(spec.getSAMLToken(), spec.getPrivateKey());
            authStrategy.setMaxLoginAttempts(10);
        }
        return this.subscribe(spec, listener, deserializer, authStrategy);
    }

    @Deprecated
    private SubscriptionImpl createSubscription(SubscriptionSpec spec, ChangeListener listener, Deserializer deserializer, AuthenticationStrategy authStrategy) throws NotificationException {
        SubscriptionImpl si = new SubscriptionImpl(spec, listener, deserializer, authStrategy);
        NotificationProvider notifProvider = this.isNotificationProviderFactory.create(si);
        si.setNotificationProvider(notifProvider);
        return si;
    }

    @Override
    public Subscription[] getSubscriptions() {
        return this.subscriptions.values().toArray(new Subscription[0]);
    }

    @Override
    public void cancelSubscription(Subscription subscription) throws NotificationException {
        SubscriptionImpl si = (SubscriptionImpl)this.subscriptions.remove(subscription.getId());
        if (si != null) {
            si.cleanup();
        }
    }

    public void cleanup() {
        Iterator iter = this.subscriptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ((SubscriptionImpl)entry.getValue()).cleanup();
            iter.remove();
        }
    }

    private void validateSubscriptionSpec(SubscriptionSpec spec) throws NotificationException {
    }

    private static class DefaultAuthenticationStrategy
    implements AuthenticationStrategy {
        private int maxLoginAttempts;
        private SamlToken samlToken;
        private PrivateKey privateKey;

        public DefaultAuthenticationStrategy(SamlToken samlToken, PrivateKey privateKey) {
            this.samlToken = samlToken;
            this.privateKey = privateKey;
        }

        @Override
        public void login(Client client) {
            try {
                client.getAuthenticationManager().loginBySamlToken(this.samlToken, this.privateKey);
            }
            catch (Exception e) {
                throw new NotificationRuntimeException("Unable to log in", e.getCause());
            }
        }

        @Override
        public int getMaxLoginAttempts() {
            return this.maxLoginAttempts;
        }

        public void setMaxLoginAttempts(int maxLoginAttempts) {
            this.maxLoginAttempts = maxLoginAttempts;
        }
    }
}

