/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.kv.impl;

import com.google.common.base.Preconditions;
import com.vmware.cis.kv.client.ClientCache;
import com.vmware.cis.kv.client.ClientDeleteSpec;
import com.vmware.cis.kv.client.ClientManager;
import com.vmware.cis.kv.client.ClientPutSpec;
import com.vmware.cis.kv.client.ValueMarshaller;
import com.vmware.cis.kv.client.exception.AlreadyExistsException;
import com.vmware.cis.kv.client.exception.KVException;
import com.vmware.cis.kv.client.exception.NotFoundException;
import com.vmware.cis.kv.client.exception.OptimisticLockingException;
import com.vmware.vim.binding.cis.kv.Change;
import com.vmware.vim.binding.cis.kv.ChangeSet;
import com.vmware.vim.binding.cis.kv.CreateFlags;
import com.vmware.vim.binding.cis.kv.Manager;
import com.vmware.vim.binding.cis.kv.MultiDeleteSpec;
import com.vmware.vim.binding.cis.kv.MultiPutSpec;
import com.vmware.vim.binding.cis.kv.fault.AlreadyExistsFault;
import com.vmware.vim.binding.cis.kv.fault.NotFoundFault;
import com.vmware.vim.binding.cis.kv.fault.OptimisticLockingFault;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.query.client.kv.impl.ClientCacheImpl;
import com.vmware.vim.query.client.kv.impl.ConversionHelper;
import com.vmware.vim.query.client.kv.impl.DefaultValueMarshaller;
import com.vmware.vim.query.client.kv.impl.KVClientImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientManagerImpl
implements ClientManager {
    private static final Log _log = LogFactory.getLog(ClientManagerImpl.class);
    private final KVClientImpl _parentClient;
    private Manager _serverManager;
    private ConcurrentHashMap<String, ValueMarshaller> _marshallers = new ConcurrentHashMap();
    private ValueMarshaller _defaultMarshaller = new DefaultValueMarshaller();
    private ConcurrentHashMap<String, ClientCacheImpl> _clientCacheMap = new ConcurrentHashMap();

    public ClientManagerImpl(KVClientImpl parentClient) {
        this._parentClient = parentClient;
    }

    public void setServerManager(Manager serverManager) {
        this._serverManager = serverManager;
    }

    private void validateEntry(String provider, ValueMarshaller vm) {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        Preconditions.checkArgument((vm != null ? 1 : 0) != 0, (Object)"Valuemarshaller is required");
    }

    @Override
    public synchronized void setMarshallers(Map<String, ValueMarshaller> marshallers) {
        Preconditions.checkArgument((marshallers != null && !marshallers.isEmpty() ? 1 : 0) != 0, (Object)"Marshallers are required");
        for (Map.Entry<String, ValueMarshaller> vmEntry : marshallers.entrySet()) {
            this.validateEntry(vmEntry.getKey(), vmEntry.getValue());
        }
        this._marshallers = new ConcurrentHashMap<String, ValueMarshaller>(marshallers);
    }

    @Override
    public synchronized void setMarshaller(String provider, ValueMarshaller vm) {
        this.validateEntry(provider, vm);
        this._marshallers.put(provider, vm);
    }

    @Override
    public Collection<String> getAllProviders() throws KVException {
        String[] providers = null;
        BlockingFuture future = new BlockingFuture();
        this._serverManager.getAllProviders((Future)future);
        try {
            providers = (String[])future.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
        ArrayList<String> providerList = new ArrayList<String>();
        for (int i = 0; providers != null && i < providers.length; ++i) {
            providerList.add(providers[i]);
        }
        return providerList;
    }

    @Override
    public CreateFlags getCreateFlags(String provider) throws KVException {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        BlockingFuture cf = new BlockingFuture();
        this._serverManager.getCreateFlags(provider, (Future)cf);
        try {
            return (CreateFlags)cf.get();
        }
        catch (ExecutionException e) {
            return (CreateFlags)this.handleServerException(e);
        }
        catch (InterruptedException e) {
            throw new KVException(e.getCause());
        }
    }

    @Override
    public synchronized void addProvider(String provider, CreateFlags flags) throws KVException {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        Preconditions.checkArgument((flags != null ? 1 : 0) != 0, (Object)"flags is required");
        BlockingFuture future = new BlockingFuture();
        this._serverManager.addProvider(provider, flags, (Future)future);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
    }

    @Override
    public synchronized void deleteProvider(String provider) throws KVException {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        BlockingFuture future = new BlockingFuture();
        this._serverManager.deleteProvider(provider, (Future)future);
        try {
            future.get();
            ClientCacheImpl cci = this._clientCacheMap.remove(provider);
            if (cci != null) {
                cci.close();
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
    }

    private void validateClientPutSpec(Map<String, ClientPutSpec[]> spec) {
        Preconditions.checkArgument((spec != null && !spec.isEmpty() ? 1 : 0) != 0, (Object)"ClientPutSpec is required");
        for (Map.Entry<String, ClientPutSpec[]> entry : spec.entrySet()) {
            String key = entry.getKey();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key is required");
            ClientPutSpec[] cpsValue = entry.getValue();
            Preconditions.checkArgument((cpsValue != null && cpsValue.length > 0 ? 1 : 0) != 0, (Object)"spec is required");
            for (ClientPutSpec cpsElement : cpsValue) {
                Preconditions.checkArgument((cpsElement.getKey() != null ? 1 : 0) != 0, (Object)"ClientPutSpec.key is required");
                Preconditions.checkArgument((cpsElement.getValue() != null ? 1 : 0) != 0, (Object)"ClientPutSpec.value is required");
            }
        }
    }

    @Override
    public synchronized void batchPut(Map<String, ClientPutSpec[]> spec, boolean autoUpdateCaches) throws KVException {
        this.validateClientPutSpec(spec);
        MultiPutSpec mspec = ConversionHelper.getMultiPutSpec(this._marshallers, this._defaultMarshaller, spec);
        BlockingFuture future = new BlockingFuture();
        this._serverManager.batchPut(mspec, (Future)future);
        try {
            ChangeSet changes = (ChangeSet)future.get();
            if (changes == null || changes.getChanges() == null) {
                return;
            }
            if (autoUpdateCaches) {
                this.updateClientCaches(changes);
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
    }

    private void validateClientDeleteSpec(Map<String, ClientDeleteSpec[]> spec) {
        Preconditions.checkArgument((spec != null && !spec.isEmpty() ? 1 : 0) != 0, (Object)"ClientDeleteSpec is required");
        for (Map.Entry<String, ClientDeleteSpec[]> entry : spec.entrySet()) {
            String key = entry.getKey();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Provider is required");
            ClientDeleteSpec[] cdsValue = entry.getValue();
            Preconditions.checkArgument((cdsValue != null && cdsValue.length > 0 ? 1 : 0) != 0, (Object)"spec is required");
            for (ClientDeleteSpec cdsElement : cdsValue) {
                Preconditions.checkArgument((cdsElement.getKey() != null ? 1 : 0) != 0, (Object)"ClientDeleteSpec.key is required");
            }
        }
    }

    @Override
    public synchronized void batchDelete(Map<String, ClientDeleteSpec[]> spec, boolean autoUpdateCaches) throws KVException {
        this.validateClientDeleteSpec(spec);
        MultiDeleteSpec mspec = ConversionHelper.getMultiDeleteSpec(spec);
        BlockingFuture future = new BlockingFuture();
        this._serverManager.batchDelete(mspec, (Future)future);
        try {
            ChangeSet changes = (ChangeSet)future.get();
            if (autoUpdateCaches) {
                this.updateClientCaches(changes);
            }
        }
        catch (ExecutionException e) {
            this.handleServerException(e);
        }
        catch (InterruptedException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)e);
            }
            throw new KVException(e);
        }
    }

    @Override
    public synchronized ClientCache getClientCache(String provider) throws NotFoundException {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        ClientCacheImpl cc = this._clientCacheMap.get(provider);
        if (cc != null) {
            return cc;
        }
        ClientCacheImpl cci = new ClientCacheImpl(provider);
        cci.setServerManager(this._serverManager);
        cci.setValueMarshaller(ConversionHelper.getValueMarshaller(this._marshallers, this._defaultMarshaller, provider));
        this._clientCacheMap.put(provider, cci);
        return cci;
    }

    @Override
    public synchronized void removeClientCache(String provider) {
        Preconditions.checkArgument((provider != null && !provider.trim().isEmpty() ? 1 : 0) != 0, (Object)"provider is required");
        ClientCacheImpl cc = this._clientCacheMap.remove(provider);
        if (cc != null) {
            cc.close();
        }
    }

    @Override
    public synchronized void close() {
        for (Map.Entry<String, ClientCacheImpl> entries : this._clientCacheMap.entrySet()) {
            entries.getValue().close();
        }
        this._parentClient.reportClientMgrClosed(this);
    }

    private <T> T handleServerException(ExecutionException e) throws AlreadyExistsException, KVException {
        Throwable cause = e.getCause();
        if (cause instanceof NotFoundFault) {
            throw new NotFoundException(cause);
        }
        if (cause instanceof OptimisticLockingFault) {
            throw new OptimisticLockingException(cause);
        }
        if (cause instanceof AlreadyExistsFault) {
            throw new AlreadyExistsException(cause);
        }
        if (cause instanceof SecurityError) {
            throw new SecurityException(cause);
        }
        throw new KVException(cause);
    }

    private void updateClientCaches(ChangeSet changes) {
        HashMap<String, LinkedList<Change>> changesMap = new HashMap<String, LinkedList<Change>>();
        for (Change change : changes.getChanges()) {
            ClientCacheImpl cc = this._clientCacheMap.get(change.getProvider());
            if (cc == null) continue;
            LinkedList<Change> list = (LinkedList<Change>)changesMap.get(change.getProvider());
            if (list == null) {
                list = new LinkedList<Change>();
                changesMap.put(change.getProvider(), list);
            }
            list.add(change);
        }
        for (Map.Entry entry : changesMap.entrySet()) {
            ClientCacheImpl cc = this._clientCacheMap.get(entry.getKey());
            if (cc == null) continue;
            cc.modifyCache((List)entry.getValue());
        }
    }
}

