/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.client.provider.impl;

import com.ctc.wstx.stax.WstxInputFactory;
import com.vmware.vim.query.client.provider.impl.AtomFeedUnmarshaller;
import com.vmware.vim.query.client.provider.impl.FeedFactory;
import com.vmware.vim.query.client.provider.impl.ForwardingIterator;
import com.vmware.vim.query.core.provider.AtomFeedEntry;
import com.vmware.vim.query.core.provider.content.ContentAtomFeed;
import com.vmware.vim.query.core.provider.content.ContentAtomFeedEntry;
import com.vmware.vim.query.core.provider.pull.PullAtomFeed;
import com.vmware.vim.query.core.provider.pull.PullAtomFeedEntry;
import com.vmware.vim.query.core.provider.pull.PullEntryMetadata;
import com.vmware.vim.query.core.provider.pull.PullEntryProperty;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLAtomFeedUnMarshaller
implements AtomFeedUnmarshaller {
    private static final Log _log = LogFactory.getLog(XMLAtomFeedUnMarshaller.class);
    private static final String GENERATION = "generation";
    private static final List<PullEntryProperty> EMPTY_PULL_PROP_LIST = Collections.emptyList();
    private static final List<PullEntryMetadata> EMPTY_PULL_METADATA_LIST = Collections.emptyList();
    private static final String QS_NS = "urn:vmware:queryservice";
    private static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    private static final QName TAGS = new QName("urn:vmware:queryservice", "tags");
    private static final QName LAST_MODIFIED = new QName("urn:vmware:queryservice", "lastmodified");
    private static final QName FEED_ELEMENT = new QName("http://www.w3.org/2005/Atom", "feed");
    private static final QName ID_ELEMENT = new QName("http://www.w3.org/2005/Atom", "id");
    private static final QName UPDATED_ELEMENT = new QName("http://www.w3.org/2005/Atom", "updated");
    private static final QName ENTRY_ELEMENT = new QName("http://www.w3.org/2005/Atom", "entry");
    private static final QName CONTENT_ELEMENT = new QName("http://www.w3.org/2005/Atom", "content");
    private static final QName METADATA_CONTENT_ELEMENT = new QName("urn:vmware:queryservice", "metadatacontent");
    private static final QName LINK_ELEMENT = new QName("http://www.w3.org/2005/Atom", "link");
    private static final QName CHANGE_KIND_ELEMENT = new QName("urn:vmware:queryservice", "changekind");
    private static final QName GENERATION_ELEMENT = new QName("urn:vmware:queryservice", "generation");
    private static final QName PROPERTY_ELEMENT = new QName("urn:vmware:queryservice", "property");
    private static final QName METADATA_ELEMENT = new QName("urn:vmware:queryservice", "metadata");
    private static final QName TYPE_ELEMENT = new QName("urn:vmware:queryservice", "type");
    private Map<URI, Map<String, String>> _metadata = null;
    private static final ThreadLocal<Transformer> TRANSFORMER_HOLDER = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", Thread.currentThread().getContextClassLoader()).newTransformer();
            }
            catch (TransformerException e) {
                _log.warn((Object)"Could not create Transformer. Setup the correct TransformerFactory for the application.");
                throw new IllegalStateException("Could not create transformer. Check the setup environment.");
            }
        }
    };
    private static final ThreadLocal<XMLInputFactory> XML_INPUT_FACTORY_HOLDER = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            WstxInputFactory inputFactory = new WstxInputFactory();
            inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            return inputFactory;
        }
    };

    @Override
    public PullAtomFeed unmarshalPullFeed(InputStream stream, String baseUri) throws XMLStreamException {
        if (baseUri.charAt(baseUri.length() - 1) != '/') {
            baseUri = baseUri + "/";
        }
        XMLInputFactory inf = XML_INPUT_FACTORY_HOLDER.get();
        XMLStreamReader r = inf.createXMLStreamReader(stream);
        return this.processPullAtomFeed(r, baseUri);
    }

    private PullAtomFeed processPullAtomFeed(XMLStreamReader reader, String baseUri) throws XMLStreamException {
        if (reader.getEventType() != 7) {
            throw new IllegalArgumentException("Invalid Atom feed stream. Does not start with XML document.");
        }
        this.goToNextElement(reader);
        PullAtomFeed atomFeed = null;
        if (reader.hasNext() && reader.getEventType() == 1 && FEED_ELEMENT.equals(reader.getName())) {
            Calendar updated = null;
            String providerId = null;
            long generation = 0L;
            ForwardingIterator<PullAtomFeedEntry> entries = new ForwardingIterator<PullAtomFeedEntry>();
            this.goToNextElement(reader);
            while (reader.hasNext()) {
                if (reader.getEventType() == 1) {
                    if (ID_ELEMENT.equals(reader.getName())) {
                        providerId = this.getCharacters(reader);
                        continue;
                    }
                    if (UPDATED_ELEMENT.equals(reader.getName())) {
                        updated = this.processUpdate(reader);
                        continue;
                    }
                    if (GENERATION_ELEMENT.equals(reader.getName())) {
                        generation = this.getLong(this.getCharacters(reader));
                        continue;
                    }
                    if (ENTRY_ELEMENT.equals(reader.getName())) {
                        PullAtomFeedEntry e = this.processPullAtomFeedEntry(reader, baseUri);
                        if (e == null) continue;
                        entries.add(e);
                        continue;
                    }
                    this.skipElement(reader);
                    continue;
                }
                this.goToNextElement(reader);
            }
            if (providerId != null) {
                atomFeed = FeedFactory.createPullAtomFeed(updated, providerId, entries, generation);
            }
        }
        if (atomFeed == null) {
            throw new IllegalArgumentException("Invalid Atom feed stream. There is no atom element found in the document.");
        }
        return atomFeed;
    }

    @Override
    public ContentAtomFeed unmarshalContentFeed(InputStream stream, String baseUri) throws XMLStreamException {
        if (baseUri.charAt(baseUri.length() - 1) != '/') {
            baseUri = baseUri + "/";
        }
        XMLInputFactory inf = XML_INPUT_FACTORY_HOLDER.get();
        XMLStreamReader r = inf.createXMLStreamReader(stream);
        return this.processContentAtomFeed(r, baseUri);
    }

    private ContentAtomFeed processContentAtomFeed(XMLStreamReader reader, String baseUri) throws XMLStreamException {
        if (reader.getEventType() != 7) {
            throw new IllegalArgumentException("Invalid Atom feed stream. Does not start with XML document.");
        }
        this.goToNextElement(reader);
        ContentAtomFeed atomFeed = null;
        if (reader.hasNext() && reader.getEventType() == 1 && FEED_ELEMENT.equals(reader.getName())) {
            Calendar updated = null;
            String providerId = null;
            long generation = 0L;
            ForwardingIterator<ContentAtomFeedEntry> entries = new ForwardingIterator<ContentAtomFeedEntry>();
            this.goToNextElement(reader);
            while (reader.hasNext()) {
                if (reader.getEventType() == 1) {
                    if (ID_ELEMENT.equals(reader.getName())) {
                        providerId = this.getCharacters(reader);
                        continue;
                    }
                    if (UPDATED_ELEMENT.equals(reader.getName())) {
                        updated = this.processUpdate(reader);
                        continue;
                    }
                    if (GENERATION_ELEMENT.equals(reader.getName())) {
                        generation = this.getLong(this.getCharacters(reader));
                        continue;
                    }
                    if (ENTRY_ELEMENT.equals(reader.getName())) {
                        ContentAtomFeedEntry e = this.processContentAtomFeedEntry(reader, baseUri);
                        if (e == null) continue;
                        entries.add(e);
                        continue;
                    }
                    this.skipElement(reader);
                    continue;
                }
                this.goToNextElement(reader);
            }
            if (providerId != null) {
                atomFeed = FeedFactory.createContentAtomFeed(updated, providerId, entries, generation);
            }
        }
        if (atomFeed == null) {
            throw new IllegalArgumentException("Invalid Atom feed stream. There is no atom element found in the document.");
        }
        return atomFeed;
    }

    private long getLong(String str) {
        long result;
        block3: {
            result = 0L;
            if (str != null) {
                try {
                    result = Long.parseLong(str);
                }
                catch (NumberFormatException e) {
                    if (!_log.isErrorEnabled()) break block3;
                    _log.error((Object)("Unable to marshall long value from " + str), (Throwable)e);
                }
            }
        }
        return result;
    }

    private void goToNextElement(XMLStreamReader reader) throws XMLStreamException {
        if (!reader.hasNext()) {
            return;
        }
        do {
            reader.next();
        } while (reader.getEventType() != 1 && reader.hasNext());
    }

    private String getCharacters(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        if (event != 1) {
            return null;
        }
        int depth = 0;
        StringBuilder result = new StringBuilder();
        do {
            if (event == 1) {
                ++depth;
            } else if (event == 2) {
                --depth;
            } else if (reader.getEventType() == 4 || reader.getEventType() == 12) {
                int textLength = reader.getTextLength();
                char[] chars = new char[textLength];
                reader.getTextCharacters(0, chars, 0, textLength);
                result.append(chars);
            }
            event = reader.next();
        } while (depth != 0);
        return result.toString();
    }

    private PullAtomFeedEntry processPullAtomFeedEntry(XMLStreamReader reader, String baseUri) throws XMLStreamException {
        if (!ENTRY_ELEMENT.equals(reader.getName())) {
            return null;
        }
        this.goToNextElement(reader);
        Calendar updated = null;
        URI id = null;
        URL link = null;
        AtomFeedEntry.ChangeType changeType = null;
        ArrayList<PropertyHolder> props = new ArrayList<PropertyHolder>();
        ArrayList<MetadataHolder> metadata = new ArrayList<MetadataHolder>();
        long generation = 0L;
        while (reader.getEventType() != 2 && reader.hasNext()) {
            if (reader.getEventType() == 1) {
                String strGeneration;
                if (ID_ELEMENT.equals(reader.getName())) {
                    id = this.processUri(this.getCharacters(reader));
                    continue;
                }
                if (UPDATED_ELEMENT.equals(reader.getName())) {
                    updated = this.processUpdate(reader);
                    continue;
                }
                if (GENERATION_ELEMENT.equals(reader.getName())) {
                    generation = this.getLong(this.getCharacters(reader));
                    continue;
                }
                if (LINK_ELEMENT.equals(reader.getName())) {
                    link = this.processLink(this.getNode(reader), baseUri);
                    continue;
                }
                if (CHANGE_KIND_ELEMENT.equals(reader.getName())) {
                    String str = this.getCharacters(reader);
                    changeType = AtomFeedEntry.ChangeType.valueOf((String)str.toUpperCase());
                    continue;
                }
                if (PROPERTY_ELEMENT.equals(reader.getName())) {
                    String prop;
                    long propGen;
                    block25: {
                        strGeneration = reader.getAttributeValue(QS_NS, GENERATION);
                        propGen = 0L;
                        if (strGeneration != null) {
                            try {
                                propGen = Long.parseLong(strGeneration);
                            }
                            catch (NumberFormatException e) {
                                if (!_log.isErrorEnabled()) break block25;
                                _log.error((Object)("Unable to marshall long value from " + strGeneration), (Throwable)e);
                            }
                        }
                    }
                    if ((prop = this.getCharacters(reader)) == null) continue;
                    props.add(new PropertyHolder(QName.valueOf(prop), propGen));
                    continue;
                }
                if (METADATA_ELEMENT.equals(reader.getName())) {
                    String metadataKey;
                    long mdGen;
                    block26: {
                        strGeneration = reader.getAttributeValue(QS_NS, GENERATION);
                        mdGen = 0L;
                        if (strGeneration != null) {
                            try {
                                mdGen = Long.parseLong(strGeneration);
                            }
                            catch (NumberFormatException e) {
                                if (!_log.isErrorEnabled()) break block26;
                                _log.error((Object)("Unable to marshall long value from " + strGeneration), (Throwable)e);
                            }
                        }
                    }
                    if ((metadataKey = this.getCharacters(reader)) == null) continue;
                    PullEntryMetadata.MetadataName metadataName = PullEntryMetadata.MetadataName.UNKNOWN;
                    if (metadataKey.equals("tags")) {
                        metadataName = PullEntryMetadata.MetadataName.TAGS;
                    }
                    metadata.add(new MetadataHolder(metadataName, mdGen));
                    continue;
                }
                this.skipElement(reader);
                continue;
            }
            this.goToNextElement(reader);
        }
        try {
            List<PullEntryMetadata> metadataList;
            List<PullEntryProperty> propList;
            if (props.isEmpty()) {
                propList = EMPTY_PULL_PROP_LIST;
            } else {
                propList = new ArrayList<PullEntryProperty>();
                for (PropertyHolder prop : props) {
                    propList.add(FeedFactory.createPullEntryProperty(prop._name, updated, prop._generation));
                }
            }
            if (metadata.isEmpty()) {
                metadataList = EMPTY_PULL_METADATA_LIST;
            } else {
                metadataList = new ArrayList<PullEntryMetadata>();
                for (MetadataHolder md : metadata) {
                    metadataList.add(FeedFactory.createPullEntryMetadata(md._pull_name, updated, md._generation));
                }
            }
            return FeedFactory.createPullAtomFeedEntry(id, updated, changeType, propList, metadataList, link, generation, null);
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Invalid stream.", e);
        }
    }

    private ContentAtomFeedEntry processContentAtomFeedEntry(XMLStreamReader reader, String baseUri) throws XMLStreamException {
        if (!ENTRY_ELEMENT.equals(reader.getName())) {
            return null;
        }
        this.goToNextElement(reader);
        Calendar updated = null;
        Document doc = null;
        URI id = null;
        URL link = null;
        AtomFeedEntry.ChangeType changeType = null;
        ArrayList<PropertyHolder> props = new ArrayList<PropertyHolder>();
        ArrayList<MetadataHolder> metadata = new ArrayList<MetadataHolder>();
        Map<String, String> metadatacontent = null;
        long generation = 0L;
        QName type = null;
        while (reader.getEventType() != 2 && reader.hasNext()) {
            if (reader.getEventType() == 1) {
                String strGeneration;
                if (ID_ELEMENT.equals(reader.getName())) {
                    id = this.processUri(this.getCharacters(reader));
                    continue;
                }
                if (UPDATED_ELEMENT.equals(reader.getName())) {
                    updated = this.processUpdate(reader);
                    continue;
                }
                if (GENERATION_ELEMENT.equals(reader.getName())) {
                    generation = this.getLong(this.getCharacters(reader));
                    continue;
                }
                if (TYPE_ELEMENT.equals(reader.getName())) {
                    String objectType = this.getCharacters(reader);
                    type = QName.valueOf(objectType);
                    continue;
                }
                if (LINK_ELEMENT.equals(reader.getName())) {
                    link = this.processLink(this.getNode(reader), baseUri);
                    continue;
                }
                if (CONTENT_ELEMENT.equals(reader.getName())) {
                    this.goToNextElement(reader);
                    doc = this.processDoc(reader);
                    continue;
                }
                if (CHANGE_KIND_ELEMENT.equals(reader.getName())) {
                    String str = this.getCharacters(reader);
                    changeType = AtomFeedEntry.ChangeType.valueOf((String)str.toUpperCase());
                    continue;
                }
                if (PROPERTY_ELEMENT.equals(reader.getName())) {
                    String prop;
                    long propGen;
                    block28: {
                        strGeneration = reader.getAttributeValue(QS_NS, GENERATION);
                        propGen = 0L;
                        if (strGeneration != null) {
                            try {
                                propGen = Long.parseLong(strGeneration);
                            }
                            catch (NumberFormatException e) {
                                if (!_log.isErrorEnabled()) break block28;
                                _log.error((Object)("Unable to marshall long value from " + strGeneration), (Throwable)e);
                            }
                        }
                    }
                    if ((prop = this.getCharacters(reader)) == null) continue;
                    props.add(new PropertyHolder(QName.valueOf(prop), propGen));
                    continue;
                }
                if (METADATA_ELEMENT.equals(reader.getName())) {
                    String metadataKey;
                    long mdGen;
                    block29: {
                        strGeneration = reader.getAttributeValue(QS_NS, GENERATION);
                        mdGen = 0L;
                        if (strGeneration != null) {
                            try {
                                mdGen = Long.parseLong(strGeneration);
                            }
                            catch (NumberFormatException e) {
                                if (!_log.isErrorEnabled()) break block29;
                                _log.error((Object)("Unable to marshall long value from " + strGeneration), (Throwable)e);
                            }
                        }
                    }
                    if ((metadataKey = this.getCharacters(reader)) == null) continue;
                    PullEntryMetadata.MetadataName metadataName = PullEntryMetadata.MetadataName.UNKNOWN;
                    if (metadataKey.equals("tags")) {
                        metadataName = PullEntryMetadata.MetadataName.TAGS;
                    }
                    metadata.add(new MetadataHolder(metadataName, mdGen));
                    continue;
                }
                if (METADATA_CONTENT_ELEMENT.equals(reader.getName())) {
                    metadatacontent = this.getMetadataMap(reader);
                    if (metadatacontent == null || metadatacontent.size() == 0) continue;
                    this._metadata = new HashMap<URI, Map<String, String>>();
                    this._metadata.put(id, metadatacontent);
                    continue;
                }
                this.skipElement(reader);
                continue;
            }
            this.goToNextElement(reader);
        }
        try {
            List<PullEntryMetadata> metadataList;
            List<PullEntryProperty> propList;
            if (props.isEmpty()) {
                propList = EMPTY_PULL_PROP_LIST;
            } else {
                propList = new ArrayList<PullEntryProperty>();
                for (PropertyHolder prop : props) {
                    propList.add(FeedFactory.createContentEntryProperty(prop._name, updated, prop._generation));
                }
            }
            if (metadata.isEmpty()) {
                metadataList = EMPTY_PULL_METADATA_LIST;
            } else {
                metadataList = new ArrayList<PullEntryMetadata>();
                for (MetadataHolder md : metadata) {
                    metadataList.add(FeedFactory.createContentEntryMetadata(md._pull_name, updated, md._generation));
                }
            }
            return FeedFactory.createContentAtomFeedEntry(id, updated, changeType, propList, metadataList, link, doc, generation, type);
        }
        catch (TransformerException e) {
            throw new XMLStreamException("Invalid stream.", e);
        }
    }

    private Map<String, String> getMetadataMap(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        this.goToNextElement(reader);
        while (reader.getEventType() != 2 && reader.hasNext()) {
            if (reader.getEventType() == 1) {
                if (TAGS.equals(reader.getName()) || LAST_MODIFIED.equals(reader.getName())) {
                    metadata.put(reader.getName().getLocalPart(), this.getCharacters(reader));
                    continue;
                }
                this.skipElement(reader);
                continue;
            }
            this.goToNextElement(reader);
        }
        return metadata;
    }

    @Override
    public Map<String, String> getContentFeedMetadata(URI uri) {
        if (this._metadata != null) {
            return this._metadata.get(uri);
        }
        return null;
    }

    private URL processLink(Node n, String baseUri) {
        NamedNodeMap attrs = n.getAttributes();
        if (attrs == null) {
            return null;
        }
        Attr href = (Attr)attrs.getNamedItem("href");
        if (href == null) {
            return null;
        }
        String urlStr = href.getTextContent();
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException e) {
            if (urlStr.charAt(0) == '/') {
                urlStr = urlStr.substring(1, urlStr.length());
            }
            urlStr = baseUri + urlStr;
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
    }

    private Document processDoc(XMLStreamReader reader) throws XMLStreamException {
        try {
            Transformer t = TRANSFORMER_HOLDER.get();
            t.setOutputProperty("omit-xml-declaration", "yes");
            DOMResult result = new DOMResult();
            t.transform(new StAXSource(reader), result);
            return (Document)result.getNode();
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Could not parse the stream.", e);
        }
    }

    private URI processUri(String text) {
        if (text == null) {
            return null;
        }
        try {
            return new URI(text);
        }
        catch (URISyntaxException e) {
            _log.warn((Object)("Invalid uri " + text));
            return null;
        }
    }

    private Calendar processUpdate(XMLStreamReader reader) throws XMLStreamException {
        String text = this.getCharacters(reader);
        if (text == null) {
            return null;
        }
        Calendar update = null;
        try {
            update = CalendarHelper.parseXsdDateTime((CharSequence)text);
        }
        catch (UnmarshallException e) {
            // empty catch block
        }
        return update;
    }

    private Node getNode(XMLStreamReader reader) {
        Transformer t = TRANSFORMER_HOLDER.get();
        t.setOutputProperty("omit-xml-declaration", "yes");
        DOMResult result = new DOMResult();
        try {
            t.transform(new StAXSource(reader), result);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Could parse the stream.", e);
        }
        Node node = result.getNode() instanceof Document ? result.getNode().getFirstChild() : result.getNode();
        return node;
    }

    void skipElement(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        if (event != 1) {
            return;
        }
        int depth = 0;
        do {
            if (event == 1) {
                ++depth;
            } else if (event == 2) {
                --depth;
            }
            event = reader.next();
        } while (depth != 0);
    }

    private static class MetadataHolder {
        PullEntryMetadata.MetadataName _pull_name;
        long _generation;

        MetadataHolder(PullEntryMetadata.MetadataName name, long generation) {
            this._pull_name = name;
            this._generation = generation;
        }
    }

    private static class PropertyHolder {
        QName _name;
        long _generation;

        PropertyHolder(QName name, long generation) {
            this._name = name;
            this._generation = generation;
        }
    }
}

