/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.commons.util;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;

public class EventMessageFormatter {
    private Event _event;
    private EventDescription.EventDetail _eventDetail;
    private ManagedObjectReference _context;

    public EventMessageFormatter(Event event, EventDescription.EventDetail eventDetail, ManagedObjectReference managedObjectReference) {
        this._event = event;
        this._eventDetail = eventDetail;
        this._context = managedObjectReference;
    }

    public String getFullMessage() {
        String string = "";
        string = this._event instanceof ExtendedEvent ? this.getFullFormattedMessage() : (this._eventDetail == null ? this.getFullFormattedMessage() : this.getContextSensitiveMessage());
        return string;
    }

    private String getFullFormattedMessage() {
        if (this._event.fullFormattedMessage != null) {
            return this._event.fullFormattedMessage;
        }
        return "";
    }

    private String getContextSensitiveMessage() {
        String string = "";
        if (this._context == null) {
            string = this._eventDetail.fullFormat;
        } else {
            switch (ManagedObjectTypes.getValueOf(this._context.getType())) {
                case VIRTUAL_MACHINE: {
                    if (this._event.vm == null || this._event.vm.vm == null || !this._event.vm.vm.getServerGuid().equals(this._context.getServerGuid())) break;
                    string = this._eventDetail.formatOnVm;
                    break;
                }
                case HOST: {
                    if (this._event.host == null || this._event.host.host == null || !this._event.host.host.getServerGuid().equals(this._context.getServerGuid())) break;
                    string = this._eventDetail.formatOnHost;
                    break;
                }
                case COMPUTE_RESOURCE: {
                    if (this._event.computeResource == null || this._event.computeResource.computeResource == null || this._event.computeResource.computeResource.getServerGuid() != this._context.getServerGuid()) break;
                    string = this.getFormatOnComputeResource();
                    break;
                }
                case DATACENTER: {
                    if (this._event.datacenter == null || this._event.datacenter.datacenter == null || this._event.datacenter.datacenter.getServerGuid() != this._context.getServerGuid()) break;
                    string = this.getFormatOnDatacenter();
                    break;
                }
                case DATASTORE: {
                    if (this._event.ds == null || this._event.ds.datastore == null || this._event.ds.datastore.getServerGuid() != this._context.getServerGuid()) break;
                    string = this.getFormatOnDatacenter();
                }
            }
            if (StringUtil.isNullOrEmpty((String)string)) {
                string = this._eventDetail.fullFormat;
            }
        }
        return string;
    }

    private String getFormatOnComputeResource() {
        String string = this._eventDetail.formatOnComputeResource;
        if (StringUtil.isNullOrEmpty((String)string) && StringUtil.isNullOrEmpty((String)(string = this._eventDetail.formatOnHost))) {
            string = this._eventDetail.formatOnVm;
        }
        return string;
    }

    private String getFormatOnDatacenter() {
        String string = this._eventDetail.formatOnDatacenter;
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = this.getFormatOnComputeResource();
        }
        return string;
    }
}

