/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loganalyzer.provider;

import com.vmware.loganalyzer.provider.HostInfo;
import com.vmware.loganalyzer.provider.LogBrowserServiceImpl;
import com.vmware.loganalyzer.provider.ProxyRequest;
import com.vmware.loganalyzer.provider.VmInfo;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import javax.servlet.http.HttpSession;

public class LogBrowserProviderImpl
implements PropertyProviderBean {
    @type(value="VirtualMachine")
    public VmInfo getVmInfo(ManagedObjectReference vmRef) {
        VmInfo info = new VmInfo();
        info.author = "Author for " + vmRef.getValue();
        info.organization = "Organization for " + vmRef.getValue();
        System.out.println("Requested VM");
        try {
            ManagedObject x = ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            if (x == null || !(x instanceof VirtualMachine)) {
                throw new IllegalArgumentException("Cannot get VM object: " + vmRef.getValue());
            }
            VirtualMachine vm = (VirtualMachine)x;
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @type(value="HostSystem")
    public HostInfo getHostInfoParam(ManagedObjectReference hostRef) {
        HostInfo info = new HostInfo();
        info.name = "Host name";
        info.ipAddress = "IP Address";
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            if (host == null) {
                throw new IllegalArgumentException("Host not found: " + hostRef.getValue());
            }
            info = new HostInfo();
            info.name = host.getName();
            Summary summary = host.getSummary();
            if (summary != null && summary.getConfig() != null && summary.getConfig().getProduct() != null) {
                AboutInfo about = summary.getConfig().getProduct();
                info.ipAddress = about.version;
            }
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            info.ipAddress = "";
            info.error = e.getMessage();
            return info;
        }
    }

    @type(value="Folder")
    public HostInfo getFolderInfo(ManagedObjectReference vcRef) {
        HostInfo info = new HostInfo();
        info.name = "Host name";
        info.ipAddress = "IP Address";
        try {
            Folder host = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcRef);
            if (host == null) {
                throw new IllegalArgumentException("VC not found: " + vcRef.getValue());
            }
            info = new HostInfo();
            info.name = host.getName();
            info.ipAddress = "aa";
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            info.ipAddress = "";
            info.error = e.getMessage();
            return info;
        }
    }

    public SessionManager GetSessionManager(ManagedObjectReference hostRef) throws Exception {
        HttpSession session = SessionUtil.getHttpSession();
        LinkedVcGroupRegistry registry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)session);
        LinkedVcGroup linkedGroup = registry.getLinkedGroupByServiceUuid(hostRef.getServerGuid());
        VcService service = linkedGroup.getStartUpVcService();
        ManagedObjectReference sessionManagerMOR = service.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sessionManagerMOR);
        return sessionManager;
    }

    @type(value="HostSystem,Folder")
    public HostInfo getServiceGet(ManagedObjectReference hostRef, ProxyRequest request) throws Exception {
        HostInfo info = new HostInfo();
        if (request == null) {
            info.error = "Invalid argument: request is null";
            return info;
        }
        if (request.method.equalsIgnoreCase("get")) {
            LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
            info.name = request.url;
            info.ipAddress = lbs.echo(request.url);
            return info;
        }
        if (request.method.equalsIgnoreCase("post")) {
            LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
            info.name = request.url;
            info.ipAddress = lbs.postIt(request.url, request.body);
            return info;
        }
        if (request.method.equalsIgnoreCase("vc")) {
            try {
                HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
                if (host == null) {
                    info.error = "Host is null";
                    return info;
                }
                info.name = request.objectName;
                Summary summary = host.getSummary();
                AboutInfo about = null;
                if (summary != null && summary.getConfig() != null && summary.getConfig().getProduct() != null) {
                    about = summary.getConfig().getProduct();
                }
                if (about != null && about.getVersion().startsWith("4.")) {
                    StringBuilder out = new StringBuilder();
                    out.append("<Info>\n");
                    out.append("  <host>");
                    out.append(request.objectName);
                    out.append("  </host>\n");
                    out.append("  <url>");
                    out.append(request.url);
                    out.append("</url>");
                    out.append("</Info>\n");
                    LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
                    info.name = request.url;
                    String reqUrl = request.baseUrl + "/Log%20Analysis/" + host.getName() + "/refresh";
                    info.ipAddress = lbs.postIt(reqUrl, out.toString());
                    return info;
                }
                SessionManager sessionManager = this.GetSessionManager(hostRef);
                SessionManager.HttpServiceRequestSpec spec = new SessionManager.HttpServiceRequestSpec();
                spec.method = "GET";
                spec.url = "https://" + info.name + ":443/" + request.url;
                SessionManager.GenericServiceTicket ticket = null;
                try {
                    ticket = sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)spec);
                }
                catch (Exception e) {
                    ticket = null;
                }
                StringBuilder out = new StringBuilder();
                out.append("<Info>\n");
                out.append("  <host>");
                out.append(request.objectName);
                out.append("  </host>\n");
                out.append("  <url>");
                out.append(request.url);
                out.append("  </url>\n");
                if (ticket != null) {
                    out.append("  <ticket>");
                    out.append(ticket.id);
                    out.append("  </ticket>\n");
                }
                out.append("</Info>\n");
                LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
                info.name = request.url;
                String reqUrl = request.baseUrl + "/Log%20Analysis/" + request.objectName + "/refresh";
                info.ipAddress = lbs.postIt(reqUrl, out.toString());
                return info;
            }
            catch (Exception e) {
                info.error = "Error: " + e.getMessage();
                return info;
            }
        }
        info.error = "Invalid request method: " + request.method;
        return info;
    }

    @type(value="Folder")
    public HostInfo getServiceGetVC(ManagedObjectReference vcRef, ProxyRequest request) throws Exception {
        HostInfo info = new HostInfo();
        if (request == null) {
            info.error = "Invalid argument: request is null";
            return info;
        }
        if (request.method.equalsIgnoreCase("get")) {
            LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
            info.name = request.url;
            info.ipAddress = lbs.echo(request.url);
            return info;
        }
        if (request.method.equalsIgnoreCase("post")) {
            LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
            info.name = request.url;
            info.ipAddress = lbs.postIt(request.url, request.body);
            return info;
        }
        if (request.method.equalsIgnoreCase("vc")) {
            try {
                Folder host = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcRef);
                if (host == null) {
                    info.error = "Host is null";
                    return info;
                }
                info.name = host.getName();
                SessionManager sessionManager = this.GetSessionManager(vcRef);
                SessionManager.HttpServiceRequestSpec spec = new SessionManager.HttpServiceRequestSpec();
                spec.method = "GET";
                spec.url = "https://" + info.name + ":443/" + request.url;
                spec.url = request.url;
                SessionManager.GenericServiceTicket ticket = null;
                try {
                    ticket = sessionManager.acquireGenericServiceTicket((SessionManager.ServiceRequestSpec)spec);
                }
                catch (Exception e) {
                    ticket = null;
                }
                StringBuilder out = new StringBuilder();
                out.append("<Info>\n");
                out.append("  <host>");
                out.append(request.objectName);
                out.append("  </host>\n");
                out.append("  <url>");
                out.append(spec.url);
                out.append("  </url>\n");
                if (ticket != null) {
                    out.append("  <ticket>");
                    out.append(ticket.id);
                    out.append("  </ticket>\n");
                }
                out.append("</Info>\n");
                LogBrowserServiceImpl lbs = new LogBrowserServiceImpl();
                info.name = request.url;
                String reqUrl = request.baseUrl + "/Log%20Analysis/" + request.objectName + "/refresh";
                info.ipAddress = lbs.postIt(reqUrl, out.toString());
                return info;
            }
            catch (Exception e) {
                info.error = "Error: " + e.getMessage();
                return info;
            }
        }
        info.error = "Invalid request method: " + request.method;
        return info;
    }
}

