/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loganalyzer.provider;

import com.vmware.loganalyzer.provider.JAXBUtils;
import com.vmware.loganalyzer.provider.LogBrowserService;
import com.vmware.vide.vlogbrowser.service.ILogBrowserService;
import com.vmware.vide.vlogbrowser.service.model.FilterResult;
import com.vmware.vide.vlogbrowser.service.model.LogEntries;
import com.vmware.vide.vlogbrowser.service.model.LogTableResult;
import com.vmware.vide.vlogbrowser.service.model.ProgressResult;
import com.vmware.vide.vlogbrowser.service.model.ResourceInfo;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogBrowserServiceImpl
implements LogBrowserService {
    private static final Log _logger = LogFactory.getLog(LogBrowserServiceImpl.class);
    private static ILogBrowserService lbServiceFacade;
    private static final String RESOURCE_NAME_REGEX = "^/.+?/(.+?)/";

    public synchronized void setLogBrowserService(ILogBrowserService service) {
        lbServiceFacade = service;
    }

    public synchronized void unSetLogBrowserService(ILogBrowserService service) {
        lbServiceFacade = null;
    }

    @Override
    public String echo(String message) throws Exception {
        _logger.info((Object)("The Logbrowser client is calling the Logbrowser core with the following command: " + message));
        String resName = this.getValueFromRegexGroup(RESOURCE_NAME_REGEX, 1, message);
        String result = "";
        try {
            if (message.contains("/manifest/")) {
                List logBundles = lbServiceFacade.getProjectManifest();
                result = JAXBUtils.getXML(logBundles, "LogBundles");
            } else if (message.contains("/count/")) {
                Integer count = lbServiceFacade.getCount(resName);
                LogTableResult tableResult = new LogTableResult();
                tableResult.setNumEntries(count.intValue());
                result = JAXBUtils.getXML(tableResult);
            } else if (message.contains("/entries/")) {
                LogEntries entries = lbServiceFacade.getEntries(resName, this.getValueFromRegexGroup("filter='([\\w\\d\\s@]+)'", 1, message), Integer.parseInt(this.getValueFromRegexGroup("first='([\\d]+)'", 1, message)), Integer.parseInt(this.getValueFromRegexGroup("cnt='([\\d]+)'", 1, message)));
                LogTableResult tableResult = new LogTableResult();
                tableResult.setRows(entries.getValues());
                tableResult.setColumns(entries.getColumns());
                tableResult.setStatus(entries.getStatus());
                tableResult.setTime(String.valueOf(entries.getDateDelta()));
                result = JAXBUtils.getXML(tableResult);
            } else if (message.contains("/filter/")) {
                String filterId = this.getValueFromRegexGroup("/filter/(.+?)/", 1, message);
                if ("".equals(filterId)) {
                    List filters = lbServiceFacade.getFilters(resName);
                    LogTableResult tableResult = new LogTableResult();
                    tableResult.setFilters(filters);
                    result = JAXBUtils.getXML(tableResult);
                } else {
                    FilterResult filter = lbServiceFacade.getFilters(resName, filterId);
                    result = JAXBUtils.getXML(filter);
                }
            } else if (message.contains("/find/x/?first=0&t=")) {
                String dateString = this.getValueFromRegexGroup("/find/x/\\?first=0&t='(.+)'", 1, message);
                dateString = dateString.replace("%20", " ");
                SimpleDateFormat stdDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                Date date = stdDateFormat.parse(dateString);
                Integer[] findRows = lbServiceFacade.findIndexByDateTime(resName, 0, date);
                LogTableResult tableResult = new LogTableResult();
                tableResult.setFindRows(findRows);
                result = JAXBUtils.getXML(tableResult);
            } else if (message.contains("/find/")) {
                int firstIndex = 0;
                if (message.contains("\\?first=")) {
                    String firstIndexString = this.getValueFromRegexGroup("\\?first=(\\d+)", 1, message);
                    firstIndex = firstIndexString.isEmpty() ? 0 : Integer.parseInt(firstIndexString);
                }
                String pattern = this.getValueFromRegexGroup("/find/(.*?)/", 1, message);
                Integer[] findRows = lbServiceFacade.findIndexByText(resName, firstIndex, pattern);
                LogTableResult tableResult = new LogTableResult();
                tableResult.setFindRows(findRows);
                result = JAXBUtils.getXML(tableResult);
            } else if (message.contains("/download/")) {
                String logx = this.getValueFromRegexGroup("\\?log=(.+)", 1, message);
                URL url = lbServiceFacade.fetchLogFileOrBundle(resName, logx);
                result = url.toString();
            } else {
                _logger.error((Object)("missing command for message: " + message));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("The command: " + message + "\nCaused the following error:\n" + ex.getMessage()));
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    @Override
    public String postIt(String message, String body) throws Exception {
        _logger.info((Object)("The Logbrowser client is calling the Logbrowser core with the following command: " + message));
        String resName = this.getValueFromRegexGroup(RESOURCE_NAME_REGEX, 1, message);
        String result = "";
        try {
            if (message.contains("refresh-progress")) {
                ProgressResult progress = lbServiceFacade.requestProgress(resName);
                result = JAXBUtils.getXML(progress);
            } else if (message.contains("refresh")) {
                ResourceInfo info = (ResourceInfo)JAXBUtils.unmarshal(body, ResourceInfo.class);
                ProgressResult progress = lbServiceFacade.refreshLogs(resName, info);
                result = JAXBUtils.getXML(progress);
            } else if (message.contains("/filter/")) {
                String filterId = this.getValueFromRegexGroup("/filter/(.+?)/", 1, message);
                if (!"".equals(filterId)) {
                    if (message.contains("/save/")) {
                        FilterResult filterResult = (FilterResult)JAXBUtils.unmarshal(body, FilterResult.class);
                        lbServiceFacade.saveFilter(resName, filterId, filterResult);
                    } else if (message.contains("/delete/")) {
                        lbServiceFacade.deleteFilter(resName, filterId);
                    } else {
                        lbServiceFacade.applyFilter(resName, filterId);
                    }
                } else {
                    String around = this.getValueFromRegexGroup("around=\\'(\\d+)\\'", 1, message);
                    String keyword = this.getValueFromRegexGroup("q='([^&]+)'", 1, message);
                    lbServiceFacade.applyFilter(resName, keyword, Integer.parseInt(around.isEmpty() ? "0" : around));
                }
            } else if (message.contains("/adjust/")) {
                String dateDeltaString = this.getValueFromRegexGroup("/adjust/\\?t=(.+)", 1, message);
                lbServiceFacade.adjustTime(resName, Long.parseLong(dateDeltaString));
            } else if (message.contains("/delete/")) {
                lbServiceFacade.deleteAllLogsFromHost(resName);
            } else {
                _logger.error((Object)("missing command for message:" + message + " \n body:" + body));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("The command: " + message + "\nCaused the following error:\n" + ex.getMessage()));
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    private String getValueFromRegexGroup(String regex, int groupIndex, String s) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(groupIndex);
        }
        return "";
    }
}

