/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loganalyzer.provider;

import com.vmware.loganalyzer.provider.VcLogBundleGenerationSpec;
import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(LogMutationProvider.class);

    public OperationResult apply(ManagedObjectReference vcRef, VcLogBundleGenerationSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            VcService service = LogMutationProvider.getVcService(vcRef);
            ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
            if (serviceContent == null) {
                _logger.error((Object)"Could not retrieve ServiceInstanceContent");
                throw new RuntimeException("The connection to Diagnostic Manager could not be established.");
            }
            DiagnosticManager dm = (DiagnosticManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getDiagnosticManager());
            result.task = dm.generateLogBundles(spec.includeVcLogs, spec.hostReferences, null);
        }
        catch (Exception e) {
            _logger.warn((Object)"The log bundles generation task failed. ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public static VcService getVcService(ManagedObjectReference objRef) {
        if (!ManagedObjectUtil.isRootFolder((ManagedObjectReference)objRef)) {
            _logger.error((Object)("Fetch invalid objRef = " + (objRef == null ? null : objRef.getValue())));
            throw new RuntimeException("The connection to vCenter Server could not be established.");
        }
        VcService service = VimSessionUtil.getService((String)objRef.getServerGuid(), null);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            throw new RuntimeException("The connection to vCenter Server could not be established.");
        }
        return service;
    }
}

