/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http;

public enum SignatureAlgorithm {
    RSA_SHA256{

        @Override
        public String digestAlgo() {
            return "SHA-256";
        }

        @Override
        public String signatureAlgo() {
            return "SHA256withRSA";
        }

        public String toString() {
            return "RSA-SHA256";
        }
    }
    ,
    RSA_SHA384{

        @Override
        public String digestAlgo() {
            return "SHA-384";
        }

        @Override
        public String signatureAlgo() {
            return "SHA384withRSA";
        }

        public String toString() {
            return "RSA-SHA384";
        }
    }
    ,
    RSA_SHA512{

        @Override
        public String digestAlgo() {
            return "SHA-512";
        }

        @Override
        public String signatureAlgo() {
            return "SHA512withRSA";
        }

        public String toString() {
            return "RSA-SHA512";
        }
    };


    public abstract String digestAlgo();

    public abstract String signatureAlgo();

    public static SignatureAlgorithm pickup(String algoName) {
        SignatureAlgorithm result = null;
        for (SignatureAlgorithm algo : SignatureAlgorithm.values()) {
            if (!algo.toString().equals(algoName)) continue;
            result = algo;
            break;
        }
        return result;
    }
}

