/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.SignatureAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;

final class CryptoEngines {
    private final SignatureAlgorithm _alg;
    private final MessageDigest _digest;
    private final Signature _signature;

    CryptoEngines(SignatureAlgorithm alg) throws NoSuchAlgorithmException {
        assert (alg != null);
        this._alg = alg;
        this._digest = MessageDigest.getInstance(this._alg.digestAlgo());
        assert (this._digest != null);
        this._signature = Signature.getInstance(this._alg.signatureAlgo());
        assert (this._signature != null);
    }

    SignatureAlgorithm algorithm() {
        return this._alg;
    }

    MessageDigest digestEngine() {
        return this._digest;
    }

    Signature signatureEngine() {
        return this._signature;
    }
}

