/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.impl.CharSequence;
import com.vmware.vim.sso.http.impl.ParamValue;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParamFormatter {
    private static final char EQ = '=';
    private static final char QUOTE = '\"';
    private static final char OR_OP = '|';
    private static final String PARAM_NAME_REG_EX = "(" + ParamValue.Param.token.name() + '|' + ParamValue.Param.nonce.name() + '|' + ParamValue.Param.bodyhash.name() + '|' + ParamValue.Param.signature_alg.name() + '|' + ParamValue.Param.signature.name() + ")";
    private static final Pattern PARAM_REG_EX = Pattern.compile(PARAM_NAME_REG_EX + "=\"([\\x20-\\x7E&&[^\\x22\\x5C]]+)\"");

    ParamFormatter() {
    }

    static int valueLength(ParamValue param, int txtMaxLength) {
        assert (param != null);
        assert (txtMaxLength >= 0);
        int supplementaryCharsNb = param.key().name().length() + 3;
        int maxValueLength = Math.max(0, txtMaxLength - supplementaryCharsNb);
        int valueLength = Math.min(maxValueLength, param.value().length());
        assert (valueLength >= 0);
        return valueLength;
    }

    static StringBuilder format(ParamValue param, StringBuilder sb) {
        assert (param != null);
        assert (sb != null);
        sb.append(param.key().name());
        sb.append('=');
        sb.append('\"');
        sb.append(param.value());
        sb.append('\"');
        return sb;
    }

    static ParamValue parse(java.lang.CharSequence txt, ParsePosition pos) {
        assert (pos.getIndex() <= txt.length());
        Matcher matcher = PARAM_REG_EX.matcher(new CharSequence(txt, pos.getIndex()));
        ParamValue res = null;
        if (matcher.lookingAt()) {
            pos.setIndex(matcher.end() + pos.getIndex());
            res = new ParamValue(ParamValue.Param.valueOf(matcher.group(1)), matcher.group(2));
        }
        return res;
    }
}

