/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vcenter.ovf.DatastoreDiskGroup;
import com.vmware.vcenter.ovf.DatastoreMappingParams;
import com.vmware.vcenter.ovf.ImportSessionTypes;
import com.vmware.vcenter.ovf.NameAndProductParams;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.provisioning.ovf.OvfDeployService;
import com.vmware.vsphere.client.provisioning.ovf.OvfErrorFormatter;
import com.vmware.vsphere.client.provisioning.ovf.OvfFileInfoResult;
import com.vmware.vsphere.client.provisioning.ovf.OvfQueryResult;
import com.vmware.vsphere.client.provisioning.ovf.spec.StorageValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.DeployOnResourcePoolSpec;
import com.vmware.vsphere.client.provisioning.spec.DeployOnResourcePoolValidationData;
import com.vmware.vsphere.client.provisioning.spec.DeployOnResourcePoolValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.FileInfoValidationData;
import com.vmware.vsphere.client.provisioning.spec.FileInfoValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.OvfReferencesValidationSpec;
import com.vmware.vsphere.client.provisioning.spec.OvfUploadUrlInfo;
import com.vmware.vsphere.client.provisioning.util.ProvisioningResourcePoolUtil;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import com.vmware.vsphere.client.provisioning.util.ProvisioningStorageUtil;
import com.vmware.vsphere.client.provisioning.workflow.Workflow;
import com.vmware.vsphere.client.util.collection.CollectionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningResourcePoolMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ProvisioningResourcePoolMutationProvider.class);
    private static final String COMPUTE_RESOURCE_CONF_PROPERTY = "configurationEx";
    private static final String HOSTS_PROPERTY = "host";
    private static final String RESOURCE_POOL_PROPERTY = "resourcePool";
    private final DataService _dataService;
    private final OvfDeployService _ovfDeployService;
    private final OvfErrorFormatter _ovfErrorFormatter;

    public ProvisioningResourcePoolMutationProvider(DataService dataService, OvfDeployService ovfDeployService, OvfErrorFormatter ovfErrorFormatter) {
        this._dataService = dataService;
        this._ovfDeployService = ovfDeployService;
        this._ovfErrorFormatter = ovfErrorFormatter;
        _logger.info((Object)"instantiated");
    }

    public OperationResult add(DeployOnResourcePoolSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"DeployOnResourcePoolSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        try {
            List<Object> params = Arrays.asList(spec.parameters);
            OvfFileInfoResult fileInfo = this._ovfDeployService.deployOvf(params);
            result.task = fileInfo.task;
            OvfUploadUrlInfo urlInfo = new OvfUploadUrlInfo();
            urlInfo.fileByUri = fileInfo.fileByUri;
            urlInfo.inMappedOvaMode = spec.inMappedOvaMode;
            result.result = urlInfo;
        }
        catch (Exception e) {
            _logger.error((Object)("Error when deploying a template with spec: " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference objectRef, OvfReferencesValidationSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectRef, spec});
        ValidationResult result = new ValidationResult();
        result.entity = objectRef;
        result.result = true;
        List missingFiles = this._ovfDeployService.checkOvfReferences(spec.selectedFiles, spec.descriptorContents);
        if (!missingFiles.isEmpty()) {
            result.parameter = missingFiles;
            result.result = false;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference objectRef, DeployOnResourcePoolSpec spec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectRef, spec});
        ValidationResult result = new ValidationResult();
        result.entity = objectRef;
        result.result = true;
        String[] propToRetrieve = new String[]{RESOURCE_POOL_PROPERTY, HOSTS_PROPERTY, COMPUTE_RESOURCE_CONF_PROPERTY};
        ManagedObjectReference resourcePool = null;
        ManagedObjectReference[] hosts = null;
        ComputeResource.ConfigInfo computeResConfig = null;
        String errorMsg = null;
        try {
            PropertyValue[] propValues = ProvisioningResourcePoolUtil.getComputeResourceProperties(objectRef, this._dataService, propToRetrieve);
            if (propValues != null) {
                for (PropertyValue propValue : propValues) {
                    if (propValue == null) continue;
                    if (RESOURCE_POOL_PROPERTY.equals(propValue.propertyName)) {
                        resourcePool = (ManagedObjectReference)propValue.value;
                        result.parameter = resourcePool;
                        continue;
                    }
                    if (HOSTS_PROPERTY.equals(propValue.propertyName)) {
                        hosts = (ManagedObjectReference[])propValue.value;
                        continue;
                    }
                    if (!COMPUTE_RESOURCE_CONF_PROPERTY.equals(propValue.propertyName)) continue;
                    computeResConfig = (ComputeResource.ConfigInfo)propValue.value;
                }
            }
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)objectRef, HostSystem.class)) {
                ManagedObjectReference[] host = new ManagedObjectReference[]{objectRef};
                if (!ProvisioningResourcePoolUtil.atLeastOneHostConnected(this._dataService, host).booleanValue()) {
                    errorMsg = ProvisioningResourcePoolUtil.getHostsNotConnectionError(objectRef, computeResConfig);
                }
            } else if (!ProvisioningResourcePoolUtil.atLeastOneHostConnected(this._dataService, hosts).booleanValue()) {
                errorMsg = ProvisioningResourcePoolUtil.getHostsNotConnectionError(objectRef, computeResConfig);
            }
            if (errorMsg == null && !spec.inOvfMode.booleanValue() && !spec.inVmMode.booleanValue() && ProvisioningResourcePoolUtil.isDrsDisabled(computeResConfig).booleanValue()) {
                errorMsg = ProvisioningServiceUtil.getLocalizedString("error.nonDrsCluster");
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error when trying to validate the target resource with spec: " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
            result.result = false;
            return result;
        }
        if (errorMsg != null) {
            _logger.warn((Object)("The validation of the resource failed: " + errorMsg));
            result.error = ErrorTransformUtil.convertError((Exception)new Exception(errorMsg));
            result.result = false;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference objectRef, FileInfoValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objectRef;
        try {
            List<Object> deploymentContext = this.buildDeploymentContext(spec.deploymentSpec);
            OvfFileInfoResult fileInfo = this._ovfDeployService.queryFileInfo(deploymentContext);
            FileInfoValidationData data2 = new FileInfoValidationData();
            data2.descriptorURI = fileInfo.descriptorURI;
            data2.manifestURI = fileInfo.manifestURI;
            data2.certificateURI = fileInfo.certificateURI;
            data2.newContext = new ArrayList(fileInfo.newContext);
            data2.newWorkflowPath = ProvisioningServiceUtil.getWorkflowPath(data2.newContext, this._dataService);
            validationResult.result = data2;
        }
        catch (Exception e) {
            _logger.error((Object)("Failed to fetch file info for PUSH import session with spec :" + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            validationResult.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference objectRef, DeployOnResourcePoolValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = objectRef;
        try {
            if (spec.template instanceof String) {
                spec.template = URI.create((String)spec.template);
            }
            List<Object> deploymentContext = new ArrayList();
            deploymentContext = spec.sourceType == ImportSessionTypes.SourceType.PUSH_SOURCE ? Arrays.asList(spec.commonContext) : this.buildDeploymentContext(spec);
            OvfQueryResult ovfData = this._ovfDeployService.queryOvf(deploymentContext);
            if (ovfData.newContext == null || ovfData.newContext.size() == 0) {
                throw new RuntimeException("Failed to parse OVF.");
            }
            if (!ArrayUtil.isNullOrEmpty((List)ovfData.errors)) {
                throw new MethodFault(this._ovfErrorFormatter.format(ovfData.errors));
            }
            DeployOnResourcePoolValidationData data2 = new DeployOnResourcePoolValidationData();
            data2.newContext = new ArrayList<Object>(ovfData.newContext);
            data2.newWorkflowPath = ProvisioningServiceUtil.getWorkflowPath(data2.newContext, this._dataService);
            NameAndProductParams nameParam = (NameAndProductParams)CollectionUtil.getObjectByType(data2.newContext, NameAndProductParams.class);
            if (nameParam == null) {
                throw new RuntimeException("Unable to find NameAndProductParams in context.");
            }
            nameParam.setName(spec.name);
            ProvisioningServiceUtil.addNonConfigurableProperties(ovfData, data2.newContext);
            validationResult.result = data2;
        }
        catch (Exception e) {
            _logger.error((Object)("Failed instantiating template with spec: " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            validationResult.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return validationResult;
    }

    private List<Object> buildDeploymentContext(DeployOnResourcePoolValidationSpec spec) {
        Workflow workflow = (Workflow)CollectionUtil.getObjectByType((Object[])spec.commonContext, Workflow.class);
        if (workflow == null) {
            throw new IllegalArgumentException("Unable to find workflow in context.");
        }
        _logger.info((Object)("Initiate deployment of template on resource pool. template = " + ((URI)spec.template).toString()));
        List deploymentContext = this._ovfDeployService.newRpContext((URI)spec.template, spec.sourceType, spec.pushContentType, spec.pushOvfOption, (ManagedObjectReference)spec.provisioningTarget, (ManagedObjectReference)spec.host, (ManagedObjectReference)spec.folder, Arrays.asList(workflow));
        return deploymentContext;
    }

    public ValidationResult validate(ManagedObjectReference resource, StorageValidationSpec spec) {
        ValidationResult result = new ValidationResult();
        DatastoreMappingParams mapping = (DatastoreMappingParams)CollectionUtil.getObjectByType((List)spec.commonContext, DatastoreMappingParams.class);
        int systemGroupIndex = ProvisioningStorageUtil.findSystemDiskGroupIndex(spec.diskGroups);
        if (systemGroupIndex != -1) {
            DatastoreDiskGroup systemGroup = (DatastoreDiskGroup)spec.diskGroups.remove(systemGroupIndex);
            String targetStorageId = null;
            String uid = systemGroup.getTargetDatastore();
            if (!StringUtil.isNullOrEmpty((String)uid)) {
                ManagedObjectReference moRef = ManagedObjectUtil.stringToMoref((String)uid);
                targetStorageId = CisIdConverter.toGlobalCisId((ManagedObjectReference)moRef, (String)moRef.getServerGuid());
            }
            mapping.setTargetDatastore(targetStorageId);
            mapping.setTargetProvisioningType(systemGroup.getTargetProvisioningType());
            mapping.setTargetProfile(systemGroup.getTargetProfile());
        }
        for (DatastoreDiskGroup diskGroup : CollectionUtil.toSafeList((List)mapping.getDiskGroups())) {
            String targetDatastore;
            DatastoreDiskGroup userChoice = ProvisioningStorageUtil.findDiskGroupById(spec.diskGroups, diskGroup.getId());
            String string = targetDatastore = userChoice != null ? userChoice.getTargetDatastore() : null;
            if (!StringUtil.isNullOrEmpty((String)targetDatastore)) {
                ManagedObjectReference moRef = ManagedObjectUtil.stringToMoref((String)targetDatastore);
                targetDatastore = CisIdConverter.toGlobalCisId((ManagedObjectReference)moRef, (String)moRef.getServerGuid());
            }
            diskGroup.setTargetDatastore(targetDatastore);
            diskGroup.setTargetProfile(userChoice != null ? userChoice.getTargetProfile() : null);
            diskGroup.setTargetProvisioningType(userChoice != null ? userChoice.getTargetProvisioningType() : null);
        }
        result.result = spec.commonContext;
        return result;
    }
}

