/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.impl;

import com.vmware.vcenter.ovf.DatastoreDiskGroup;
import com.vmware.vcenter.ovf.DatastoreMappingParams;
import com.vmware.vcenter.ovf.DatastoreTarget;
import com.vmware.vcenter.ovf.DiskProvisioningType;
import com.vmware.vcenter.ovf.ScaleOutParams;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.provisioning.util.ProvisioningServiceUtil;
import com.vmware.vsphere.client.provisioning.util.ProvisioningStorageUtil;
import com.vmware.vsphere.client.util.collection.CollectionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningResourcePoolPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ProvisioningResourcePoolPropertyProvider.class);
    private static final String COMPUTE_RESOURCE_OWNER_PROPERTY = "owner";
    private static final String COMPUTE_RESOURCE_HOST_PROPERTY = "host";
    private static final String SERVER_GUID_PROPERTY = "serverGuid";
    private final DataService _dataService;

    public ProvisioningResourcePoolPropertyProvider(DataService dataService) {
        this._dataService = dataService;
        _logger.info((Object)"instantiated");
    }

    @ModelMetadata(type={"ResourcePool", "VirtualApp"}, propertyNamespace="vcde", property="parentComputeResource")
    public ManagedObjectReference getParentComputeResource(ManagedObjectReference resource) throws Exception {
        Object resultComputeResource = null;
        ManagedObjectReference computeResource = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)resource, (String)COMPUTE_RESOURCE_OWNER_PROPERTY);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)computeResource, ClusterComputeResource.class)) {
            resultComputeResource = computeResource;
        } else {
            Object[] host = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)computeResource, (String)COMPUTE_RESOURCE_HOST_PROPERTY);
            if (!ArrayUtil.isNullOrEmpty((Object[])host)) {
                resultComputeResource = host[0];
            }
        }
        return resultComputeResource;
    }

    @ModelMetadata(type={"ResourcePool", "VirtualApp"}, propertyNamespace="vcde", property="ovfDeployStorageMappings")
    public DatastoreMappingParams getOvfDeployStorageMappings(ManagedObjectReference resource, List<Object> context) throws Exception {
        DatastoreDiskGroup systemGroup;
        int systemGroupIndex;
        DatastoreMappingParams result = (DatastoreMappingParams)CollectionUtil.getObjectByType(context, DatastoreMappingParams.class);
        this.resolveStorageResourceTypes(result, resource);
        if (result == null) {
            return null;
        }
        result.setTargetDatastore(null);
        if (result.getDiskGroups() == null) {
            result.setDiskGroups(new ArrayList());
        }
        if ((systemGroupIndex = ProvisioningStorageUtil.findSystemDiskGroupIndex(result.getDiskGroups())) == -1) {
            systemGroup = this.createSystemDiskGroup(result);
            result.getDiskGroups().add(systemGroup);
        } else {
            systemGroup = (DatastoreDiskGroup)result.getDiskGroups().get(systemGroupIndex);
        }
        for (DatastoreDiskGroup diskGroup : result.getDiskGroups()) {
            if (diskGroup.getId() == "ngcArtificialSystemDiskGroup") continue;
            if (StringUtil.isNullOrEmpty((String)diskGroup.getTargetDatastore())) {
                diskGroup.setTargetDatastore(systemGroup.getTargetDatastore());
            }
            if (diskGroup.getTargetProfile() == null) {
                diskGroup.setTargetProfile(systemGroup.getTargetProfile());
            }
            if (diskGroup.getTargetProvisioningType() != null) continue;
            diskGroup.setTargetProvisioningType(systemGroup.getTargetProvisioningType());
        }
        return result;
    }

    @ModelMetadata(type={"com.vmware.vsphere.client.provisioning.Context"}, propertyNamespace="vcde", property="ovfScaleOutParameters")
    public ScaleOutParams getOvfScaleOutParameters(URI resource, List<Object> context) {
        ScaleOutParams params = (ScaleOutParams)CollectionUtil.getObjectByType(context, ScaleOutParams.class);
        return params;
    }

    private DatastoreDiskGroup createSystemDiskGroup(DatastoreMappingParams params) {
        DatastoreDiskGroup sample;
        DatastoreDiskGroup result = new DatastoreDiskGroup();
        result.setId("ngcArtificialSystemDiskGroup");
        result.setName(ProvisioningServiceUtil.getLocalizedString("diskGroup.systemGroup.name"));
        result.setDescription(ProvisioningServiceUtil.getLocalizedString("diskGroup.systemGroup.description"));
        if (!StringUtil.isNullOrEmpty((String)params.getTargetDatastore())) {
            result.setTargetDatastore(params.getTargetDatastore());
            result.setTargetProfile(params.getTargetProfile());
        } else if (!ArrayUtil.isNullOrEmpty((List)params.getDiskGroups())) {
            sample = (DatastoreDiskGroup)params.getDiskGroups().get(0);
            result.setTargetDatastore(sample.getTargetDatastore());
            String targetProfile = sample.getTargetProfile();
            result.setTargetProfile(targetProfile == null ? "" : targetProfile);
        } else if (!ArrayUtil.isNullOrEmpty((List)params.getAvailableDatastores())) {
            result.setTargetDatastore(((DatastoreTarget)params.getAvailableDatastores().get(0)).getId());
            result.setTargetProfile("");
        }
        if (params.getTargetProvisioningType() != null) {
            result.setTargetProvisioningType(params.getTargetProvisioningType());
        } else if (!ArrayUtil.isNullOrEmpty((List)params.getDiskGroups())) {
            sample = (DatastoreDiskGroup)params.getDiskGroups().get(0);
            result.setTargetProvisioningType(sample.getTargetProvisioningType());
        } else if (!ArrayUtil.isNullOrEmpty((List)params.getAvailableDiskProvisioningTypes())) {
            result.setTargetProvisioningType((DiskProvisioningType)params.getAvailableDiskProvisioningTypes().get(0));
        }
        return result;
    }

    private void resolveStorageResourceTypes(DatastoreMappingParams storageMappings, ManagedObjectReference targetRp) throws Exception {
        List availableStorage;
        ResultItem[] items;
        PropertyConstraint pcSp;
        HashMap<String, String> globalCisIdToMor = new HashMap<String, String>();
        String serverGuid = targetRp.getServerGuid();
        PropertyConstraint pcDs = QueryUtil.createPropertyConstraint((String)Datastore.class.getSimpleName(), (String)SERVER_GUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)serverGuid);
        Constraint targetStorage = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{pcDs, pcSp = QueryUtil.createPropertyConstraint((String)StoragePod.class.getSimpleName(), (String)SERVER_GUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)serverGuid)}, (Conjoiner)Conjoiner.OR);
        QuerySpec qs = QueryUtil.buildQuerySpec((Constraint)targetStorage, (String[])new String[0]);
        ResultSet rs = QueryUtil.getData((DataService)this._dataService, (QuerySpec)qs);
        if (rs != null && (items = rs.items) != null && items.length > 0 && items[0] != null) {
            for (ResultItem item : items) {
                ManagedObjectReference moRef;
                if (item == null || (moRef = (ManagedObjectReference)item.resourceObject) == null) continue;
                String globalCisId = CisIdConverter.toGlobalCisId((ManagedObjectReference)moRef, (String)moRef.getServerGuid());
                String cisId = ManagedObjectUtil.morefToString((ManagedObjectReference)moRef);
                globalCisIdToMor.put(globalCisId, cisId);
            }
        }
        if ((availableStorage = storageMappings.getAvailableDatastores()) != null) {
            for (DatastoreTarget ds : availableStorage) {
                String cisId = (String)globalCisIdToMor.get(ds.getId());
                if (cisId == null) continue;
                ds.setId(cisId);
            }
        }
        String cisId = (String)globalCisIdToMor.get(storageMappings.getTargetDatastore());
        storageMappings.setTargetDatastore(cisId);
        List dgroups = storageMappings.getDiskGroups();
        if (dgroups != null) {
            for (DatastoreDiskGroup dg : dgroups) {
                String dgCisId = (String)globalCisIdToMor.get(dg.getTargetDatastore());
                dg.setTargetDatastore(dgCisId);
            }
        }
    }
}

