/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.provisioning.util;

import com.vmware.vsphere.client.provisioning.spec.AuthenticationRequirement;
import com.vmware.vsphere.client.provisioning.spec.HttpResourceProbeResult;
import com.vmware.vsphere.client.provisioning.spec.ProbeStatus;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpResourceProber {
    private static final Log _logger = LogFactory.getLog(HttpResourceProber.class);
    private static final String HEADER_NAME_AUTHENTICATE = "www-authenticate";
    private static final String HEADER_ELEM_BASIC_REALM = "basic realm";
    private static final Set<String> SUPPORTED_SOURCE_SCHEMES = new HashSet<String>();
    private final HttpClient _client;
    private final ProtocolSocketFactory _secureSocketFactory;
    private final ProtocolSocketFactory _defaultSocketFactory;
    private final MultiThreadedHttpConnectionManager _connectionManager = new MultiThreadedHttpConnectionManager();
    private final HttpMethodRetryHandler _retryHandler;

    public static HttpResourceProber newInstance() {
        return new HttpResourceProber(null);
    }

    public static HttpResourceProber newInstance(KeyStore trustStore) {
        Validate.notNull((Object)trustStore, (String)"Trust store is null");
        return new HttpResourceProber(trustStore);
    }

    private HttpResourceProber(KeyStore trustStore) {
        this._connectionManager.getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 1);
        this._connectionManager.getParams().setStaleCheckingEnabled(true);
        this._client = new HttpClient((HttpConnectionManager)this._connectionManager);
        this._secureSocketFactory = this.createSecureSocketFactory(trustStore);
        this._defaultSocketFactory = new DefaultProtocolSocketFactory();
        this._retryHandler = new DefaultHttpMethodRetryHandler(1, false);
    }

    public int getTimeout() {
        return this._client.getHttpConnectionManager().getParams().getConnectionTimeout();
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this._client.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
    }

    public HttpResourceProbeResult probe(URI target) throws Exception {
        String[] credentials;
        Validate.notNull((Object)target, (String)"target is null");
        if (target.getUserInfo() != null && (credentials = StringUtils.split((String)target.getUserInfo(), (String)":")) != null && credentials.length == 2) {
            HttpResourceProbeResult result = this.probe(target, credentials[0], credentials[1]);
            return result;
        }
        HttpResourceProbeResult result = this.executeProbe(target, null);
        return result;
    }

    public HttpResourceProbeResult probe(URI target, String username, String password) throws Exception {
        Validate.notNull((Object)target, (String)"target is null");
        Validate.notNull((Object)username, (String)"username is null");
        Validate.notNull((Object)password, (String)"password is null");
        String credentials = username + ':' + password;
        byte[] credentialBytes = credentials.getBytes(Charset.forName("UTF-8"));
        String encodedCredentials = Base64.encodeBase64String((byte[])credentialBytes);
        Header authHeader = new Header("Authorization", "Basic " + encodedCredentials);
        HttpResourceProbeResult result = this.executeProbe(target, authHeader);
        return result;
    }

    private ProtocolSocketFactory createSecureSocketFactory(KeyStore keyStore) {
        try {
            return new ProbingSocketFactory(keyStore);
        }
        catch (Exception ex) {
            _logger.error((Object)"Exception creating socket factory - probing not possible.", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResourceProbeResult executeProbe(URI source, Header requestHeader) throws Exception {
        assert (source != null) : "null source";
        if (!SUPPORTED_SOURCE_SCHEMES.contains(source.getScheme())) {
            throw new IllegalArgumentException("Unsupported source scheme " + source.getScheme());
        }
        HeadMethod request = new HeadMethod(source.getRawPath());
        if (requestHeader != null) {
            request.setRequestHeader(requestHeader);
        }
        request.getParams().setParameter("http.protocol.reject-head-body", (Object)true);
        request.getParams().setParameter("http.method.retry-handler", (Object)this._retryHandler);
        HostConfiguration hostConfig = this.getHostConfig(source);
        HttpResourceProbeResult result = new HttpResourceProbeResult();
        try {
            result.responseCode = this._client.executeMethod(hostConfig, (HttpMethod)request);
            result.authenticationRequirement = this.getAuthRequirement((HttpMethod)request);
            result.status = ProbeStatus.SUCCESS;
        }
        catch (Throwable ex) {
            result.status = this.processException(ex);
            result.authenticationRequirement = AuthenticationRequirement.UNKNOWN;
            _logger.debug((Object)("Exception probing " + source + ". The resulting status is " + (Object)((Object)result.status) + " and the exception is " + ex.getClass().getName()));
        }
        finally {
            request.releaseConnection();
        }
        return result;
    }

    private ProbeStatus processException(Throwable ex) {
        assert (ex != null) : "null exception";
        Class<?> exClass = ex.getClass();
        if (HttpException.class.isAssignableFrom(exClass)) {
            _logger.error((Object)"Unexpected probe error", ex);
            return ProbeStatus.FAILURE;
        }
        if (UnknownHostException.class.equals(exClass)) {
            return ProbeStatus.UNKNOWN_HOST;
        }
        if (IllegalArgumentException.class.equals(exClass)) {
            return ProbeStatus.INVALID_SOURCE;
        }
        if (SocketTimeoutException.class.equals(exClass) || ConnectTimeoutException.class.equals(exClass)) {
            return ProbeStatus.TIMEOUT;
        }
        if (SSLException.class.isAssignableFrom(exClass)) {
            return ProbeStatus.SSL_ERROR;
        }
        if (IOException.class.isAssignableFrom(exClass)) {
            return ProbeStatus.IO_ERROR;
        }
        _logger.warn((Object)("Unhandled probe exception: " + exClass));
        return ProbeStatus.FAILURE;
    }

    private HostConfiguration getHostConfig(URI source) {
        ProtocolSocketFactory socketFactory = this.getSocketFactoryFor(source);
        Protocol protocol = new Protocol(source.getScheme(), socketFactory, this.getDefaultPort(source));
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(source.getHost(), source.getPort(), protocol);
        return hostConfig;
    }

    private ProtocolSocketFactory getSocketFactoryFor(URI source) {
        if ("http".equals(source.getScheme())) {
            return this._defaultSocketFactory;
        }
        assert ("https".equals(source.getScheme())) : "Unexpected " + source.getScheme();
        if (this._secureSocketFactory == null) {
            _logger.error((Object)("Unable to probe " + source + " because the secure socket factory is not initialized"));
            throw new IllegalStateException("Socket factory is not initialized");
        }
        return this._secureSocketFactory;
    }

    private int getDefaultPort(URI source) {
        if ("http".equals(source.getScheme())) {
            return 80;
        }
        if ("https".equals(source.getScheme())) {
            return 443;
        }
        throw new AssertionError((Object)("Unsupported source scheme " + source.getScheme()));
    }

    private AuthenticationRequirement getAuthRequirement(HttpMethod executedMethod) {
        HeaderElement[] authValue = this.getAuthenticateHeader(executedMethod);
        if (authValue.length == 0) {
            return AuthenticationRequirement.NONE;
        }
        for (HeaderElement headerElement : authValue) {
            if (!HEADER_ELEM_BASIC_REALM.equalsIgnoreCase(headerElement.getName())) continue;
            return AuthenticationRequirement.BASIC;
        }
        return AuthenticationRequirement.OTHER;
    }

    private HeaderElement[] getAuthenticateHeader(HttpMethod executedMethod) {
        Header[] responseHeaders;
        for (Header header : responseHeaders = executedMethod.getResponseHeaders()) {
            if (!HEADER_NAME_AUTHENTICATE.equalsIgnoreCase(header.getName())) continue;
            return header.getElements();
        }
        return new HeaderElement[0];
    }

    static {
        SUPPORTED_SOURCE_SCHEMES.add("http");
        SUPPORTED_SOURCE_SCHEMES.add("https");
    }

    private static class ProbingTrustManager
    implements X509TrustManager {
        private static final Log _logger = LogFactory.getLog(ProbingTrustManager.class);

        public ProbingTrustManager(KeyStore trustStore) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            throw new NotImplementedException("checkClientTrusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            _logger.debug((Object)"All certificates trusted");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class ProbingSocketFactory
    implements SecureProtocolSocketFactory {
        private static final Log _logger = LogFactory.getLog(ProbingSocketFactory.class);
        private final SSLContext _sslContext;
        private final TrustManager _certificateProber;

        public ProbingSocketFactory(KeyStore trustStore) throws Exception {
            this._certificateProber = new ProbingTrustManager(trustStore);
            try {
                this._sslContext = SSLContext.getInstance("SSL");
                this._sslContext.init(null, new TrustManager[]{this._certificateProber}, null);
            }
            catch (Exception error) {
                _logger.error((Object)("Exception creating SSL context " + error));
                throw error;
            }
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            return this._sslContext.getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
            Validate.notNull((Object)params, (String)"http connection params null");
            int timeout = params.getConnectionTimeout();
            SSLSocketFactory socketfactory = this._sslContext.getSocketFactory();
            if (timeout == 0) {
                return socketfactory.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this._sslContext.getSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this._sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        }
    }
}

