/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.client.aggregator;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.ImmutableChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregatingChangeLog
implements ChangeLog {
    private static final Logger _logger = LoggerFactory.getLogger(AggregatingChangeLog.class);
    private static final char SEQUENCE_AGGREGATION_SEPARATOR = '|';
    private final List<ChangeLog> _standaloneChangeLogs;
    private final long _executionThreshold;

    public AggregatingChangeLog(Collection<ChangeLog> changeLogs, long executionThreshold) {
        Validate.notEmpty(changeLogs, (String)"At least one changeLog is required for aggregation.");
        Validate.isTrue((executionThreshold > 0L ? 1 : 0) != 0, (String)"Execution threshold value must be a positive integer.");
        this._standaloneChangeLogs = new ArrayList<ChangeLog>(changeLogs);
        this._executionThreshold = executionThreshold;
    }

    @Override
    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        Validate.notNull((Object)sequenceToken, (String)"The sequenceToken is required.");
        String[] currentSequences = StringUtils.splitPreserveAllTokens((String)sequenceToken, (char)'|');
        if (currentSequences.length != this._standaloneChangeLogs.size()) {
            throw new IllegalArgumentException("Invalid sequenceToken: " + sequenceToken);
        }
        ArrayList<String> newSequences = new ArrayList<String>(this._standaloneChangeLogs.size());
        ArrayList<ChangeEvent> changes = new ArrayList<ChangeEvent>();
        for (int i = 0; i < this._standaloneChangeLogs.size(); ++i) {
            ChangeLog changeLog = this._standaloneChangeLogs.get(i);
            String currentSequenceToken = currentSequences[i];
            if (StringUtils.isEmpty((String)currentSequenceToken)) {
                String newSequence = this.tryGetCurrentSequence(changeLog);
                newSequences.add(newSequence);
                continue;
            }
            ChangeList changeList = this.tryGetChanges(changeLog, currentSequenceToken);
            newSequences.add(changeList.getSequence());
            changes.addAll(changeList.getChanges());
        }
        String aggregatorSequence = StringUtils.join(newSequences, (char)'|');
        return new ImmutableChangeList(aggregatorSequence, changes);
    }

    @Override
    public String getCurrentSequence() {
        ArrayList<String> sequences = new ArrayList<String>(this._standaloneChangeLogs.size());
        for (ChangeLog changeLog : this._standaloneChangeLogs) {
            String currentSequence = this.tryGetCurrentSequence(changeLog);
            sequences.add(currentSequence);
        }
        return StringUtils.join(sequences, (char)'|');
    }

    private String tryGetCurrentSequence(ChangeLog changeLog) {
        try {
            long startTime = System.currentTimeMillis();
            String currentSequence = changeLog.getCurrentSequence();
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (elapsedTime > this._executionThreshold) {
                _logger.warn("Slow execution detected while retrieving current sequence from {}: {} ms", (Object)changeLog, (Object)elapsedTime);
            }
            return currentSequence;
        }
        catch (RuntimeException e) {
            String msg = "Error while retrieving current sequence from {}: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, (Object)changeLog, (Object)e);
            } else {
                _logger.warn(msg + e.getMessage(), (Object)changeLog);
            }
            return "";
        }
    }

    private ChangeList tryGetChanges(ChangeLog changeLog, String currentSequenceToken) throws SequenceExpiredException {
        try {
            long startTime = System.currentTimeMillis();
            ChangeList changeList = changeLog.getChanges(currentSequenceToken);
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (elapsedTime > this._executionThreshold) {
                _logger.warn("Slow execution detected while reading changes from {} for token {}: {} ms", new Object[]{changeLog, currentSequenceToken, elapsedTime});
            }
            return changeList;
        }
        catch (RuntimeException e) {
            String msg = "Error while reading changes from {} for token {}: ";
            if (_logger.isDebugEnabled()) {
                _logger.debug(msg, new Object[]{changeLog, currentSequenceToken, e});
            } else {
                _logger.warn(msg + e.getMessage(), new Object[]{changeLog, currentSequenceToken});
            }
            return new ImmutableChangeList(currentSequenceToken, Collections.emptyList());
        }
    }
}

