/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.cdc.vcenter.ResourceChange;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChangeObserver {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeObserver.class);
    private final ResourceChangeListener _resourceChangeListener;
    private final AlarmChangeListener _alarmChangeListener;
    private final ChangeLogCollector.ChangeLog[] _subscribedChangeLogs;

    ChangeObserver(ListenerSpec listenerSpec) {
        assert (listenerSpec != null);
        assert (listenerSpec.getResourceChangeListenerToAdd() != null || listenerSpec.getAlarmChangeListenerToAdd() != null) : "No change listeners provided";
        this._resourceChangeListener = listenerSpec.getResourceChangeListenerToAdd();
        this._alarmChangeListener = listenerSpec.getAlarmChangeListenerToAdd();
        this._subscribedChangeLogs = ChangeObserver.calculateSubscribedChangeLogs(this._resourceChangeListener, this._alarmChangeListener);
    }

    ChangeLogCollector.ChangeLog[] getSubscribedChangeLogs() {
        return this._subscribedChangeLogs;
    }

    void notifyForChanges(ChangeNotifier changeNotifier, ChangeSet changeSet) {
        assert (changeNotifier != null);
        assert (changeSet != null);
        this.notifyForResourceChanges(changeNotifier, changeSet.getResourceChanges());
        this.notifyForAlarmChanges(changeNotifier, changeSet.getAlarmChanges());
    }

    void notifyFatalError(ChangeNotifier changeNotifier, IllegalStateException error) {
        assert (changeNotifier != null);
        assert (error != null);
        if (this._resourceChangeListener != null) {
            try {
                this._resourceChangeListener.onError(changeNotifier, error);
            }
            catch (RuntimeException e) {
                _logger.error("Error while notifying '{}' for error: {}", (Object)this._resourceChangeListener, (Object)e);
            }
        }
        if (this._alarmChangeListener != null) {
            try {
                this._alarmChangeListener.onError(changeNotifier, error);
            }
            catch (RuntimeException e) {
                _logger.error("Error while notifying '{}' for error: {}", (Object)this._alarmChangeListener, (Object)e);
            }
        }
    }

    private void notifyForResourceChanges(ChangeNotifier changeNotifier, Collection<ResourceChange> resourceChanges) {
        assert (changeNotifier != null);
        assert (resourceChanges != null);
        if (this._resourceChangeListener == null || resourceChanges.isEmpty()) {
            return;
        }
        try {
            _logger.trace("Notifying listener '{}' for resource changes: {}", (Object)this._resourceChangeListener, resourceChanges);
            this._resourceChangeListener.onChanges(changeNotifier, resourceChanges);
            _logger.trace("Notified listener '{}' for resource changes.", (Object)this._resourceChangeListener);
        }
        catch (RuntimeException e) {
            _logger.error("Error while notifying '{}' for resource changes: {}", (Object)this._resourceChangeListener, (Object)e);
        }
    }

    private void notifyForAlarmChanges(ChangeNotifier changeNotifier, Collection<AlarmChange> alarmChanges) {
        assert (changeNotifier != null);
        assert (alarmChanges != null);
        if (this._alarmChangeListener == null || alarmChanges.isEmpty()) {
            return;
        }
        try {
            _logger.trace("Notifying listener '{}' for alarm state changes: {}", (Object)this._alarmChangeListener, alarmChanges);
            this._alarmChangeListener.onChanges(changeNotifier, alarmChanges);
            _logger.trace("Notified listener '{}' for alarm state changes.", (Object)this._alarmChangeListener);
        }
        catch (RuntimeException e) {
            _logger.error("Error while notifying '{}' for alarm state changes: {}", (Object)this._alarmChangeListener, (Object)e);
        }
    }

    private static ChangeLogCollector.ChangeLog[] calculateSubscribedChangeLogs(ResourceChangeListener resourceChangeListener, AlarmChangeListener alarmChangeListener) {
        ArrayList<ChangeLogCollector.ChangeLog> subscribedChangeLogs = new ArrayList<ChangeLogCollector.ChangeLog>();
        if (resourceChangeListener != null) {
            subscribedChangeLogs.add(ChangeLogCollector.ChangeLog.RESOURCE);
        }
        if (alarmChangeListener != null) {
            subscribedChangeLogs.add(ChangeLogCollector.ChangeLog.ALARM_STATUS);
        }
        return subscribedChangeLogs.toArray(new ChangeLogCollector.ChangeLog[subscribedChangeLogs.size()]);
    }
}

