/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.internal.vcenter.ChangeSet;
import com.vmware.cdc.internal.vcenter.listener.ChangeObserver;
import com.vmware.cdc.internal.vcenter.listener.ListenerSpec;
import com.vmware.cdc.vcenter.listener.ChangeNotifier;
import com.vmware.cdc.vcenter.listener.ListenerSpecBuilder;
import com.vmware.vapi.CoreException;
import com.vmware.vapi.client.exception.SslException;
import com.vmware.vapi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeStream
implements ChangeNotifier {
    private static final Logger _logger = LoggerFactory.getLogger(ChangeStream.class);
    private final String _serviceName;
    private final ChangeLogCollector _changeLogCollector;
    private final ExecutorService _pollingExecutor;
    private final long _pollingInterval;
    private static final byte BACKOFF_RETRY_COUNT = 15;
    private Future<?> _pollingTask = null;

    public ChangeStream(String serviceName, ChangeLogCollector changeLogCollector, ExecutorService pollingExecutor, long pollingInterval) {
        assert (serviceName != null);
        assert (changeLogCollector != null);
        assert (pollingExecutor != null);
        assert (pollingInterval > 0L);
        this._serviceName = serviceName;
        this._changeLogCollector = changeLogCollector;
        this._pollingExecutor = pollingExecutor;
        this._pollingInterval = pollingInterval;
    }

    @Override
    public ListenerSpecBuilder listeners() {
        return new ListenerSpecBuilder(this);
    }

    public synchronized void commit(final ListenerSpec listenerSpec) {
        if (this._pollingTask != null) {
            throw new UnsupportedOperationException("Not possible to call commit more than once");
        }
        _logger.debug("[{}] Starting polling for changes", (Object)this._serviceName);
        this._pollingTask = this._pollingExecutor.submit(new Runnable(){

            @Override
            public void run() {
                _logger.info("[{}] Started polling for changes on topics [{}]", (Object)ChangeStream.this._serviceName, (Object)Arrays.toString((Object[])listenerSpec.getChangeLogsToAdd()));
                ChangeStream.this.pollChangesTask(listenerSpec);
                _logger.info("[{}] Stopped polling for changes on topics [{}]", (Object)ChangeStream.this._serviceName, (Object)Arrays.toString((Object[])listenerSpec.getChangeLogsToAdd()));
            }

            public String toString() {
                return ChangeStream.this._serviceName;
            }
        });
    }

    @Override
    public synchronized void close() {
        if (this._pollingTask != null) {
            _logger.debug("[{}] Stopping polling for changes", (Object)this._serviceName);
            this._pollingTask.cancel(true);
            this._pollingTask = null;
        }
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this._serviceName);
    }

    private void pollChangesTask(ListenerSpec listenerSpec) {
        String sequenceToken = null;
        int connectionErrors = 0;
        ChangeObserver changeObserver = new ChangeObserver(listenerSpec);
        ChangeLogCollector.ChangeLog[] subscribedChangeLogs = changeObserver.getSubscribedChangeLogs();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (sequenceToken == null) {
                    _logger.debug("[{}] Sync current sequence for change logs [{}]", (Object)this._serviceName, (Object)Arrays.toString((Object[])subscribedChangeLogs));
                    sequenceToken = this._changeLogCollector.initializeSequence(subscribedChangeLogs);
                    _logger.debug("[{}] Synced current sequence for change logs [{}] to [{}]", new Object[]{this._serviceName, subscribedChangeLogs, sequenceToken});
                } else {
                    _logger.debug("[{}] Get changes for sequence {}", (Object)this._serviceName, sequenceToken);
                    ChangeSet changeSet = this._changeLogCollector.waitForChanges(sequenceToken);
                    _logger.debug("[{}] Received [{}] ResourceChanges and [{}] AlarmChanges for sequence {}", new Object[]{this._serviceName, changeSet.getResourceChanges().size(), changeSet.getAlarmChanges().size(), sequenceToken});
                    if (_logger.isTraceEnabled()) {
                        _logger.trace("[{}] Received changes for sequence {}: {}", new Object[]{this._serviceName, sequenceToken, changeSet});
                    }
                    sequenceToken = changeSet.getSequence();
                    if (!Thread.currentThread().isInterrupted()) {
                        changeObserver.notifyForChanges(this, changeSet);
                    } else {
                        return;
                    }
                }
                connectionErrors = 0;
                Thread.sleep(this._pollingInterval);
            }
            catch (InterruptedException ie) {
                _logger.debug("[{}] Polling for changes was interrupted: {} {}", new Object[]{this._serviceName, ie.getClass().getName(), ie.getMessage(), ie});
                return;
            }
            catch (SequenceExpiredException e) {
                _logger.error("[{}] Polling changes terminated because the sequence token [{}] has expired: {} {}", new Object[]{this._serviceName, sequenceToken, e.getClass().getName(), e.getMessage(), e});
                changeObserver.notifyFatalError(this, new IllegalStateException("Changes lost because of an expired sequence token, please re-subscribe", e));
                return;
            }
            catch (Exception e) {
                if (connectionErrors < 15 && ChangeStream.exceptionIndicatesTemporaryError(e)) {
                    connectionErrors = (byte)(connectionErrors + 1);
                    try {
                        this.backOffOnTemporaryError(connectionErrors, e);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        _logger.debug("[{}] Retry of polling for changes was interrupted: {} {}", new Object[]{this._serviceName, ie.getClass().getName(), ie.getMessage(), ie});
                        return;
                    }
                }
                _logger.error("[{}] Polling for changes terminated because of an unexpected error: {} {}", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), e});
                changeObserver.notifyFatalError(this, new IllegalStateException("Polling for changes terminated because of an unexpected error, please re-subscribe", e));
                return;
            }
            catch (Throwable t) {
                _logger.error("[{}] Polling for changes terminated because of an internal error", (Object)this._serviceName, (Object)t);
                throw t;
            }
        }
    }

    private static boolean exceptionIndicatesTemporaryError(Exception e) {
        if (e instanceof UnexpectedStatusCodeException) {
            return ((UnexpectedStatusCodeException)e).getStatusCode() == 503;
        }
        if (e instanceof ConnectionException) {
            return e.getCause() instanceof SocketTimeoutException;
        }
        if (e instanceof com.vmware.vim.vmomi.client.exception.TransportProtocolException) {
            return e.getCause() instanceof NoHttpResponseException;
        }
        if (e instanceof TransportProtocolException) {
            return !(e instanceof SslException) && !(e.getCause() instanceof UnknownHostException) && !(e.getCause() instanceof InterruptedIOException) && !(e.getCause() instanceof HttpException) && !(e.getCause() instanceof ParseException) && !(e.getCause() instanceof CoreException);
        }
        return false;
    }

    private void backOffOnTemporaryError(int connectionErrors, Exception e) throws InterruptedException {
        long backOffTimeSec = connectionErrors < 5 ? 5L : (connectionErrors < 10 ? 10L : 30L);
        _logger.info("[{}] Connection error while reading changes: {} {}. Will retry after {} seconds.", new Object[]{this._serviceName, e.getClass().getName(), e.getMessage(), backOffTimeSec});
        _logger.debug("", (Throwable)e);
        Thread.sleep(TimeUnit.SECONDS.toMillis(backOffTimeSec));
    }
}

