/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.vcenter.listener;

import com.vmware.cdc.internal.vcenter.ChangeLogCollector;
import com.vmware.cdc.vcenter.listener.AlarmChangeListener;
import com.vmware.cdc.vcenter.listener.ResourceChangeListener;
import java.util.ArrayList;

public final class ListenerSpec {
    private final ResourceChangeListener _resourceListenerToAdd;
    private final ResourceChangeListener _resourceListenerToRemove;
    private final AlarmChangeListener _alarmListenerToAdd;
    private final AlarmChangeListener _alarmListenerToRemove;

    public ListenerSpec(ResourceChangeListener resourceListenerToAdd, ResourceChangeListener resourceListenerToRemove, AlarmChangeListener alarmListenerToAdd, AlarmChangeListener alarmListenerToRemove) {
        assert (resourceListenerToAdd != null || alarmListenerToAdd != null || resourceListenerToRemove != null || alarmListenerToRemove != null) : "No change listeners provided";
        this._resourceListenerToAdd = resourceListenerToAdd;
        this._resourceListenerToRemove = resourceListenerToRemove;
        this._alarmListenerToAdd = alarmListenerToAdd;
        this._alarmListenerToRemove = alarmListenerToRemove;
    }

    ResourceChangeListener getResourceChangeListenerToAdd() {
        return this._resourceListenerToAdd;
    }

    ResourceChangeListener getResourceChangeListenerToRemove() {
        return this._resourceListenerToRemove;
    }

    AlarmChangeListener getAlarmChangeListenerToAdd() {
        return this._alarmListenerToAdd;
    }

    AlarmChangeListener getAlarmChangeListenerToRemove() {
        return this._alarmListenerToRemove;
    }

    ChangeLogCollector.ChangeLog[] getChangeLogsToAdd() {
        ArrayList<ChangeLogCollector.ChangeLog> changeLogs = new ArrayList<ChangeLogCollector.ChangeLog>();
        if (this._resourceListenerToAdd != null) {
            changeLogs.add(ChangeLogCollector.ChangeLog.RESOURCE);
        }
        if (this._alarmListenerToAdd != null) {
            changeLogs.add(ChangeLogCollector.ChangeLog.ALARM_STATUS);
        }
        return changeLogs.toArray(new ChangeLogCollector.ChangeLog[changeLogs.size()]);
    }

    ChangeLogCollector.ChangeLog[] getChangeLogsToRemove() {
        ArrayList<ChangeLogCollector.ChangeLog> changeLogs = new ArrayList<ChangeLogCollector.ChangeLog>();
        if (this._resourceListenerToRemove != null) {
            changeLogs.add(ChangeLogCollector.ChangeLog.RESOURCE);
        }
        if (this._alarmListenerToRemove != null) {
            changeLogs.add(ChangeLogCollector.ChangeLog.ALARM_STATUS);
        }
        return changeLogs.toArray(new ChangeLogCollector.ChangeLog[changeLogs.size()]);
    }
}

