/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaCMProvider
implements PropertyProviderBean {
    private static final String OPTION_KEY_VC_HOSTNAME = "config.vpxd.hostnameUrl";
    private static final String TYPE_SERVER = "cm:Server";
    private static final String PROPERTY_SERVER_CM = "cm.service.getCmServer";
    private static final String PROPERTY_SERVER_HOSTNAME = "name";
    private static final Log _logger = LogFactory.getLog(VchaCMProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public VchaCMProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="Folder")
    public URI getVchaVcNodeUri(ManagedObjectReference rootFolderRef) throws Exception {
        String hostname;
        try {
            hostname = (String)VchaUtil.getVcOption(rootFolderRef, OPTION_KEY_VC_HOSTNAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieving the vCenter host name.");
            _logger.error((Object)e);
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)hostname)) {
            _logger.warn((Object)"Host name is empty.");
            return null;
        }
        PropertyConstraint serverUriConstraint = this._querySpecBuilder.createPropertyConstraint(TYPE_SERVER, PROPERTY_SERVER_HOSTNAME, Comparator.EQUALS, (Object)hostname);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)serverUriConstraint, new String[]{PROPERTY_SERVER_CM});
        ResultSet result = this._queryExecutor.getData(query);
        if (result == null || result.error != null || ArrayUtil.isNullOrEmpty((Object[])result.items) || result.items[0].resourceObject == null) {
            _logger.warn((Object)"Unable to retrieve the CM URL");
            return null;
        }
        URI vcServerNodeUri = (URI)result.items[0].resourceObject;
        return vcServerNodeUri;
    }
}

