/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vcha.FailoverClusterManager;
import com.vmware.vim.binding.vim.vm.customization.FixedIp;
import com.vmware.vim.binding.vim.vm.customization.FixedIpV6;
import com.vmware.vim.binding.vim.vm.customization.IPSettings;
import com.vmware.vim.binding.vim.vm.customization.IpV6Generator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.cloudvm.DnsServerConfig;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vsphere.client.vcha.model.VchaClusterVmInfo;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaMockDataProvider {
    public static final String MOCK_DATA_USE = "vcha.use.mockdata";
    public static final String MOCK_DATA_EXTERNAL_FILE_LOCATION = "vcha.mockdata.file.location";
    public static final String MPK_CLUSTER_MODE = "vchaClusterMode";
    public static final String MPK_CLUSTER_HEALTH = "vchaClusterHealth";
    public static final String MPK_CLUSTER_CONFIG = "vchaClusterConfig";
    public static final String MPK_SUPPORTED = "vchaIsSupported";
    public static final String MPK_EMBEDDED_DB_USE = "vchaIsEmbeddedDbInUse";
    public static final String MPK_ON_CLOUDVM = "vchaIsOnCloudVm";
    public static final String MPK_ON_MGMTNODE = "vchaIsExternalInfraNodeInUse";
    public static final String MPK_CLOUDVM_SINGLE_DOMAIN = "vchaCloudVmSingleDomain";
    public static final String MPK_CLUSTER_VM_SINGLE_DOMAIN = "vchaClusterVmSingleDomain";
    public static final String MPK_GUESTOS_NETINFO = "vchaGuestOsNetworkInfo";
    public static final String MPK_DISABLED_METHODS = "vchaDisabledMethods";
    public static final String MMOK_CONFIGURE = "vchaOpConfigure";
    public static final String MMOK_MANAGE = "vchaOpManage";
    public static final String MMOK_FAILOVER = "vchaOpFailover";
    public static final String MMOK_DEPLOY = "vchaOpDeploy";
    private static final String USE_REAL = "vcha.mockdata.use.real";
    private static final String MOCK_DATA_DISABLED_METHODS = "vcha.mockdata.api.disableMethods";
    private static final String MOCK_DATA_COMPAT_IS_SUPPORTED = "vcha.mockdata.compatibility.isSupported";
    private static final String MOCK_DATA_COMPAT_EMBEDDED_DB = "vcha.mockdata.compatibility.isEmbeddedDbInUse";
    private static final String MOCK_DATA_COMPAT_ON_CLOUDVM = "vcha.mockdata.compatibility.isOnCloudVm";
    private static final String MOCK_DATA_COMPAT_ON_MGMTNODE = "vcha.mockdata.compatibility.isOnManagementNode";
    private static final String MOCK_DATA_ACTIVE_VM_UUID = "vcha.mockdata.node.active.vm.biosUuid";
    private static final String MOCK_DATA_PASSIVE_VM_UUID = "vcha.mockdata.node.passive.vm.biosUuid";
    private static final String MOCK_DATA_WITNESS_VM_UUID = "vcha.mockdata.node.witness.vm.biosUuid";
    private static final String MOCK_DATA_ACTIVE_VM = "vcha.mockdata.node.active.vm";
    private static final String MOCK_DATA_PASSIVE_VM = "vcha.mockdata.node.passive.vm";
    private static final String MOCK_DATA_WITNESS_VM = "vcha.mockdata.node.witness.vm";
    private static final String MOCK_DATA_CLUSTER_MODE = "vcha.mockdata.cluster.mode";
    private static final String MOCK_DATA_CLUSTER_HEALTH = "vcha.mockdata.cluster.health.status";
    private static final String MOCK_DATA_ACTIVE_STATUS = "vcha.mockdata.node.active.status";
    private static final String MOCK_DATA_PASSIVE_STATUS = "vcha.mockdata.node.passive.status";
    private static final String MOCK_DATA_WITNESS_STATUS = "vcha.mockdata.node.witness.status";
    private static final String MOCK_DATA_HEALTH_MSG1 = "vcha.mockdata.cluster.health.issue1.message";
    private static final String MOCK_DATA_HEALTH_RCM1 = "vcha.mockdata.cluster.health.issue1.recommendation";
    private static final String MOCK_DATA_HEALTH_MSG2 = "vcha.mockdata.cluster.health.issue2.message";
    private static final String MOCK_DATA_HEALTH_RCM2 = "vcha.mockdata.cluster.health.issue2.recommendation";
    private static final String MOCK_DATA_ACTIVE_GUESTOS_NIC0_STATUS = "vcha.mockdata.node.active.guestOs.nic0.status";
    private static final String MOCK_DATA_ACTIVE_GUESTOS_NIC1_STATUS = "vcha.mockdata.node.active.guestOs.nic1.status";
    private static final String MOCK_DATA_ACTIVE_GUESTOS_NIC2_STATUS = "vcha.mockdata.node.active.guestOs.nic2.status";
    private static final String MOCK_DATA_ACTIVE_GUESTOS_NIC3_STATUS = "vcha.mockdata.node.active.guestOs.nic3.status";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV4_IPADDR = "vcha.mockdata.node.active.clusterNetwork.ipv4.address";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV4_PREFIX = "vcha.mockdata.node.active.clusterNetwork.ipv4.prefix";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV4_GW = "vcha.mockdata.node.active.clusterNetwork.ipv4.gateway";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV4_MODE = "vcha.mockdata.node.active.clusterNetwork.ipv4.mode";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV61_IPADDR = "vcha.mockdata.node.active.clusterNetwork.ipv6.1.address";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV61_PREF = "vcha.mockdata.node.active.clusterNetwork.ipv6.1.prefix";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV61_ORIGIN = "vcha.mockdata.node.active.clusterNetwork.ipv6.1.origin";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV62_IPADDR = "vcha.mockdata.node.active.clusterNetwork.ipv6.2.address";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV62_PREF = "vcha.mockdata.node.active.clusterNetwork.ipv6.2.prefix";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV62_ORIGIN = "vcha.mockdata.node.active.clusterNetwork.ipv6.2.origin";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV6_GW = "vcha.mockdata.node.active.clusterNetwork.ipv6.gateway";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV6_AUTOCONF = "vcha.mockdata.node.active.clusterNetwork.ipv6.autoconf";
    private static final String MOCK_DATA_ACTIVE_CLNETWORKV6_DHCP = "vcha.mockdata.node.active.clusterNetwork.ipv6.dhcp";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV4_IPADDR = "vcha.mockdata.node.passive.clusterNetwork.ipv4.address";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV4_PREFIX = "vcha.mockdata.node.passive.clusterNetwork.ipv4.prefix";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV4_GW = "vcha.mockdata.node.passive.clusterNetwork.ipv4.gateway";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV61_IPADDR = "vcha.mockdata.node.passive.clusterNetwork.ipv6.1.address";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV61_PREF = "vcha.mockdata.node.passive.clusterNetwork.ipv6.1.prefix";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV62_IPADDR = "vcha.mockdata.node.passive.clusterNetwork.ipv6.2.address";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV62_PREF = "vcha.mockdata.node.passive.clusterNetwork.ipv6.2.prefix";
    private static final String MOCK_DATA_PASSIVE_CLNETWORKV6_GW = "vcha.mockdata.node.passive.clusterNetwork.ipv6.gateway";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV4_IPADDR = "vcha.mockdata.node.witness.clusterNetwork.ipv4.address";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV4_PREFIX = "vcha.mockdata.node.witness.clusterNetwork.ipv4.prefix";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV4_GW = "vcha.mockdata.node.witness.clusterNetwork.ipv4.gateway";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV61_IPADDR = "vcha.mockdata.node.witness.clusterNetwork.ipv6.1.address";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV61_PREF = "vcha.mockdata.node.witness.clusterNetwork.ipv6.1.prefix";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV62_IPADDR = "vcha.mockdata.node.witness.clusterNetwork.ipv6.2.address";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV62_PREF = "vcha.mockdata.node.witness.clusterNetwork.ipv6.2.prefix";
    private static final String MOCK_DATA_WITNESS_CLNETWORKV6_GW = "vcha.mockdata.node.witness.clusterNetwork.ipv6.gateway";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV4_IPADDR = "vcha.mockdata.node.active.publicNetwork.ipv4.address";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV4_PREFIX = "vcha.mockdata.node.active.publicNetwork.ipv4.prefix";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV4_GW = "vcha.mockdata.node.active.publicNetwork.ipv4.gateway";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV4_MODE = "vcha.mockdata.node.active.publicNetwork.ipv4.mode";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV61_IPADDR = "vcha.mockdata.node.active.publicNetwork.ipv6.1.address";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV61_PREF = "vcha.mockdata.node.active.publicNetwork.ipv6.1.prefix";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV61_ORIGIN = "vcha.mockdata.node.active.publicNetwork.ipv6.1.origin";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV62_IPADDR = "vcha.mockdata.node.active.publicNetwork.ipv6.2.address";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV62_PREF = "vcha.mockdata.node.active.publicNetwork.ipv6.2.prefix";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV62_ORIGIN = "vcha.mockdata.node.active.publicNetwork.ipv6.2.origin";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV6_GW = "vcha.mockdata.node.active.publicNetwork.ipv6.gateway";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV6_AUTOCONF = "vcha.mockdata.node.active.publicNetwork.ipv6.autoconf";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORKV6_DHCP = "vcha.mockdata.node.active.publicNetwork.ipv6.dhcp";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORK_DNSSRV = "vcha.mockdata.node.active.publicNetwork.dnsServers";
    private static final String MOCK_DATA_ACTIVE_PUBNETWORK_DNSDMN = "vcha.mockdata.node.active.publicNetwork.dnsDomain";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV4_IPADDR = "vcha.mockdata.node.passive.publicNetwork.ipv4.address";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV4_PREFIX = "vcha.mockdata.node.passive.publicNetwork.ipv4.prefix";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV4_GW = "vcha.mockdata.node.passive.publicNetwork.ipv4.gateway";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV61_IPADDR = "vcha.mockdata.node.passive.publicNetwork.ipv6.1.address";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV61_PREF = "vcha.mockdata.node.passive.publicNetwork.ipv6.1.prefix";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV62_IPADDR = "vcha.mockdata.node.passive.publicNetwork.ipv6.2.address";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV62_PREF = "vcha.mockdata.node.passive.publicNetwork.ipv6.2.prefix";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORKV6_GW = "vcha.mockdata.node.passive.publicNetwork.ipv6.gateway";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORK_DNSSRV = "vcha.mockdata.node.passive.publicNetwork.dnsServers";
    private static final String MOCK_DATA_PASSIVE_PUBNETWORK_DNSDMN = "vcha.mockdata.node.passive.publicNetwork.dnsDomain";
    private static final String PROPERTY_NICS = "nics";
    private static final String PROPERTY_IPV4_CONFIG = "ipv4Config";
    private static final String PROPERTY_IPV6_CONFIG = "ipv6Config";
    private static final String PROPERTY_DNS_CONFIG = "dnsConfig";
    private static final short PROPERTIES_EXPIRATION_TIMEOUT = 3000;
    private static final String PROPERTIES_MOCK_RESOURCE_FILE = "mockdata.properties";
    private static final Log _logger = LogFactory.getLog(VchaMockDataProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private ConfigurationService _configrationService;
    private Properties _propertiesData;
    private Date _propertiesReadTime;

    public VchaMockDataProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, ConfigurationService configrationService) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._configrationService = configrationService;
    }

    public boolean getUseMockData() {
        return this.getUseMockData(null);
    }

    public boolean getUseMockData(String propertyName) {
        String useMockDataString = this._configrationService.getProperty(MOCK_DATA_USE);
        if ("true".equalsIgnoreCase(useMockDataString)) {
            String realDataProps;
            if (!StringUtil.isNullOrEmpty((String)propertyName) && !StringUtil.isNullOrEmpty((String)(realDataProps = this.getOptionalString(USE_REAL)))) {
                return !realDataProps.contains(propertyName);
            }
            return true;
        }
        return false;
    }

    public boolean getVchaIsSupported() {
        return this.getRequiredBoolean(MOCK_DATA_COMPAT_IS_SUPPORTED);
    }

    public boolean getVchaIsEmbeddedDbInUse() {
        return this.getRequiredBoolean(MOCK_DATA_COMPAT_EMBEDDED_DB);
    }

    public boolean getVchaIsOnCloudVm() {
        return this.getRequiredBoolean(MOCK_DATA_COMPAT_ON_CLOUDVM);
    }

    public boolean getVchaIsExternalInfraNodeInUse() {
        return this.getRequiredBoolean(MOCK_DATA_COMPAT_ON_MGMTNODE);
    }

    public List<String> getVchaDisabledMethods() {
        String disabledMethodsStr = this.getOptionalString(MOCK_DATA_DISABLED_METHODS);
        ArrayList<String> disabledMethodSet = new ArrayList<String>();
        if (!StringUtil.isNullOrEmpty((String)disabledMethodsStr)) {
            String[] disabledMethods;
            for (String disabledMethod : disabledMethods = disabledMethodsStr.split(",")) {
                disabledMethodSet.add(disabledMethod.trim());
            }
        }
        return disabledMethodSet;
    }

    public String getClusterMode() {
        String clusterModeString = this.getRequiredString(MOCK_DATA_CLUSTER_MODE);
        String clusterMode = null;
        if (FailoverClusterManager.VchaClusterMode.enabled.name().equalsIgnoreCase(clusterModeString)) {
            clusterMode = FailoverClusterManager.VchaClusterMode.enabled.name();
        } else if (FailoverClusterManager.VchaClusterMode.disabled.name().equalsIgnoreCase(clusterModeString)) {
            clusterMode = FailoverClusterManager.VchaClusterMode.disabled.name();
        } else if (FailoverClusterManager.VchaClusterMode.maintenance.name().equalsIgnoreCase(clusterModeString)) {
            clusterMode = FailoverClusterManager.VchaClusterMode.maintenance.name();
        } else {
            if ("unconfigured".equalsIgnoreCase(clusterModeString)) {
                return null;
            }
            if ("invalid".equalsIgnoreCase(clusterModeString)) {
                return null;
            }
            if ("prepared".equalsIgnoreCase(clusterModeString)) {
                return null;
            }
        }
        return clusterMode;
    }

    public FailoverClusterManager.VchaClusterHealth getClusterHealth() {
        FailoverClusterManager.VchaClusterHealth clusterHealth = new FailoverClusterManager.VchaClusterHealth();
        clusterHealth.runtimeInfo = new FailoverClusterManager.VchaClusterRuntimeInfo();
        clusterHealth.runtimeInfo.clusterMode = this.getClusterMode();
        if (clusterHealth.runtimeInfo.clusterMode == null) {
            return null;
        }
        clusterHealth.runtimeInfo.clusterState = this.getClusterHealthState();
        FailoverClusterManager.VchaNodeRuntimeInfo activeNode = new FailoverClusterManager.VchaNodeRuntimeInfo();
        activeNode.nodeIp = this.getOptionalString(new String[]{MOCK_DATA_ACTIVE_CLNETWORKV4_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV61_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV62_IPADDR});
        activeNode.nodeRole = FailoverClusterManager.VchaNodeRole.active.name();
        activeNode.nodeState = this.getNodeState(MOCK_DATA_ACTIVE_STATUS);
        FailoverClusterManager.VchaNodeRuntimeInfo passiveNode = new FailoverClusterManager.VchaNodeRuntimeInfo();
        passiveNode.nodeIp = this.getOptionalString(new String[]{MOCK_DATA_PASSIVE_CLNETWORKV4_IPADDR, MOCK_DATA_PASSIVE_CLNETWORKV61_IPADDR, MOCK_DATA_PASSIVE_CLNETWORKV62_IPADDR});
        passiveNode.nodeRole = FailoverClusterManager.VchaNodeRole.passive.name();
        passiveNode.nodeState = this.getNodeState(MOCK_DATA_PASSIVE_STATUS);
        FailoverClusterManager.VchaNodeRuntimeInfo witnessNode = new FailoverClusterManager.VchaNodeRuntimeInfo();
        witnessNode.nodeIp = this.getOptionalString(new String[]{MOCK_DATA_WITNESS_CLNETWORKV4_IPADDR, MOCK_DATA_WITNESS_CLNETWORKV61_IPADDR, MOCK_DATA_WITNESS_CLNETWORKV62_IPADDR});
        witnessNode.nodeRole = FailoverClusterManager.VchaNodeRole.witness.name();
        witnessNode.nodeState = this.getNodeState(MOCK_DATA_WITNESS_STATUS);
        clusterHealth.runtimeInfo.nodeInfo = new FailoverClusterManager.VchaNodeRuntimeInfo[]{activeNode, passiveNode, witnessNode};
        ArrayList<LocalizableMessageImpl> healthMsgList = new ArrayList<LocalizableMessageImpl>();
        LocalizableMessageImpl healthMsg1 = new LocalizableMessageImpl();
        healthMsg1.setMessage(this.getOptionalString(MOCK_DATA_HEALTH_MSG1));
        if (!StringUtil.isNullOrEmpty((String)healthMsg1.getMessage())) {
            healthMsgList.add(healthMsg1);
        }
        LocalizableMessageImpl healthMsg2 = new LocalizableMessageImpl();
        healthMsg2.setMessage(this.getOptionalString(MOCK_DATA_HEALTH_MSG2));
        if (!StringUtil.isNullOrEmpty((String)healthMsg2.getMessage())) {
            healthMsgList.add(healthMsg2);
        }
        clusterHealth.healthMessages = healthMsgList.toArray(new LocalizableMessageImpl[healthMsgList.size()]);
        ArrayList<LocalizableMessageImpl> healthRecList = new ArrayList<LocalizableMessageImpl>();
        LocalizableMessageImpl healthRec1 = new LocalizableMessageImpl();
        healthRec1.setMessage(this.getOptionalString(MOCK_DATA_HEALTH_RCM1));
        if (!StringUtil.isNullOrEmpty((String)healthRec1.getMessage())) {
            healthRecList.add(healthRec1);
        }
        LocalizableMessageImpl healthRec2 = new LocalizableMessageImpl();
        healthRec2.setMessage(this.getOptionalString(MOCK_DATA_HEALTH_RCM2));
        if (!StringUtil.isNullOrEmpty((String)healthRec2.getMessage())) {
            healthRecList.add(healthRec2);
        }
        clusterHealth.additionalInformation = healthRecList.toArray(new LocalizableMessageImpl[healthRecList.size()]);
        return clusterHealth;
    }

    public FailoverClusterConfigurator.VchaClusterConfigInfo getConfig() throws Exception {
        FailoverClusterConfigurator.VchaClusterConfigInfo configInfo = new FailoverClusterConfigurator.VchaClusterConfigInfo();
        configInfo.state = this.getClusterConfigState();
        if (this.getClusterMode() == null) {
            return configInfo;
        }
        FailoverClusterConfigurator.FailoverNodeInfo activeNodeInfo = new FailoverClusterConfigurator.FailoverNodeInfo();
        activeNodeInfo.clusterIpSettings = new IPSettings();
        this.updateIpv4Settings(activeNodeInfo.clusterIpSettings, MOCK_DATA_ACTIVE_CLNETWORKV4_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV4_PREFIX, MOCK_DATA_ACTIVE_CLNETWORKV4_GW);
        this.updateIpv6Settings(activeNodeInfo.clusterIpSettings, MOCK_DATA_ACTIVE_CLNETWORKV61_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV61_PREF, MOCK_DATA_ACTIVE_CLNETWORKV62_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV62_PREF, MOCK_DATA_ACTIVE_CLNETWORKV6_GW);
        activeNodeInfo.failoverIp = new IPSettings();
        this.updateIpv4Settings(activeNodeInfo.failoverIp, MOCK_DATA_ACTIVE_PUBNETWORKV4_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV4_PREFIX, MOCK_DATA_ACTIVE_PUBNETWORKV4_GW);
        this.updateIpv6Settings(activeNodeInfo.failoverIp, MOCK_DATA_ACTIVE_PUBNETWORKV61_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV61_PREF, MOCK_DATA_ACTIVE_PUBNETWORKV62_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV62_PREF, MOCK_DATA_ACTIVE_PUBNETWORKV6_GW);
        this.updateDnsSettings(activeNodeInfo.failoverIp, MOCK_DATA_ACTIVE_PUBNETWORK_DNSSRV, MOCK_DATA_ACTIVE_PUBNETWORK_DNSDMN);
        activeNodeInfo.biosUuid = this.getOptionalString(MOCK_DATA_ACTIVE_VM_UUID);
        FailoverClusterConfigurator.FailoverNodeInfo passiveNodeInfo = new FailoverClusterConfigurator.FailoverNodeInfo();
        passiveNodeInfo.clusterIpSettings = new IPSettings();
        this.updateIpv4Settings(passiveNodeInfo.clusterIpSettings, MOCK_DATA_PASSIVE_CLNETWORKV4_IPADDR, MOCK_DATA_PASSIVE_CLNETWORKV4_PREFIX, MOCK_DATA_PASSIVE_CLNETWORKV4_GW);
        this.updateIpv6Settings(passiveNodeInfo.clusterIpSettings, MOCK_DATA_PASSIVE_CLNETWORKV61_IPADDR, MOCK_DATA_PASSIVE_CLNETWORKV61_PREF, MOCK_DATA_PASSIVE_CLNETWORKV62_IPADDR, MOCK_DATA_PASSIVE_CLNETWORKV62_PREF, MOCK_DATA_PASSIVE_CLNETWORKV6_GW);
        passiveNodeInfo.failoverIp = new IPSettings();
        this.updateIpv4Settings(passiveNodeInfo.failoverIp, MOCK_DATA_PASSIVE_PUBNETWORKV4_IPADDR, MOCK_DATA_PASSIVE_PUBNETWORKV4_PREFIX, MOCK_DATA_PASSIVE_PUBNETWORKV4_GW);
        this.updateIpv6Settings(passiveNodeInfo.failoverIp, MOCK_DATA_PASSIVE_PUBNETWORKV61_IPADDR, MOCK_DATA_PASSIVE_PUBNETWORKV61_PREF, MOCK_DATA_PASSIVE_PUBNETWORKV62_IPADDR, MOCK_DATA_PASSIVE_PUBNETWORKV62_PREF, MOCK_DATA_PASSIVE_PUBNETWORKV6_GW);
        this.updateDnsSettings(passiveNodeInfo.failoverIp, MOCK_DATA_PASSIVE_PUBNETWORK_DNSSRV, MOCK_DATA_PASSIVE_PUBNETWORK_DNSDMN);
        passiveNodeInfo.biosUuid = this.getOptionalString(MOCK_DATA_PASSIVE_VM_UUID);
        FailoverClusterConfigurator.WitnessNodeInfo witnessNodeInfo = new FailoverClusterConfigurator.WitnessNodeInfo();
        witnessNodeInfo.ipSettings = new IPSettings();
        this.updateIpv4Settings(witnessNodeInfo.ipSettings, MOCK_DATA_WITNESS_CLNETWORKV4_IPADDR, MOCK_DATA_WITNESS_CLNETWORKV4_PREFIX, MOCK_DATA_WITNESS_CLNETWORKV4_GW);
        this.updateIpv6Settings(witnessNodeInfo.ipSettings, MOCK_DATA_WITNESS_CLNETWORKV61_IPADDR, MOCK_DATA_WITNESS_CLNETWORKV61_PREF, MOCK_DATA_WITNESS_CLNETWORKV62_IPADDR, MOCK_DATA_WITNESS_CLNETWORKV62_PREF, MOCK_DATA_WITNESS_CLNETWORKV6_GW);
        witnessNodeInfo.biosUuid = this.getOptionalString(MOCK_DATA_WITNESS_VM_UUID);
        configInfo.failoverNodeInfo1 = activeNodeInfo;
        configInfo.failoverNodeInfo2 = passiveNodeInfo;
        configInfo.witnessNodeInfo = witnessNodeInfo;
        return configInfo;
    }

    public PropertyValue[] getVchaGuestOsNetworkInfoPropertyValues() {
        ArrayList<NetworkInterfaceInfo> nicCfgList = new ArrayList<NetworkInterfaceInfo>();
        ArrayList<IPv4Config> ipv4CfgList = new ArrayList<IPv4Config>();
        ArrayList<IPv6Config> ipv6CfgList = new ArrayList<IPv6Config>();
        this.updateNic(nicCfgList, MOCK_DATA_ACTIVE_GUESTOS_NIC0_STATUS, "nic0");
        this.updateNic(nicCfgList, MOCK_DATA_ACTIVE_GUESTOS_NIC1_STATUS, "nic1");
        this.updateNic(nicCfgList, MOCK_DATA_ACTIVE_GUESTOS_NIC2_STATUS, "nic2");
        this.updateNic(nicCfgList, MOCK_DATA_ACTIVE_GUESTOS_NIC3_STATUS, "nic3");
        if (nicCfgList.size() > 0) {
            this.updateIpv4Config(ipv4CfgList, ((NetworkInterfaceInfo)nicCfgList.get((int)0)).name, MOCK_DATA_ACTIVE_PUBNETWORKV4_MODE, MOCK_DATA_ACTIVE_PUBNETWORKV4_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV4_PREFIX, MOCK_DATA_ACTIVE_PUBNETWORKV4_GW);
            this.updateIpv6Config(ipv6CfgList, ((NetworkInterfaceInfo)nicCfgList.get((int)0)).name, MOCK_DATA_ACTIVE_PUBNETWORKV6_GW, MOCK_DATA_ACTIVE_PUBNETWORKV6_DHCP, MOCK_DATA_ACTIVE_PUBNETWORKV6_AUTOCONF, MOCK_DATA_ACTIVE_PUBNETWORKV61_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV61_PREF, MOCK_DATA_ACTIVE_PUBNETWORKV61_ORIGIN, MOCK_DATA_ACTIVE_PUBNETWORKV62_IPADDR, MOCK_DATA_ACTIVE_PUBNETWORKV62_PREF, MOCK_DATA_ACTIVE_PUBNETWORKV62_ORIGIN);
        }
        if (nicCfgList.size() > 1) {
            this.updateIpv4Config(ipv4CfgList, ((NetworkInterfaceInfo)nicCfgList.get((int)1)).name, MOCK_DATA_ACTIVE_CLNETWORKV4_MODE, MOCK_DATA_ACTIVE_CLNETWORKV4_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV4_PREFIX, MOCK_DATA_ACTIVE_CLNETWORKV4_GW);
            this.updateIpv6Config(ipv6CfgList, ((NetworkInterfaceInfo)nicCfgList.get((int)1)).name, MOCK_DATA_ACTIVE_CLNETWORKV6_GW, MOCK_DATA_ACTIVE_CLNETWORKV6_DHCP, MOCK_DATA_ACTIVE_CLNETWORKV6_AUTOCONF, MOCK_DATA_ACTIVE_CLNETWORKV61_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV61_PREF, MOCK_DATA_ACTIVE_CLNETWORKV61_ORIGIN, MOCK_DATA_ACTIVE_CLNETWORKV62_IPADDR, MOCK_DATA_ACTIVE_CLNETWORKV62_PREF, MOCK_DATA_ACTIVE_CLNETWORKV62_ORIGIN);
        }
        DnsServerConfig dnsConfig = new DnsServerConfig();
        String dnsServersStr = this.getOptionalString(MOCK_DATA_PASSIVE_PUBNETWORK_DNSSRV);
        if (!StringUtil.isNullOrEmpty((String)dnsServersStr)) {
            dnsConfig.servers = dnsServersStr.split(",");
        }
        ArrayList<PropertyValue> pvList = new ArrayList<PropertyValue>();
        PropertyValue pvDns = new PropertyValue();
        pvDns.propertyName = PROPERTY_DNS_CONFIG;
        pvDns.value = dnsConfig;
        pvList.add(pvDns);
        if (nicCfgList.size() > 0) {
            PropertyValue pvNics = new PropertyValue();
            pvNics.propertyName = PROPERTY_NICS;
            pvNics.value = nicCfgList.toArray(new NetworkInterfaceInfo[nicCfgList.size()]);
            pvList.add(pvNics);
        }
        if (ipv4CfgList.size() > 0) {
            PropertyValue pvIpv4Cfg = new PropertyValue();
            pvIpv4Cfg.propertyName = PROPERTY_IPV4_CONFIG;
            pvIpv4Cfg.value = ipv4CfgList.toArray(new IPv4Config[ipv4CfgList.size()]);
            pvList.add(pvIpv4Cfg);
        }
        if (ipv6CfgList.size() > 0) {
            PropertyValue pvIpv6Cfg = new PropertyValue();
            pvIpv6Cfg.propertyName = PROPERTY_IPV6_CONFIG;
            pvIpv6Cfg.value = ipv6CfgList.toArray(new IPv6Config[ipv6CfgList.size()]);
            pvList.add(pvIpv6Cfg);
        }
        return pvList.toArray(new PropertyValue[pvList.size()]);
    }

    public VchaClusterVmInfo getVchaClusterVmSingleDomain() throws Exception {
        VchaClusterVmInfo clusterVm = new VchaClusterVmInfo();
        clusterVm.activeVm = this.getVm(this.getOptionalString(MOCK_DATA_ACTIVE_VM));
        clusterVm.passiveVm = this.getVm(this.getOptionalString(MOCK_DATA_PASSIVE_VM));
        clusterVm.witnessVm = this.getVm(this.getOptionalString(MOCK_DATA_WITNESS_VM));
        return clusterVm;
    }

    public ManagedObjectReference getVchaCloudVmSingleDomain() throws Exception {
        return this.getVm(this.getOptionalString(MOCK_DATA_ACTIVE_VM));
    }

    private ManagedObjectReference getVm(String vmName) throws Exception {
        if (StringUtil.isNullOrEmpty((String)vmName)) {
            return null;
        }
        PropertyConstraint pc = this._querySpecBuilder.createPropertyConstraint(VirtualMachine.class.getSimpleName(), "name", Comparator.EQUALS, (Object)vmName);
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)pc, new String[0]);
        ResultSet resultSet = this._queryExecutor.getData(query);
        if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return null;
        }
        return (ManagedObjectReference)resultSet.items[0].resourceObject;
    }

    private String getNodeState(String key) {
        String nodeStateString = this.getRequiredString(key);
        String nodeState = null;
        if (FailoverClusterManager.VchaNodeState.up.name().equalsIgnoreCase(nodeStateString)) {
            nodeState = FailoverClusterManager.VchaNodeState.up.name();
        } else if (FailoverClusterManager.VchaNodeState.down.name().equalsIgnoreCase(nodeStateString)) {
            nodeState = FailoverClusterManager.VchaNodeState.down.name();
        }
        return nodeState;
    }

    private String getClusterHealthState() {
        String clusterStateString = this.getRequiredString(MOCK_DATA_CLUSTER_HEALTH);
        String clusterState = null;
        if (FailoverClusterManager.VchaClusterState.healthy.name().equalsIgnoreCase(clusterStateString)) {
            clusterState = FailoverClusterManager.VchaClusterState.healthy.name();
        } else if (FailoverClusterManager.VchaClusterState.degraded.name().equalsIgnoreCase(clusterStateString)) {
            clusterState = FailoverClusterManager.VchaClusterState.degraded.name();
        } else if (FailoverClusterManager.VchaClusterState.isolated.name().equalsIgnoreCase(clusterStateString)) {
            clusterState = FailoverClusterManager.VchaClusterState.isolated.name();
        }
        return clusterState;
    }

    public String getClusterConfigState() {
        String clusterModeString = this.getRequiredString(MOCK_DATA_CLUSTER_MODE);
        FailoverClusterConfigurator.VchaState configState = null;
        if (FailoverClusterManager.VchaClusterMode.enabled.name().equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.configured;
        } else if (FailoverClusterManager.VchaClusterMode.disabled.name().equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.configured;
        } else if (FailoverClusterManager.VchaClusterMode.maintenance.name().equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.configured;
        } else if ("unconfigured".equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.notConfigured;
        } else if ("invalid".equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.invalid;
        } else if ("prepared".equalsIgnoreCase(clusterModeString)) {
            configState = FailoverClusterConfigurator.VchaState.prepared;
        }
        return configState.name();
    }

    private void updateIpv4Settings(IPSettings ipSettings, String addressKey, String prefixKey, String gatewayKey) {
        String gatewayString;
        int prefix;
        String addressString = this.getOptionalString(addressKey);
        if (!StringUtil.isNullOrEmpty((String)addressString)) {
            ipSettings.ip = new FixedIp(addressString);
        }
        if ((prefix = this.getOptionalInt(prefixKey)) > 0) {
            ipSettings.subnetMask = VchaUtil.convertPrefixToSubnetMask(prefix);
        }
        if (!StringUtil.isNullOrEmpty((String)(gatewayString = this.getOptionalString(gatewayKey)))) {
            String[] gateways = gatewayString.split(",");
            ipSettings.gateway = gateways;
        }
    }

    private void updateIpv6Settings(IPSettings ipSettings, String address1Key, String prefix1Key, String address2Key, String prefix2Key, String gatewayKey) {
        String gatewayString;
        String address2String;
        ArrayList<FixedIpV6> ipV6List = new ArrayList<FixedIpV6>();
        String address1String = this.getOptionalString(address1Key);
        if (!StringUtil.isNullOrEmpty((String)address1String)) {
            String prefix1String = this.getRequiredString(prefix1Key);
            int prefix1 = Integer.parseInt(prefix1String);
            FixedIpV6 fixedIp1 = new FixedIpV6(address1String, prefix1);
            ipV6List.add(fixedIp1);
        }
        if (!StringUtil.isNullOrEmpty((String)(address2String = this.getOptionalString(address2Key)))) {
            String prefix2String = this.getRequiredString(prefix2Key);
            int prefix2 = Integer.parseInt(prefix2String);
            FixedIpV6 fixedIp2 = new FixedIpV6(address2String, prefix2);
            ipV6List.add(fixedIp2);
        }
        boolean specInitialized = false;
        IPSettings.IpV6AddressSpec spec = new IPSettings.IpV6AddressSpec();
        if (ipV6List.size() > 0) {
            spec.ip = ipV6List.toArray(new IpV6Generator[ipV6List.size()]);
            specInitialized = true;
        }
        if (!StringUtil.isNullOrEmpty((String)(gatewayString = this.getOptionalString(gatewayKey)))) {
            String[] gateways = gatewayString.split(",");
            spec.gateway = gateways;
            specInitialized = true;
        }
        if (specInitialized) {
            ipSettings.ipV6Spec = spec;
        }
    }

    private void updateDnsSettings(IPSettings ipSettings, String dnsServerKey, String dnsDomainKey) {
        String dnsDomainString;
        String dnsServerString = this.getOptionalString(dnsServerKey);
        if (!StringUtil.isNullOrEmpty((String)dnsServerString)) {
            String[] dnsServers = dnsServerString.split(",");
            ipSettings.dnsServerList = dnsServers;
        }
        if (!StringUtil.isNullOrEmpty((String)(dnsDomainString = this.getOptionalString(dnsDomainKey)))) {
            ipSettings.dnsDomain = dnsDomainString;
        }
    }

    private void updateNic(List<NetworkInterfaceInfo> nicCfgList, String nicStatusKey, String nicName) {
        String nicStr = this.getOptionalString(nicStatusKey);
        if (!StringUtil.isNullOrEmpty((String)nicStr)) {
            NetworkInterfaceInfo nicInfo = new NetworkInterfaceInfo();
            nicInfo.name = nicName;
            nicInfo.status = NetworkInterfaceInfo.NetworkInterfaceStatus.valueOf((String)nicStr);
            nicCfgList.add(nicInfo);
        }
    }

    private void updateIpv4Config(List<IPv4Config> ipCfgList, String nicName, String modeKey, String addressKey, String prefixKey, String gatewayKey) {
        IPv4Config ipv4Cfg = new IPv4Config();
        ipv4Cfg.nic = nicName;
        String modeStr = this.getOptionalString(modeKey);
        if (!StringUtil.isNullOrEmpty((String)modeStr)) {
            ipv4Cfg.mode = IPv4Config.Ipv4Mode.valueOf((String)modeStr);
        }
        ipv4Cfg.address = this.getOptionalString(addressKey);
        ipv4Cfg.prefix = this.getOptionalInt(prefixKey);
        ipv4Cfg.defaultGateway = this.getOptionalString(gatewayKey);
        if (!StringUtil.isNullOrEmpty((String)ipv4Cfg.address)) {
            ipCfgList.add(ipv4Cfg);
        }
    }

    private void updateIpv6Config(List<IPv6Config> ipCfgList, String nicName, String gatewayKey, String dhcpKey, String autoConfKey, String address1Key, String prefix1Key, String origin1Key, String address2Key, String prefix2Key, String origin2Key) {
        IPv6Config ipv6Cfg = new IPv6Config();
        ipv6Cfg.nic = nicName;
        ipv6Cfg.defaultGateway = this.getOptionalString(gatewayKey);
        ipv6Cfg.dhcp = this.getOptionalBoolean(dhcpKey);
        ipv6Cfg.autoconf = this.getOptionalBoolean(autoConfKey);
        ArrayList<IPv6Address> ipv6AddrList = new ArrayList<IPv6Address>();
        IPv6Address ipv6Addr1 = new IPv6Address();
        ipv6Addr1.address = this.getOptionalString(address1Key);
        ipv6Addr1.prefix = this.getOptionalInt(prefix1Key);
        String origin1Str = this.getOptionalString(origin1Key);
        if (!StringUtil.isNullOrEmpty((String)origin1Str)) {
            ipv6Addr1.origin = IPv6Address.Ipv6Origin.valueOf((String)origin1Str);
        }
        if (!StringUtil.isNullOrEmpty((String)ipv6Addr1.address)) {
            ipv6AddrList.add(ipv6Addr1);
        }
        IPv6Address ipv6Addr2 = new IPv6Address();
        ipv6Addr2.address = this.getOptionalString(address2Key);
        ipv6Addr2.prefix = this.getOptionalInt(prefix2Key);
        String origin2Str = this.getOptionalString(origin2Key);
        if (!StringUtil.isNullOrEmpty((String)origin2Str)) {
            ipv6Addr2.origin = IPv6Address.Ipv6Origin.valueOf((String)origin2Str);
        }
        if (!StringUtil.isNullOrEmpty((String)ipv6Addr2.address)) {
            ipv6AddrList.add(ipv6Addr2);
        }
        if (ipv6AddrList.size() > 0) {
            ipv6Cfg.addresses = ipv6AddrList.toArray(new IPv6Address[ipv6AddrList.size()]);
            ipCfgList.add(ipv6Cfg);
        }
    }

    private boolean getOptionalBoolean(String key) {
        String boolStr = this.getOptionalString(key);
        if (StringUtil.isNullOrEmpty((String)boolStr)) {
            return false;
        }
        try {
            return Boolean.parseBoolean(boolStr);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean getRequiredBoolean(String key) {
        String boolStr = this.getRequiredString(key);
        try {
            return Boolean.parseBoolean(boolStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Required %s property boolean value is incorrect.", key));
        }
    }

    private int getOptionalInt(String key) {
        String intStr = this.getOptionalString(key);
        if (StringUtil.isNullOrEmpty((String)intStr)) {
            return 0;
        }
        try {
            return Integer.parseInt(intStr);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getOptionalString(String key) {
        return this.getProperties().getProperty(key);
    }

    private String getOptionalString(String[] keys) {
        for (String key : keys) {
            String optionalString = this.getOptionalString(key);
            if (StringUtil.isNullOrEmpty((String)optionalString)) continue;
            return optionalString;
        }
        return null;
    }

    private String getRequiredString(String key) {
        String requiredString = this.getProperties().getProperty(key);
        if (StringUtil.isNullOrEmpty((String)requiredString)) {
            throw new IllegalArgumentException(String.format("Required %s property value not set or incorrect.", key));
        }
        return requiredString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getProperties() {
        long lastUpdateTimeout = 0L;
        if (this._propertiesReadTime != null) {
            lastUpdateTimeout = new Date().getTime() - this._propertiesReadTime.getTime();
        }
        if (this._propertiesData == null || lastUpdateTimeout > 3000L) {
            this._propertiesData = new Properties();
            InputStream inputStream = null;
            try {
                String mockDataFileLocation = this._configrationService.getProperty(MOCK_DATA_EXTERNAL_FILE_LOCATION);
                inputStream = !StringUtil.isNullOrEmpty((String)mockDataFileLocation) ? new FileInputStream(mockDataFileLocation) : this.getClass().getResourceAsStream(PROPERTIES_MOCK_RESOURCE_FILE);
                this._propertiesData.load(inputStream);
            }
            catch (Exception e) {
                _logger.error((Object)"Cannot read mock data file.");
                _logger.error((Object)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {}
            }
            this._propertiesReadTime = new Date();
        }
        return this._propertiesData;
    }
}

