/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vcha.FailoverClusterManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vsphere.client.common.ServiceLocatorFactory;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.CommandExecutionEngine;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.compositecommand.DummyCommandSpec;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.vcha.command.VchaCommandFactory;
import com.vmware.vsphere.client.vcha.impl.VchaMockDataProvider;
import com.vmware.vsphere.client.vcha.model.VchaClusterVmInfo;
import com.vmware.vsphere.client.vcha.specs.ConfigureVchaSpec;
import com.vmware.vsphere.client.vcha.specs.VchaDeleteVmCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaDeployNodeSpec;
import com.vmware.vsphere.client.vcha.specs.VchaDeploySpec;
import com.vmware.vsphere.client.vcha.specs.VchaFailoverSpec;
import com.vmware.vsphere.client.vcha.specs.VchaManageSpec;
import com.vmware.vsphere.client.vcha.specs.VchaPowerOffVmCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaRemoveCommandSpec;
import com.vmware.vsphere.client.vcha.specs.VchaSetModeCommandSpec;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VchaMutationProvider.class);
    private static final String PROPERTY_CLUSTER_VM = "vchaClusterVmSingleDomain";
    private static final String PROPERTY_VM_POWER_STATE = "runtime.powerState";
    private DataService _dataService;
    private ServiceLocatorFactory _serviceLocatorFactory;
    private QueryExecutor _queryExecutor;
    private VchaMockDataProvider _mockDataProvider;

    public VchaMutationProvider(DataService dataService, ServiceLocatorFactory serviceLocatorFactory, QueryExecutor queryExecutor, VchaMockDataProvider mockDataProvider) {
        this._dataService = dataService;
        this._serviceLocatorFactory = serviceLocatorFactory;
        this._queryExecutor = queryExecutor;
        this._mockDataProvider = mockDataProvider;
    }

    public OperationResult apply(ManagedObjectReference rootFolderRef, ConfigureVchaSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootFolderRef;
        if (this._mockDataProvider.getUseMockData("vchaOpConfigure")) {
            _logger.info((Object)"Configure cannot be called when using mock data.");
            return result;
        }
        if (spec.passiveNodeConnectionIpAddress == null || ArrayUtils.isEmpty((Object[])spec.passiveNodeConnectionIpAddress)) {
            throw new IllegalArgumentException(VchaUtil.getLocalizedString("error.noSpecifiedIpAddressForPassive"));
        }
        if (spec.witnessNodeConnectionIpAddress == null || ArrayUtils.isEmpty((Object[])spec.witnessNodeConnectionIpAddress)) {
            throw new IllegalArgumentException(VchaUtil.getLocalizedString("error.noSpecifiedIpAddressForWitness"));
        }
        try {
            FailoverClusterConfigurator.VchaClusterConfigSpec clusterConfigSpec = new FailoverClusterConfigurator.VchaClusterConfigSpec();
            clusterConfigSpec.passiveIp = spec.passiveNodeConnectionIpAddress[0];
            clusterConfigSpec.witnessIp = spec.witnessNodeConnectionIpAddress[0];
            FailoverClusterConfigurator fcConfigurator = VchaUtil.getFailoverClusterConfigurator(rootFolderRef);
            result.task = fcConfigurator.configure(clusterConfigSpec);
        }
        catch (Exception e) {
            _logger.error((Object)"Configure vCenter HA settings operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootFolderRef, VchaManageSpec spec) {
        BaseCommandSpec rootCmdSpec = this.createVchaManageCommands(rootFolderRef, spec);
        VchaCommandFactory commandFactory = new VchaCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine(rootCmdSpec, this._dataService, (CommandFactory)commandFactory);
        if (this._mockDataProvider.getUseMockData("vchaOpManage")) {
            _logger.info((Object)"SetMode/Destroy cannot be called when using mock data.");
            OperationResult result = new OperationResult();
            result.entity = rootFolderRef;
            return result;
        }
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference rootFolderRef, VchaFailoverSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = rootFolderRef;
        if (this._mockDataProvider.getUseMockData("vchaOpFailover")) {
            _logger.info((Object)"InitFailover cannot be called when using mock data.");
            return result;
        }
        try {
            FailoverClusterManager fcManager = VchaUtil.getFailoverClusterManager(rootFolderRef);
            result.task = fcManager.initiateFailover(spec.planned);
        }
        catch (Exception e) {
            _logger.error((Object)"Initiate vCenter HA failover operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference rootFolderRef, VchaDeploySpec spec) {
        OperationResult result;
        block6: {
            result = new OperationResult();
            result.entity = rootFolderRef;
            if (this._mockDataProvider.getUseMockData("vchaOpDeploy")) {
                _logger.info((Object)"(Re)Deploy cannot be called when using mock data.");
                return result;
            }
            try {
                FailoverClusterConfigurator fcConfigurator = VchaUtil.getFailoverClusterConfigurator(rootFolderRef);
                FailoverClusterConfigurator.SourceNodeSpec sourceNodeSpec = new FailoverClusterConfigurator.SourceNodeSpec();
                this.populateSourceNodeSpec(sourceNodeSpec, rootFolderRef, spec);
                if (spec.passiveNodeSpec != null && spec.witnessNodeSpec != null) {
                    FailoverClusterConfigurator.VchaClusterDeploymentSpec deploymentSpec = new FailoverClusterConfigurator.VchaClusterDeploymentSpec();
                    deploymentSpec.activeVcSpec = sourceNodeSpec;
                    this.populateClusterNetworkConfigSpec(deploymentSpec, spec.activeNodeSpec);
                    deploymentSpec.passiveDeploymentSpec = new FailoverClusterConfigurator.PassiveNodeDeploymentSpec();
                    this.populateNodeDeploymentSpec((FailoverClusterConfigurator.NodeDeploymentSpec)deploymentSpec.passiveDeploymentSpec, rootFolderRef, spec.passiveNodeSpec, false);
                    deploymentSpec.witnessDeploymentSpec = new FailoverClusterConfigurator.NodeDeploymentSpec();
                    this.populateNodeDeploymentSpec(deploymentSpec.witnessDeploymentSpec, rootFolderRef, spec.witnessNodeSpec, true);
                    _logger.debug((Object)deploymentSpec);
                    result.task = fcConfigurator.deploy(deploymentSpec);
                    break block6;
                }
                if (spec.witnessNodeSpec != null) {
                    FailoverClusterConfigurator.NodeDeploymentSpec nodeDeploymentSpec = new FailoverClusterConfigurator.NodeDeploymentSpec();
                    this.populateNodeDeploymentSpec(nodeDeploymentSpec, rootFolderRef, spec.witnessNodeSpec, true);
                    _logger.debug((Object)nodeDeploymentSpec);
                    result.task = fcConfigurator.createWitnessNode(nodeDeploymentSpec, sourceNodeSpec);
                    break block6;
                }
                if (spec.passiveNodeSpec != null) {
                    FailoverClusterConfigurator.PassiveNodeDeploymentSpec nodeDeploymentSpec = new FailoverClusterConfigurator.PassiveNodeDeploymentSpec();
                    this.populateNodeDeploymentSpec((FailoverClusterConfigurator.NodeDeploymentSpec)nodeDeploymentSpec, rootFolderRef, spec.passiveNodeSpec, false);
                    _logger.debug((Object)nodeDeploymentSpec);
                    result.task = fcConfigurator.createPassiveNode(nodeDeploymentSpec, sourceNodeSpec);
                    break block6;
                }
                throw new IllegalArgumentException("Invalid VchaDeploySpec.");
            }
            catch (Exception e) {
                _logger.error((Object)"Deploy vCenter HA failover operation failed", (Throwable)e);
                result.error = ErrorTransformUtil.convertError((Exception)e);
            }
        }
        return result;
    }

    private void populateSourceNodeSpec(FailoverClusterConfigurator.SourceNodeSpec sourceNodeSpec, ManagedObjectReference rootFolderRef, VchaDeploySpec spec) {
        sourceNodeSpec.managementVc = this._serviceLocatorFactory.newServiceLocator(spec.sourceVm.getServerGuid(), AuthSessionUtil.getSsoToken(), rootFolderRef.getServerGuid());
        sourceNodeSpec.activeVc = spec.sourceVm;
    }

    private void populateNodeDeploymentSpec(FailoverClusterConfigurator.NodeDeploymentSpec nodeDeploymentSpec, ManagedObjectReference rootFolderRef, VchaDeployNodeSpec spec, boolean isWitness) {
        nodeDeploymentSpec.nodeName = spec.vmName;
        nodeDeploymentSpec.managementVc = this._serviceLocatorFactory.newServiceLocator(spec.vmFolder.getServerGuid(), AuthSessionUtil.getSsoToken(), rootFolderRef.getServerGuid());
        nodeDeploymentSpec.folder = spec.vmFolder;
        if (spec.host != null) {
            nodeDeploymentSpec.esxHost = spec.host;
        } else {
            nodeDeploymentSpec.resourcePool = spec.resourcePool;
        }
        nodeDeploymentSpec.datastore = spec.datastore;
        nodeDeploymentSpec.clusterNetworkPortGroup = spec.clusterNetwork;
        nodeDeploymentSpec.ipSettings = spec.clusterIpSettings;
        if (!isWitness) {
            nodeDeploymentSpec.publicNetworkPortGroup = spec.publicNetwork;
            if (nodeDeploymentSpec instanceof FailoverClusterConfigurator.PassiveNodeDeploymentSpec && spec.publicIpSettings != null && (spec.publicIpSettings.ip != null || spec.publicIpSettings.ipV6Spec != null)) {
                ((FailoverClusterConfigurator.PassiveNodeDeploymentSpec)nodeDeploymentSpec).failoverIpSettings = spec.publicIpSettings;
            }
        }
    }

    private void populateClusterNetworkConfigSpec(FailoverClusterConfigurator.VchaClusterDeploymentSpec deploymentSpec, VchaDeployNodeSpec spec) {
        if (spec == null || spec.clusterNetwork == null || spec.clusterIpSettings == null) {
            return;
        }
        deploymentSpec.activeVcNetworkConfig = new FailoverClusterConfigurator.ClusterNetworkConfigSpec();
        deploymentSpec.activeVcNetworkConfig.networkPortGroup = spec.clusterNetwork;
        deploymentSpec.activeVcNetworkConfig.ipSettings = spec.clusterIpSettings;
    }

    private BaseCommandSpec createVchaManageCommands(ManagedObjectReference rootFolderRef, VchaManageSpec spec) {
        DummyCommandSpec rootCmdSpec = new DummyCommandSpec();
        rootCmdSpec.mor = rootFolderRef;
        Object lastCmdSpec = rootCmdSpec;
        if (spec.clusterMode != null) {
            VchaSetModeCommandSpec setModeCmdSpec = new VchaSetModeCommandSpec();
            setModeCmdSpec.mor = lastCmdSpec.mor;
            setModeCmdSpec.clusterMode = spec.clusterMode;
            VchaUtil.appendDependentCommandSpec((BaseCommandSpec)lastCmdSpec, setModeCmdSpec);
            lastCmdSpec = setModeCmdSpec;
            _logger.debug((Object)"VCHA set mode command added.");
        }
        if (spec.removeConfiguration) {
            VchaRemoveCommandSpec removeCmdSpec = new VchaRemoveCommandSpec();
            removeCmdSpec.mor = lastCmdSpec.mor;
            VchaUtil.appendDependentCommandSpec((BaseCommandSpec)lastCmdSpec, removeCmdSpec);
            lastCmdSpec = removeCmdSpec;
            _logger.debug((Object)"VCHA configuration removal command added.");
        }
        if (spec.removeConfiguration && spec.deleteDetachedVms) {
            VchaClusterVmInfo clusterVm = null;
            try {
                clusterVm = (VchaClusterVmInfo)((Object)this._queryExecutor.getProperty((Object)rootFolderRef, PROPERTY_CLUSTER_VM));
            }
            catch (Exception e) {
                _logger.warn((Object)VchaUtil.getLocalizedString("warning.vchaVmDelete.noVmInfo"));
            }
            if (clusterVm != null && clusterVm.passiveVm != null) {
                this.populateVmDeleteCmdSpec((BaseCommandSpec)lastCmdSpec, clusterVm.passiveVm);
            } else {
                _logger.info((Object)VchaUtil.getLocalizedString("info.vchaVmDelete.noPassiveNodeVm"));
            }
            if (clusterVm != null && clusterVm.witnessVm != null) {
                this.populateVmDeleteCmdSpec((BaseCommandSpec)lastCmdSpec, clusterVm.witnessVm);
            } else {
                _logger.info((Object)VchaUtil.getLocalizedString("info.vchaVmDelete.noWitnessNodeVm"));
            }
            _logger.debug((Object)"VCHA delete detached VMs command added.");
        }
        return rootCmdSpec;
    }

    private void populateVmDeleteCmdSpec(BaseCommandSpec parentCmdSpec, ManagedObjectReference vmRef) {
        VirtualMachine.PowerState powerState = null;
        try {
            powerState = (VirtualMachine.PowerState)this._queryExecutor.getProperty((Object)vmRef, PROPERTY_VM_POWER_STATE);
        }
        catch (Exception e) {
            _logger.error((Object)"VM power state cannot be retrieved.");
        }
        if (powerState == null) {
            return;
        }
        BaseCommandSpec lastCmdSpec = parentCmdSpec;
        if (powerState.equals((Object)VirtualMachine.PowerState.poweredOn)) {
            VchaPowerOffVmCommandSpec powerOffCmdSpec = new VchaPowerOffVmCommandSpec();
            powerOffCmdSpec.mor = lastCmdSpec.mor;
            powerOffCmdSpec.formerVchaVm = vmRef;
            VchaUtil.appendDependentCommandSpec(lastCmdSpec, powerOffCmdSpec);
            lastCmdSpec = powerOffCmdSpec;
            _logger.debug((Object)"VCHA power off detached VM command added.");
        }
        VchaDeleteVmCommandSpec deleteCmdSpec = new VchaDeleteVmCommandSpec();
        deleteCmdSpec.mor = lastCmdSpec.mor;
        deleteCmdSpec.formerVchaVm = vmRef;
        VchaUtil.appendDependentCommandSpec(lastCmdSpec, deleteCmdSpec);
        _logger.debug((Object)"VCHA delete detached VM command added.");
    }
}

