/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcha.impl;

import com.vmware.vim.binding.vim.vcha.FailoverClusterConfigurator;
import com.vmware.vim.binding.vim.vcha.FailoverClusterManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.vcha.impl.VchaMockDataProvider;
import com.vmware.vsphere.client.vcha.util.VchaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaPropertyProvider
implements PropertyProviderBean {
    private static final String SESSION_VCHA_DATA_EXPIRABLECACHE = "com.vmware.vsphere.client.vcha.util.SESSION_VCHA_DATA_EXPIRABLECACHE";
    private static final String SESSION_VCHA_CLUSTER_SYNC = "com.vmware.vsphere.client.vcha.util.SESSION_VCHA_SYNC";
    private static final short SESSION_VCHA_CLUSTER_EXPIRABLECACHE_TIMEOUT = 2000;
    private static final long DATA_RETRIVAL_DESIGN_TIMEOUT = 40L;
    private static final String VIMFAULT_INVALID_LICENSE = "vim.fault.InvalidLicense";
    private static final String VIMFAULT_INVALID_STATE = "vim.fault.InvalidState";
    private static final String METHOD_NAME_CONFIG = "configure";
    private static final String METHOD_NAME_DEPLOY = "deploy";
    private static final String METHOD_NAME_PREPARE = "prepare";
    private static final String METHOD_NAME_CREATE_PASSIVE = "createPassiveNode";
    private static final String METHOD_NAME_CREATE_WITNESS = "createWitnessNode";
    private static final String METHOD_NAME_DESTROY = "destroy";
    private static final String METHOD_NAME_SET_MODE = "setClusterMode";
    private static final String METHOD_NAME_INIT_FAILOVER = "initiateFailover";
    private static final Log _logger = LogFactory.getLog(VchaPropertyProvider.class);
    private VchaMockDataProvider _mockDataProvider;

    public VchaPropertyProvider(VchaMockDataProvider mockDataProvider) {
        this._mockDataProvider = mockDataProvider;
    }

    @type(value="Folder")
    public String getVchaClusterMode(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return null;
        }
        if (this._mockDataProvider.getUseMockData("vchaClusterMode")) {
            _logger.debug((Object)"Loading VCHA cluster mode from the mock data.");
            return this._mockDataProvider.getClusterMode();
        }
        VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
        return vchaData.vchaClusterMode;
    }

    @type(value="Folder")
    public FailoverClusterManager.VchaClusterHealth getVchaClusterHealth(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return null;
        }
        if (this._mockDataProvider.getUseMockData("vchaClusterHealth")) {
            _logger.debug((Object)"Loading VCHA cluster health from the mock data.");
            return this._mockDataProvider.getClusterHealth();
        }
        VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
        return vchaData.vchaClusterHealth;
    }

    @type(value="Folder")
    public FailoverClusterConfigurator.VchaClusterConfigInfo getVchaConfig(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return null;
        }
        if (this._mockDataProvider.getUseMockData("vchaClusterConfig")) {
            _logger.debug((Object)"Loading VCHA cluster configuration from the mock data.");
            return this._mockDataProvider.getConfig();
        }
        VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
        return vchaData.vchaClusterConfig;
    }

    @type(value="Folder")
    public boolean getVchaIsClusterVmAware(ManagedObjectReference rootFolderRef) throws Exception {
        FailoverClusterConfigurator.VchaClusterConfigInfo vchaClusterInfo = this.getVchaConfig(rootFolderRef);
        if (vchaClusterInfo == null) {
            return false;
        }
        if (vchaClusterInfo.failoverNodeInfo1 == null || vchaClusterInfo.failoverNodeInfo2 == null || vchaClusterInfo.witnessNodeInfo == null) {
            return false;
        }
        return !StringUtil.isNullOrEmpty((String)vchaClusterInfo.failoverNodeInfo1.biosUuid) && !StringUtil.isNullOrEmpty((String)vchaClusterInfo.failoverNodeInfo2.biosUuid) && !StringUtil.isNullOrEmpty((String)vchaClusterInfo.witnessNodeInfo.biosUuid);
    }

    @type(value="Folder")
    public boolean getVchaIsConfigured(ManagedObjectReference rootFolderRef) throws Exception {
        return this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.configured);
    }

    @type(value="Folder")
    public boolean getVchaIsConfigPrepared(ManagedObjectReference rootFolderRef) throws Exception {
        return this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.prepared);
    }

    @type(value="Folder")
    public boolean getVchaIsSupported(ManagedObjectReference rootFolderRef) throws Exception {
        if (this._mockDataProvider.getUseMockData("vchaIsSupported")) {
            return this._mockDataProvider.getVchaIsSupported();
        }
        VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
        return vchaData.isCapable && vchaData.isLicensed;
    }

    @type(value="Folder")
    public boolean getVchaIsNewCfgRelevant(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return false;
        }
        return this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.notConfigured) || this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.prepared);
    }

    @type(value="Folder")
    public boolean getVchaIsRemoveInvalidCfgRelevant(ManagedObjectReference rootFolderRef) throws Exception {
        return this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.prepared) || this.getIsInConfigState(rootFolderRef, FailoverClusterConfigurator.VchaState.invalid);
    }

    @type(value="Folder")
    public boolean getVchaIsEditClusterRelevant(ManagedObjectReference rootFolderRef) throws Exception {
        return this.getVchaIsConfigured(rootFolderRef);
    }

    @type(value="Folder")
    public boolean getVchaIsNewCfgAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_CONFIG) && !this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_DEPLOY)) {
            _logger.debug((Object)"Method calls disabled: configure deploy");
            return false;
        }
        return true;
    }

    @type(value="Folder")
    public boolean getVchaIsRedeployPassiveAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_CREATE_PASSIVE)) {
            _logger.debug((Object)"Method call disabled: createPassiveNode");
            return false;
        }
        return true;
    }

    @type(value="Folder")
    public boolean getVchaIsRedeployWitnessAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_CREATE_WITNESS)) {
            _logger.debug((Object)"Method call disabled: createWitnessNode");
            return false;
        }
        return true;
    }

    @type(value="Folder")
    public boolean getVchaIsRemoveInvalidCfgAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_DESTROY)) {
            _logger.debug((Object)"Method call disabled: destroy");
            return false;
        }
        return true;
    }

    @type(value="Folder")
    public boolean getVchaIsEditAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_SET_MODE)) {
            _logger.debug((Object)"Method call disabled: setClusterMode");
            return false;
        }
        return true;
    }

    @type(value="Folder")
    public boolean getVchaIsFailoverAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        if (!this.getIsMethodEnabled(rootFolderRef, METHOD_NAME_INIT_FAILOVER)) {
            _logger.debug((Object)"Method call disabled: initiateFailover");
            return false;
        }
        FailoverClusterManager.VchaClusterHealth vchaClusterHealth = this.getVchaClusterHealth(rootFolderRef);
        if (vchaClusterHealth == null || vchaClusterHealth.runtimeInfo == null || vchaClusterHealth.runtimeInfo.nodeInfo == null) {
            return false;
        }
        boolean isClusterRunning = FailoverClusterManager.VchaClusterMode.enabled.name().equals(vchaClusterHealth.runtimeInfo.clusterMode) || FailoverClusterManager.VchaClusterMode.maintenance.name().equals(vchaClusterHealth.runtimeInfo.clusterMode);
        boolean allNodesUp = true;
        for (FailoverClusterManager.VchaNodeRuntimeInfo nodeInfo : vchaClusterHealth.runtimeInfo.nodeInfo) {
            if (nodeInfo != null && FailoverClusterManager.VchaNodeState.up.name().equals(nodeInfo.nodeState)) continue;
            allNodesUp = false;
            break;
        }
        boolean isNotIsolated = !FailoverClusterManager.VchaClusterState.isolated.name().equals(vchaClusterHealth.runtimeInfo.clusterState);
        return isClusterRunning && allNodesUp && isNotIsolated;
    }

    @type(value="Folder")
    public boolean getVchaIsClusterBeingPrepared(ManagedObjectReference rootFolderRef) throws Exception {
        if (this.isMethodEnabledTwice(rootFolderRef, METHOD_NAME_PREPARE)) {
            _logger.debug((Object)"Method call being executed: prepare");
            return true;
        }
        return false;
    }

    @type(value="Folder")
    public boolean getVchaIsClusterBeingConfigured(ManagedObjectReference rootFolderRef) throws Exception {
        if (this.isMethodEnabledTwice(rootFolderRef, METHOD_NAME_CONFIG)) {
            _logger.debug((Object)"Method call being executed: configure");
            return true;
        }
        return false;
    }

    @type(value="Folder")
    public boolean getVchaIsClusterBeingDeployed(ManagedObjectReference rootFolderRef) throws Exception {
        if (this.isMethodEnabledTwice(rootFolderRef, METHOD_NAME_DEPLOY)) {
            _logger.debug((Object)"Method call being executed: deploy");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VchaDataInternal getVchaData(ManagedObjectReference rootFolderRef) throws Exception {
        Object lock;
        VchaDataInternal vchaData = (VchaDataInternal)SessionUtil.getData((String)SESSION_VCHA_DATA_EXPIRABLECACHE);
        if (vchaData != null && rootFolderRef.equals((Object)vchaData.rootFolderRef)) {
            return vchaData;
        }
        Object object = lock = SessionUtil.getSyncObject((String)SESSION_VCHA_CLUSTER_SYNC, null);
        synchronized (object) {
            vchaData = (VchaDataInternal)SessionUtil.getData((String)SESSION_VCHA_DATA_EXPIRABLECACHE);
            if (vchaData != null && rootFolderRef.equals((Object)vchaData.rootFolderRef)) {
                return vchaData;
            }
            vchaData = new VchaDataInternal();
            vchaData.rootFolderRef = rootFolderRef;
            vchaData.isCapable = VcServiceUtil.is65VcOrLaterByServerGuid((String)rootFolderRef.getServerGuid());
            vchaData.isLicensed = true;
            if (!vchaData.isCapable) {
                return vchaData;
            }
            long start = 0L;
            if (_logger.isDebugEnabled()) {
                start = System.nanoTime();
            }
            FailoverClusterConfigurator fcConfigurator = null;
            FailoverClusterManager fcManager = null;
            try {
                fcConfigurator = VchaUtil.getFailoverClusterConfigurator(rootFolderRef);
                fcManager = VchaUtil.getFailoverClusterManager(rootFolderRef);
            }
            catch (Exception e) {
                _logger.debug((Object)"MORs not found - VCHA is not available on this windows VC");
                return vchaData;
            }
            ClientFutureImpl futureConfig = new ClientFutureImpl();
            fcConfigurator.getConfig((Future)futureConfig);
            ClientFutureImpl futureCfgDisabledMethods = new ClientFutureImpl();
            fcConfigurator.getDisabledConfigureMethod((Future)futureCfgDisabledMethods);
            ClientFutureImpl futureHealth = new ClientFutureImpl();
            fcManager.getClusterHealth((Future)futureHealth);
            ClientFutureImpl futureMode = new ClientFutureImpl();
            fcManager.getClusterMode((Future)futureMode);
            ClientFutureImpl futureMgrDisabledMethods = new ClientFutureImpl();
            fcManager.getDisabledClusterMethod((Future)futureMgrDisabledMethods);
            long pollTimeout = 1L;
            while (!(futureConfig.isDone() && futureCfgDisabledMethods.isDone() && futureHealth.isDone() && futureMode.isDone() && futureMgrDisabledMethods.isDone())) {
                Thread.sleep(pollTimeout);
                pollTimeout = 3L;
                _logger.debug((Object)"Waiting to complete all VCHA API requests");
            }
            try {
                vchaData.vchaClusterConfig = (FailoverClusterConfigurator.VchaClusterConfigInfo)futureConfig.get();
                _logger.debug((Object)vchaData.vchaClusterConfig);
            }
            catch (Exception e) {
                if (this.isExpectedVimError(e, VIMFAULT_INVALID_LICENSE)) {
                    vchaData.isLicensed = false;
                    _logger.debug((Object)"Config: VCHA is not licensed for this VC");
                }
                _logger.error((Object)"Error retrieving VCHA config: ", (Throwable)e);
                throw e;
            }
            ArrayList<String> disabledMethods = new ArrayList<String>();
            try {
                disabledMethods.addAll(this.getMethodNames((MethodName[])futureCfgDisabledMethods.get()));
            }
            catch (Exception e) {
                _logger.error((Object)"Error retrieving VCHA configurator disabled methods: ", (Throwable)e);
                throw e;
            }
            try {
                vchaData.vchaClusterHealth = (FailoverClusterManager.VchaClusterHealth)futureHealth.get();
                _logger.debug((Object)vchaData.vchaClusterHealth);
            }
            catch (Exception e) {
                if (this.isExpectedVimError(e, VIMFAULT_INVALID_STATE)) {
                    _logger.debug((Object)"Health: VCHA is not configured.");
                }
                if (this.isExpectedVimError(e, VIMFAULT_INVALID_LICENSE)) {
                    _logger.debug((Object)"Health: VCHA is not licensed for this VC.");
                }
                _logger.error((Object)"Error retrieving VCHA health data: ", (Throwable)e);
                throw e;
            }
            try {
                vchaData.vchaClusterMode = (String)futureMode.get();
                _logger.debug((Object)vchaData.vchaClusterMode);
            }
            catch (Exception e) {
                if (this.isExpectedVimError(e, VIMFAULT_INVALID_STATE)) {
                    _logger.debug((Object)"Mode: VCHA is not configured.");
                }
                if (this.isExpectedVimError(e, VIMFAULT_INVALID_LICENSE)) {
                    _logger.debug((Object)"Mode: VCHA is not licensed for this VC.");
                }
                _logger.error((Object)"Error retrieving VCHA mode: ", (Throwable)e);
                throw e;
            }
            try {
                disabledMethods.addAll(this.getMethodNames((MethodName[])futureMgrDisabledMethods.get()));
            }
            catch (Exception e) {
                _logger.error((Object)"Error retrieving VCHA manager disabled methods: ", (Throwable)e);
                throw e;
            }
            vchaData.disabledMethods = disabledMethods;
            if (_logger.isDebugEnabled()) {
                long end = System.nanoTime();
                long elapsed = (end - start) / 1000000L;
                if (40L > elapsed) {
                    _logger.debug((Object)String.format("VCHA data was retrieved for %d ms.", elapsed));
                } else {
                    _logger.error((Object)String.format("VCHA data was retrieved for %d ms. This is above the expected design threshold of %d ms.", elapsed, 40L));
                }
            }
            SessionUtil.setExpirableData((String)SESSION_VCHA_DATA_EXPIRABLECACHE, (Object)vchaData, (int)2000);
        }
        return vchaData;
    }

    private boolean getIsInConfigState(ManagedObjectReference rootFolderRef, FailoverClusterConfigurator.VchaState requiredState) throws Exception {
        FailoverClusterConfigurator.VchaClusterConfigInfo vchaClusterInfo = this.getVchaConfig(rootFolderRef);
        return vchaClusterInfo != null && requiredState != null && requiredState.name().equalsIgnoreCase(vchaClusterInfo.state);
    }

    private boolean getIsMethodEnabled(ManagedObjectReference rootFolderRef, String methodName) throws Exception {
        List<String> disabledMethods;
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return false;
        }
        if (this._mockDataProvider.getUseMockData("vchaDisabledMethods")) {
            _logger.debug((Object)"Loading VCHA disabled methods from the mock data.");
            disabledMethods = this._mockDataProvider.getVchaDisabledMethods();
        } else {
            VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
            disabledMethods = vchaData.disabledMethods;
        }
        return !disabledMethods.contains(methodName);
    }

    private boolean isMethodEnabledTwice(ManagedObjectReference rootFolderRef, String methodName) throws Exception {
        List<String> disabledMethods;
        if (!this.getVchaIsSupported(rootFolderRef)) {
            _logger.debug((Object)"VCHA feature is NOT supported.");
            return false;
        }
        if (this._mockDataProvider.getUseMockData("vchaDisabledMethods")) {
            _logger.debug((Object)"Loading VCHA disabled methods from the mock data.");
            disabledMethods = this._mockDataProvider.getVchaDisabledMethods();
        } else {
            VchaDataInternal vchaData = this.getVchaData(rootFolderRef);
            disabledMethods = vchaData.disabledMethods;
        }
        return Collections.frequency(disabledMethods, methodName) == 2;
    }

    private List<String> getMethodNames(MethodName[] methodNames) {
        ArrayList<String> disabledMethodNames = new ArrayList<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])methodNames)) {
            return disabledMethodNames;
        }
        for (MethodName methodName : methodNames) {
            String methodNameStr;
            if (methodName == null || StringUtil.isNullOrEmpty((String)(methodNameStr = methodName.getName()))) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("VCHA method " + methodNameStr + " is diabled."));
            }
            disabledMethodNames.add(methodNameStr);
        }
        return disabledMethodNames;
    }

    private boolean isExpectedVimError(Exception exception, String expectedVimFault) {
        Throwable cause;
        if (StringUtil.isNullOrEmpty((String)expectedVimFault)) {
            return false;
        }
        return exception instanceof ExecutionException && (cause = exception.getCause()) != null && expectedVimFault.equals(cause.getMessage());
    }

    public class VchaDataInternal {
        public ManagedObjectReference rootFolderRef;
        public boolean isLicensed;
        public boolean isCapable;
        public FailoverClusterConfigurator.VchaClusterConfigInfo vchaClusterConfig;
        public String vchaClusterMode;
        public FailoverClusterManager.VchaClusterHealth vchaClusterHealth;
        public List<String> disabledMethods;
    }
}

